/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.declaration.MemberDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.PackageDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public abstract class TypeDeclarationImpl
extends MemberDeclarationImpl
implements TypeDeclaration,
DeclaredType,
EclipseMirrorType {
    private static final String HAS_INCONSISTENT_TYPE_HIERACHY = "has inconsistent hierarchy";

    public TypeDeclarationImpl(ITypeBinding binding, BaseProcessorEnv env) {
        super((IBinding)binding, env);
    }

    @Override
    public String getQualifiedName() {
        ITypeBinding type = this.getTypeBinding();
        return type.getQualifiedName();
    }

    @Override
    public String getSimpleName() {
        ITypeBinding type = this.getTypeBinding();
        return type.getName();
    }

    @Override
    public PackageDeclaration getPackage() {
        ITypeBinding binding = this.getDeclarationBinding();
        return new PackageDeclarationImpl(binding.getPackage(), this, this._env, false);
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visitTypeDeclaration(this);
    }

    @Override
    public ITypeBinding getTypeBinding() {
        return (ITypeBinding)this._binding;
    }

    private void getASTFields(AbstractTypeDeclaration typeDecl, List<com.sun.mirror.declaration.FieldDeclaration> results) {
        List bodyDecls = typeDecl.bodyDeclarations();
        int i = 0;
        int len = bodyDecls.size();
        while (i < len) {
            BodyDeclaration bodyDecl = (BodyDeclaration)bodyDecls.get(i);
            IFile file = null;
            if (bodyDecl.getNodeType() == 23) {
                List fragments = ((FieldDeclaration)bodyDecl).fragments();
                for (VariableDeclarationFragment frag : fragments) {
                    EclipseDeclarationImpl decl;
                    IVariableBinding fieldBinding = frag.resolveBinding();
                    if (fieldBinding != null) continue;
                    if (file == null) {
                        file = this.getResource();
                    }
                    if ((decl = Factory.createDeclaration((ASTNode)frag, file, this._env)) == null) continue;
                    results.add((com.sun.mirror.declaration.FieldDeclaration)((Object)decl));
                }
            }
            ++i;
        }
    }

    @Override
    public Collection<com.sun.mirror.declaration.FieldDeclaration> getFields() {
        IVariableBinding[] fields;
        ASTNode node;
        ArrayList<com.sun.mirror.declaration.FieldDeclaration> results = new ArrayList<com.sun.mirror.declaration.FieldDeclaration>();
        ITypeBinding typeBinding = this.getDeclarationBinding();
        if (this.isFromSource() && (node = this._env.getASTNodeForBinding((IBinding)typeBinding)) != null) {
            switch (node.getNodeType()) {
                case 55: 
                case 71: 
                case 81: {
                    AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)node;
                    this.getASTFields(typeDecl, results);
                    break;
                }
                default: {
                    throw new IllegalStateException("expecting a AbstractTypeDeclaration but got " + node.getClass().getName());
                }
            }
        }
        IVariableBinding[] iVariableBindingArray = fields = typeBinding.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            EclipseDeclarationImpl mirrorDecl;
            IVariableBinding field = iVariableBindingArray[n2];
            if (!field.isSynthetic() && !HAS_INCONSISTENT_TYPE_HIERACHY.equals(field.getName()) && (mirrorDecl = Factory.createDeclaration((IBinding)field, this._env)) != null) {
                results.add((com.sun.mirror.declaration.FieldDeclaration)((Object)mirrorDecl));
            }
            ++n2;
        }
        return results;
    }

    @Override
    public Collection<TypeDeclaration> getNestedTypes() {
        ITypeBinding[] memberTypes = this.getDeclarationBinding().getDeclaredTypes();
        ArrayList<TypeDeclaration> results = new ArrayList<TypeDeclaration>(memberTypes.length);
        ITypeBinding[] iTypeBindingArray = memberTypes;
        int n = memberTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding type = iTypeBindingArray[n2];
            TypeDeclarationImpl mirrorDecl = Factory.createReferenceType(type, this._env);
            if (mirrorDecl != null) {
                results.add(mirrorDecl);
            }
            ++n2;
        }
        return results;
    }

    @Override
    public Collection<TypeParameterDeclaration> getFormalTypeParameters() {
        ITypeBinding[] typeParams = this.getDeclarationBinding().getTypeParameters();
        ArrayList<TypeParameterDeclaration> results = new ArrayList<TypeParameterDeclaration>(typeParams.length);
        ITypeBinding[] iTypeBindingArray = typeParams;
        int n = typeParams.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeParam = iTypeBindingArray[n2];
            EclipseDeclarationImpl mirrorDecl = Factory.createDeclaration((IBinding)typeParam, this._env);
            if (mirrorDecl != null) {
                results.add((TypeParameterDeclaration)((Object)mirrorDecl));
            }
            ++n2;
        }
        return results;
    }

    @Override
    public TypeDeclaration getDeclaringType() {
        ITypeBinding decl = this.getDeclarationBinding();
        if (decl.isMember()) {
            return Factory.createReferenceType(decl.getDeclaringClass(), this._env);
        }
        return null;
    }

    @Override
    public Collection<TypeMirror> getActualTypeArguments() {
        ITypeBinding type = this.getTypeBinding();
        ITypeBinding[] typeArgs = type.getTypeArguments();
        if (typeArgs == null || typeArgs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<TypeMirror> result = new ArrayList<TypeMirror>(typeArgs.length);
        ITypeBinding[] iTypeBindingArray = typeArgs;
        int n = typeArgs.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding arg = iTypeBindingArray[n2];
            EclipseMirrorType mirror = Factory.createTypeMirror(arg, this._env);
            if (mirror == null) {
                result.add(Factory.createErrorClassType(arg));
            } else {
                result.add(mirror);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public DeclaredType getContainingType() {
        ITypeBinding outer = this.getTypeBinding().getDeclaringClass();
        return Factory.createReferenceType(outer, this._env);
    }

    @Override
    public TypeDeclaration getDeclaration() {
        ITypeBinding declBinding = this.getDeclarationBinding();
        if (declBinding == this._binding) {
            return this;
        }
        return Factory.createReferenceType(declBinding, this._env);
    }

    @Override
    public Collection<InterfaceType> getSuperinterfaces() {
        ITypeBinding[] superInterfaceBindings = this.getDeclarationBinding().getInterfaces();
        if (superInterfaceBindings == null || superInterfaceBindings.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<InterfaceType> results = new ArrayList<InterfaceType>(superInterfaceBindings.length);
        ITypeBinding[] iTypeBindingArray = superInterfaceBindings;
        int n = superInterfaceBindings.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding binding = iTypeBindingArray[n2];
            if (binding.isInterface()) {
                TypeDeclarationImpl mirrorDecl = Factory.createReferenceType(binding, this._env);
                if (mirrorDecl != null && mirrorDecl.kind() == EclipseMirrorObject.MirrorKind.TYPE_INTERFACE) {
                    results.add((InterfaceType)((Object)mirrorDecl));
                }
            } else {
                results.add(Factory.createErrorInterfaceType(binding));
            }
            ++n2;
        }
        return results;
    }

    public ITypeBinding getDeclarationBinding() {
        ITypeBinding type = this.getTypeBinding();
        return type.getTypeDeclaration();
    }

    protected void getASTMethods(AbstractTypeDeclaration typeDecl, List<MethodDeclaration> results) {
        List bodyDecls = typeDecl.bodyDeclarations();
        IFile file = null;
        int i = 0;
        int len = bodyDecls.size();
        while (i < len) {
            BodyDeclaration bodyDecl = (BodyDeclaration)bodyDecls.get(i);
            switch (bodyDecl.getNodeType()) {
                case 31: {
                    MethodDeclaration mirrorDecl;
                    IMethodBinding methodBinding;
                    org.eclipse.jdt.core.dom.MethodDeclaration methodDecl = (org.eclipse.jdt.core.dom.MethodDeclaration)bodyDecl;
                    if (methodDecl.isConstructor() || (methodBinding = methodDecl.resolveBinding()) != null) break;
                    if (file == null) {
                        file = this.getResource();
                    }
                    if ((mirrorDecl = (MethodDeclaration)((Object)Factory.createDeclaration((ASTNode)methodDecl, file, this._env))) == null) break;
                    results.add(mirrorDecl);
                    break;
                }
                case 82: {
                    MethodDeclaration mirrorDecl;
                    AnnotationTypeMemberDeclaration memberDecl = (AnnotationTypeMemberDeclaration)bodyDecl;
                    IMethodBinding methodBinding = memberDecl.resolveBinding();
                    if (methodBinding != null) break;
                    if (file == null) {
                        file = this.getResource();
                    }
                    if ((mirrorDecl = (MethodDeclaration)((Object)Factory.createDeclaration((ASTNode)memberDecl, file, this._env))) == null) break;
                    results.add(mirrorDecl);
                }
            }
            ++i;
        }
    }

    protected List<? extends MethodDeclaration> _getMethods() {
        IMethodBinding[] methods;
        ITypeBinding typeBinding;
        ASTNode node;
        ArrayList<MethodDeclaration> results = new ArrayList<MethodDeclaration>();
        if (this.isFromSource() && (node = this._env.getASTNodeForBinding((IBinding)(typeBinding = this.getDeclarationBinding()))) != null) {
            switch (node.getNodeType()) {
                case 55: 
                case 71: 
                case 81: {
                    AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)node;
                    this.getASTMethods(typeDecl, results);
                    break;
                }
                default: {
                    throw new IllegalStateException("expecting a AbstractTypeDeclaration but got " + node.getClass().getName());
                }
            }
        }
        IMethodBinding[] iMethodBindingArray = methods = this.getDeclarationBinding().getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            EclipseDeclarationImpl mirrorDecl;
            IMethodBinding method = iMethodBindingArray[n2];
            if (!method.isConstructor() && !method.isSynthetic() && (mirrorDecl = Factory.createDeclaration((IBinding)method, this._env)) != null) {
                results.add((MethodDeclaration)((Object)mirrorDecl));
            }
            ++n2;
        }
        return results;
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public boolean isFromSource() {
        return this.getDeclarationBinding().isFromSource();
    }

    @Override
    public boolean isAssignmentCompatible(EclipseMirrorType left) {
        ITypeBinding leftBinding = left.getTypeBinding();
        if (leftBinding.isPrimitive()) {
            return this.getTypeBinding().isAssignmentCompatible(leftBinding);
        }
        return this.isSubTypeCompatible(left);
    }

    @Override
    public boolean isSubTypeCompatible(EclipseMirrorType type) {
        ITypeBinding thisErased = this.getTypeBinding().getErasure();
        ITypeBinding typeErased = type.getTypeBinding().getErasure();
        if (this.kind() == EclipseMirrorObject.MirrorKind.TYPE_CLASS) {
            if (type.kind() == EclipseMirrorObject.MirrorKind.TYPE_CLASS) {
                return TypeDeclarationImpl.isSubClassOf(thisErased, typeErased);
            }
            if (type.kind() == EclipseMirrorObject.MirrorKind.TYPE_INTERFACE) {
                return TypeDeclarationImpl.isImplementorOf(thisErased, typeErased);
            }
            return false;
        }
        if (type.kind() == EclipseMirrorObject.MirrorKind.TYPE_INTERFACE) {
            return TypeDeclarationImpl.isImplementorOf(thisErased, typeErased);
        }
        if (type.kind() == EclipseMirrorObject.MirrorKind.TYPE_CLASS) {
            return "java.lang.Object".equals(this.getQualifiedName());
        }
        return false;
    }

    private static boolean isImplementorOf(ITypeBinding t1, ITypeBinding t2) {
        ITypeBinding[] intfs;
        if (TypeDeclarationImpl.eq(t1, t2)) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = intfs = t1.getInterfaces();
        int n = intfs.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding intf = iTypeBindingArray[n2];
            if (TypeDeclarationImpl.isImplementorOf(intf.getErasure(), t2)) {
                return true;
            }
            ++n2;
        }
        ITypeBinding superClass = t1.getSuperclass();
        return superClass != null && TypeDeclarationImpl.isImplementorOf(superClass, t2);
    }

    private static boolean isSubClassOf(ITypeBinding t1, ITypeBinding t2) {
        while (t1 != null) {
            if (TypeDeclarationImpl.eq(t1, t2)) {
                return true;
            }
            t1 = t1.getSuperclass();
        }
        return false;
    }

    private static boolean eq(ITypeBinding t1, ITypeBinding t2) {
        return t1.getQualifiedName().equals(t2.getQualifiedName());
    }
}

