/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IScalablePane;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.internal.InternalDraw2dUtils;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;

public class ScalableLightweightSystem
extends LightweightSystem {
    @Override
    public void setControl(Canvas c) {
        if (c == null) {
            return;
        }
        InternalDraw2dUtils.configureForAutoscalingMode((Control)c, this.getRootFigure()::setScale);
        super.setControl(c);
    }

    @Override
    protected ScalableRootFigure createRootFigure() {
        ScalableRootFigure f = new ScalableRootFigure();
        f.addNotify();
        f.setOpaque(true);
        f.setLayoutManager(new StackLayout());
        return f;
    }

    @Override
    public ScalableFigure getRootFigure() {
        return (ScalableFigure)super.getRootFigure();
    }

    private class ScalableRootFigure
    extends LightweightSystem.RootFigure
    implements IScalablePane {
        private double scale = 1.0;

        private ScalableRootFigure() {
        }

        @Override
        public void setScale(double scale) {
            if (this.scale == scale) {
                return;
            }
            this.scale = scale;
            this.fireFigureMoved();
            this.fireCoordinateSystemChanged();
            this.revalidate();
            this.repaint();
        }

        @Override
        public double getScale() {
            return this.scale;
        }

        @Override
        public boolean useScaledGraphics() {
            return true;
        }

        @Override
        public boolean optimizeClip() {
            return super.optimizeClip();
        }

        @Override
        public Rectangle getClientArea(Rectangle rect) {
            return IScalablePane.IScalablePaneHelper.getClientArea(this, rectangle -> super.getClientArea((Rectangle)rectangle), rect);
        }

        @Override
        public Dimension getMinimumSize(int wHint, int hHint) {
            return IScalablePane.IScalablePaneHelper.getMinimumSize(this, (n, n2) -> super.getMinimumSize((int)n, (int)n2), wHint, hHint);
        }

        @Override
        public Dimension getPreferredSize(int wHint, int hHint) {
            return IScalablePane.IScalablePaneHelper.getPreferredSize(this, (n, n2) -> super.getPreferredSize((int)n, (int)n2), wHint, hHint);
        }

        @Override
        protected void paintClientArea(Graphics graphics2) {
            IScalablePane.IScalablePaneHelper.paintClientArea(this, graphics -> super.paintClientArea((Graphics)graphics), graphics2);
        }

        @Override
        public void translateToParent(Translatable t) {
            IScalablePane.IScalablePaneHelper.translateToParent(this, t);
        }

        @Override
        public void translateFromParent(Translatable t) {
            IScalablePane.IScalablePaneHelper.translateFromParent(this, t);
        }

        @Override
        protected boolean useDoublePrecision() {
            return true;
        }
    }
}

