/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;

public class SQLValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private int _position;
    private ITextViewer _viewer;
    private IContextInformation _information;
    private int _currentParameter;

    public void install(IContextInformation info, ITextViewer viewer, int documentPosition) {
        this._position = documentPosition;
        this._viewer = viewer;
        this._information = info;
        this._currentParameter = -1;
    }

    private int getCommentEnd(IDocument d, int pos, int end) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            if (curr != '*' || ++pos >= end || d.getChar(pos) != '/') continue;
            return pos + 1;
        }
        return end;
    }

    private int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }

    private int getCharCount(IDocument document, int start, int end, String increments, String decrements, boolean considerNesting) throws BadLocationException {
        Assert.isTrue(((increments.length() != 0 || decrements.length() != 0) && !increments.equals(decrements) ? 1 : 0) != 0);
        int nestingMode = 0;
        int nestingLevel = 0;
        int charCount = 0;
        int offset = start;
        block12: while (offset < end) {
            char curr = document.getChar(offset++);
            switch (curr) {
                case '/': {
                    if (offset >= end) continue block12;
                    char next = document.getChar(offset);
                    if (next == '*') {
                        offset = this.getCommentEnd(document, offset + 1, end);
                        break;
                    }
                    if (next != '/') continue block12;
                    offset = end;
                    break;
                }
                case '*': {
                    char next;
                    if (offset >= end || (next = document.getChar(offset)) != '/') continue block12;
                    charCount = 0;
                    ++offset;
                    break;
                }
                case '\"': 
                case '\'': {
                    offset = this.getStringEnd(document, offset, end, curr);
                    break;
                }
                case '[': {
                    if (considerNesting) {
                        if (nestingMode != 1 && nestingMode != 0) continue block12;
                        nestingMode = 1;
                        ++nestingLevel;
                        break;
                    }
                }
                case ']': {
                    if (considerNesting) {
                        if (nestingMode != true || --nestingLevel != 0) continue block12;
                        nestingMode = 0;
                        break;
                    }
                }
                case '(': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 3;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 3 && nestingMode != 0) continue block12;
                        nestingMode = 3;
                        ++nestingLevel;
                        break;
                    }
                }
                case ')': {
                    if (considerNesting) {
                        if (nestingMode != 3 || --nestingLevel != 0) continue block12;
                        nestingMode = 0;
                        break;
                    }
                }
                case '{': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 2;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 2 && nestingMode != 0) continue block12;
                        nestingMode = 2;
                        ++nestingLevel;
                        break;
                    }
                }
                case '}': {
                    if (considerNesting) {
                        if (nestingMode != 2 || --nestingLevel != 0) continue block12;
                        nestingMode = 0;
                        break;
                    }
                }
                case '>': {
                    if (considerNesting) {
                        if (nestingMode != 4 || --nestingLevel != 0) continue block12;
                        nestingMode = 0;
                        break;
                    }
                }
                default: {
                    if (nestingLevel != 0) continue block12;
                    if (increments.indexOf(curr) >= 0) {
                        ++charCount;
                    }
                    if (decrements.indexOf(curr) < 0) continue block12;
                    --charCount;
                }
            }
        }
        return charCount;
    }

    public boolean isContextInformationValid(int position) {
        IDocument document;
        block5: {
            block4: {
                try {
                    if (position >= this._position) break block4;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            document = this._viewer.getDocument();
            IRegion line = document.getLineInformationOfOffset(this._position);
            if (position >= line.getOffset() && position < document.getLength()) break block5;
            return false;
        }
        return this.getCharCount(document, this._position, position, "(<", ")>", false) >= 0;
    }

    public boolean updatePresentation(int position, TextPresentation presentation) {
        int currentParameter = -1;
        try {
            currentParameter = this.getCharCount(this._viewer.getDocument(), this._position, position, ",", "", true);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (this._currentParameter != -1 && currentParameter == this._currentParameter) {
            return false;
        }
        presentation.clear();
        this._currentParameter = currentParameter;
        String s = this._information.getInformationDisplayString();
        int[] commas = this.computeCommaPositions(s);
        if (commas.length - 2 < this._currentParameter) {
            presentation.addStyleRange(new StyleRange(0, s.length(), null, null, 1));
            return true;
        }
        int cfr_ignored_0 = commas[this._currentParameter];
        int cfr_ignored_1 = commas[this._currentParameter + 1];
        presentation.addStyleRange(new StyleRange(0, s.length(), null, null, 1));
        return true;
    }

    private int[] computeCommaPositions(String code) {
        int length = code.length();
        int pos = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        positions.add(-1);
        while (pos < length && pos != -1) {
            char ch = code.charAt(pos);
            switch (ch) {
                case ',': {
                    positions.add(pos);
                    break;
                }
                case '<': {
                    pos = code.indexOf(62, pos);
                    break;
                }
                case '[': {
                    pos = code.indexOf(93, pos);
                    break;
                }
            }
            if (pos == -1) continue;
            ++pos;
        }
        positions.add(length);
        int[] fields = new int[positions.size()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = (Integer)positions.get(i);
            ++i;
        }
        return fields;
    }
}

