/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public abstract class SelectionDispatchAction
extends Action
implements ISelectionChangedListener {
    private IWorkbenchSite _fSite;

    protected SelectionDispatchAction(IWorkbenchSite site) {
        Assert.isNotNull((Object)site);
        this._fSite = site;
    }

    public IWorkbenchSite getSite() {
        return this._fSite;
    }

    public ISelection getSelection() {
        if (this.getSelectionProvider() != null) {
            return this.getSelectionProvider().getSelection();
        }
        return null;
    }

    public Shell getShell() {
        return this._fSite.getShell();
    }

    public ISelectionProvider getSelectionProvider() {
        return this._fSite.getSelectionProvider();
    }

    public void update(ISelection selection) {
        this.dispatchSelectionChanged(selection);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.selectionChanged((ISelection)selection);
    }

    public void run(IStructuredSelection selection) {
        this.run((ISelection)selection);
    }

    public void selectionChanged(ITextSelection selection) {
        this.selectionChanged((ISelection)selection);
    }

    public void run(ITextSelection selection) {
        this.run((ISelection)selection);
    }

    public void selectionChanged(ISelection selection) {
        this.setEnabled(false);
    }

    public void run(ISelection selection) {
    }

    public void run() {
        this.dispatchRun(this.getSelection());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.dispatchSelectionChanged(event.getSelection());
    }

    private void dispatchSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.selectionChanged((ITextSelection)selection);
        } else {
            this.selectionChanged(selection);
        }
    }

    private void dispatchRun(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.run((ITextSelection)selection);
        } else {
            this.run(selection);
        }
    }
}

