/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.actions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.drivers.jdbc.JDBCConnection;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAProfileMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class JDBCHelper {
    private static String FIRST_CALL = "SELECT NEXT_DATABASE( NULL )";
    private static String FIRST_CALL2 = "SELECT NEXT_DATABASE( ";
    private static String NEXT_CALL = "SELECT DB_NAME( ";
    private static String JDBC_CONN_ID = "java.sql.Connection";

    private JDBCHelper() {
    }

    public static String[] getDBNamesFromASA(Connection conn) {
        String[] rtnArray = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            PreparedStatement pstmt = conn.prepareStatement(FIRST_CALL);
            pstmt.clearParameters();
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                PreparedStatement pstmt2 = conn.prepareStatement(String.valueOf(NEXT_CALL) + id + " )");
                ResultSet rs2 = pstmt2.executeQuery();
                while (rs2.next()) {
                    String name = rs2.getString(1);
                    list.add(name);
                }
                boolean cont = true;
                int oldid = id;
                block4: while (cont) {
                    pstmt = conn.prepareStatement(String.valueOf(FIRST_CALL2) + id + " )");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        id = rs.getInt(1);
                        if (id == oldid) {
                            cont = false;
                            continue block4;
                        }
                        pstmt2 = conn.prepareStatement(String.valueOf(NEXT_CALL) + id + " )");
                        rs2 = pstmt2.executeQuery();
                        while (rs2.next()) {
                            String name = rs2.getString(1);
                            list.add(name);
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log((Throwable)e);
        }
        if (list.size() > 0) {
            rtnArray = list.toArray(new String[list.size()]);
        }
        return rtnArray;
    }

    public static Connection getConnectionForTempProfile(Shell shell, IConnectionProfile cp) {
        IConnection con = cp.createConnection(JDBC_CONN_ID);
        if (con != null && con.getConnectException() == null) {
            Connection conn = null;
            if (con instanceof JDBCConnection) {
                conn = (Connection)con.getRawConnection();
            }
            return conn;
        }
        MessageDialog.openError((Shell)shell, (String)JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.Error.title.CannotConnect"), (String)JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.Error.msg.CannotConnect"));
        return null;
    }

    public static IConnectionProfile getTemporaryProfile(NewConnectionProfileWizard wiz) {
        ConnectionProfile tempProfile = new ConnectionProfile("tempJDBCForPing", "empty", "org.eclipse.datatools.enablement.sybase.asa.connectionProfile");
        Properties props = wiz.getProfileProperties();
        tempProfile.setBaseProperties(props);
        return tempProfile;
    }

    public static String getDefaultCatalogNameForProfile(Connection connection) {
        String defaultCatalog = null;
        if (connection != null) {
            try {
                defaultCatalog = connection.getCatalog();
            }
            catch (SQLException sQLException) {}
        }
        return defaultCatalog;
    }

    public static Connection getConnectionForProfile(Shell shell, IConnectionProfile profile) {
        if (profile != null) {
            IManagedConnection mcon;
            IConnection con;
            if (!profile.isConnected()) {
                profile.connect();
            }
            if ((con = (mcon = profile.getManagedConnection(JDBC_CONN_ID)).getConnection()) != null && con.getConnectException() == null) {
                Connection conn = null;
                if (con.getRawConnection() instanceof Connection) {
                    conn = (Connection)con.getRawConnection();
                }
                return conn;
            }
            MessageDialog.openError((Shell)shell, (String)JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.Error.title.CannotConnect"), (String)JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.Error.msg.CannotConnect"));
        }
        return null;
    }
}

