/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPParameter;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPRequest;
import org.eclipse.datatools.enablement.oda.ws.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSConsole;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.datatools.enablement.oda.ws.ui.wizards.SOAPRequestPage;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SOAPParametersPage
extends DataSetWizardPage {
    private static final String COLUMN_NAME = Messages.getString("soapParametersPage.column.paramName");
    private static final String COLUMN_DATATYPE = Messages.getString("soapParametersPage.column.dataType");
    private CheckboxTableViewer viewer;
    private SOAPRequest soapRequest;
    private String wsQueryText;
    private boolean modelChanged;
    private static String DEFAULT_MESSAGE = Messages.getString("soapParametersPage.message.default");

    public SOAPParametersPage(String pageName) {
        super(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        WSUIUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_WS_SOAP_PARAMETER_ID");
    }

    private Control createPageControl(Composite parent) {
        ScrolledComposite sComposite = new ScrolledComposite(parent, 768);
        sComposite.setLayout((Layout)new GridLayout());
        sComposite.setLayoutData((Object)new GridData(1808));
        sComposite.setMinWidth(600);
        sComposite.setExpandHorizontal(true);
        Composite composite = new Composite((Composite)sComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        this.setupParametersComposite(composite);
        this.setupSelectionButtons(composite);
        Point size = composite.computeSize(-1, -1);
        composite.setSize(size.x, size.y);
        sComposite.setContent((Control)composite);
        this.setControl((Control)sComposite);
        this.modelChanged = true;
        return sComposite;
    }

    private void setupParametersComposite(Composite parent) {
        this.createCheckboxTable(parent);
        this.setupEditors();
    }

    private void setupSelectionButtons(Composite parent) {
        GridLayout layout = new GridLayout();
        Composite btnComposite = new Composite(parent, 0);
        btnComposite.setLayout((Layout)layout);
        layout.numColumns = 3;
        btnComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(btnComposite, 0);
        label.setLayoutData((Object)new GridData(768));
        Button selectAllBtn = new Button(btnComposite, 0);
        selectAllBtn.setText(Messages.getString("soapParametersPage.button.selectAll"));
        selectAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SOAPParametersPage.this.viewer.getCheckedElements().length < SOAPParametersPage.this.viewer.getTable().getItemCount()) {
                    SOAPParametersPage.this.viewer.setAllChecked(true);
                    SOAPParametersPage.this.saveToModel();
                    SOAPParametersPage.this.modelChanged = true;
                }
            }
        });
        Button deselectAllBtn = new Button(btnComposite, 0);
        deselectAllBtn.setText(Messages.getString("soapParametersPage.button.deselectAll"));
        deselectAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SOAPParametersPage.this.viewer.getCheckedElements().length > 0) {
                    SOAPParametersPage.this.viewer.setAllChecked(false);
                    SOAPParametersPage.this.saveToModel();
                    SOAPParametersPage.this.modelChanged = true;
                }
            }
        });
        GridData btnGd = new GridData(2);
        btnGd.horizontalIndent = 10;
        btnGd.widthHint = this.getMaxWidth(deselectAllBtn, this.getMaxWidth(selectAllBtn, 100));
        selectAllBtn.setLayoutData((Object)btnGd);
        deselectAllBtn.setLayoutData((Object)btnGd);
    }

    private int getMaxWidth(Button button, int size) {
        int width = button.computeSize((int)-1, (int)-1).x;
        return width > size ? width : size;
    }

    private void createCheckboxTable(Composite parent) {
        Table table = new Table(parent, 68386);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        GridData layouData = new GridData(1808);
        layouData.heightHint = 400;
        table.setLayoutData((Object)layouData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(COLUMN_NAME);
        nameColumn.setWidth(200);
        nameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SOAPParametersPage.this.sortParametersTable();
                SOAPParametersPage.this.modelChanged = true;
            }
        });
        TableColumn dataTypeColumn = new TableColumn(table, 0);
        dataTypeColumn.setText(COLUMN_DATATYPE);
        dataTypeColumn.setWidth(200);
        this.createCheckBoxTableViewer(table);
    }

    private void createCheckBoxTableViewer(Table table) {
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null || !(inputElement instanceof SOAPParameter[])) {
                    return new Object[0];
                }
                return (SOAPParameter[])inputElement;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                SOAPParameter param = (SOAPParameter)element;
                String value = "";
                switch (columnIndex) {
                    case 0: {
                        value = param.getName();
                        break;
                    }
                    case 1: {
                        value = "";
                        break;
                    }
                    case 2: {
                        value = param.getDefaultValue();
                    }
                }
                return value;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!event.getChecked() && event.getElement() instanceof SOAPParameter) {
                    ((SOAPParameter)event.getElement()).setDefaultValue("");
                    SOAPParametersPage.this.viewer.refresh();
                    SOAPParametersPage.this.saveToModel();
                }
                SOAPParametersPage.this.modelChanged = true;
            }
        });
    }

    private void sortParametersTable() {
        if (this.viewer.getTable().getSortDirection() == 128) {
            this.viewer.setSorter((ViewerSorter)new ParametersViewerSorter(true));
            this.viewer.getTable().setSortDirection(1024);
        } else {
            this.viewer.setSorter((ViewerSorter)new ParametersViewerSorter(false));
            this.viewer.getTable().setSortDirection(128);
        }
    }

    private void setupEditors() {
        CellEditor[] editors = new CellEditor[3];
        int i = 0;
        while (i < editors.length) {
            editors[i] = new TextCellEditor((Composite)this.viewer.getTable(), 0);
            ++i;
        }
        this.viewer.setCellEditors(editors);
        this.viewer.setColumnProperties(new String[]{COLUMN_NAME, COLUMN_DATATYPE});
    }

    private void initializeControl() {
        this.initWSConsole();
        this.initFromModel();
        this.initViewer(true);
    }

    private void initWSConsole() {
        if (!WSConsole.getInstance().isSessionOK()) {
            WSConsole.getInstance().start(this.getInitializationDesign());
        }
    }

    private void initFromModel() {
        this.wsQueryText = WSConsole.getInstance().getPropertyValue("wsQueryText");
    }

    private void initViewer(boolean refreshParameters) {
        if (WSUtil.isNull((Object)this.wsQueryText)) {
            return;
        }
        this.soapRequest = new SOAPRequest(this.wsQueryText);
        SOAPParameter[] soapParameters = null;
        soapParameters = refreshParameters || WSConsole.getInstance().getParameters() == null ? this.soapRequest.getParameters() : WSConsole.getInstance().getParameters();
        if (!WSUtil.isNull((Object)soapParameters)) {
            this.viewer.setInput((Object)soapParameters);
            int i = 0;
            while (i < soapParameters.length) {
                this.viewer.setChecked((Object)soapParameters[i], soapParameters[i].isUsed());
                ++i;
            }
        } else {
            this.viewer.setInput((Object)new SOAPParameter[0]);
        }
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        this.savePage(design);
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) {
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        IWizardPage page = super.getNextPage();
        if (this.modelChanged) {
            this.saveToModel();
            if (page instanceof SOAPRequestPage) {
                try {
                    ((SOAPRequestPage)page).refresh();
                    this.modelChanged = false;
                }
                catch (OdaException e) {
                    this.setErrorMessage(e.getMessage());
                }
            }
        }
        return page;
    }

    private void saveToModel() {
        WSConsole.getInstance().setPropertyValue("wsQueryText", this.wsQueryText);
        WSConsole.getInstance().setParameters(this.getSOAPParameters());
    }

    private SOAPParameter[] getSOAPParameters() {
        SOAPParameter[] targets = this.soapRequest.getParameters();
        if (WSUtil.isNull((Object)targets)) {
            return targets;
        }
        Object[] candidates = this.viewer.getCheckedElements();
        List manipulated = this.getManipulatedIndexList(candidates);
        int i = 0;
        while (i < targets.length) {
            targets[i].setUsed(manipulated.contains(targets[i].getId()));
            ++i;
        }
        return targets;
    }

    private List getManipulatedIndexList(Object[] soapParameters) {
        if (WSUtil.isNull((Object)soapParameters) || soapParameters.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> manipulated = new ArrayList<Integer>();
        int i = 0;
        while (i < soapParameters.length) {
            manipulated.add(((SOAPParameter)soapParameters[i]).getId());
            ++i;
        }
        return manipulated;
    }

    protected void cleanup() {
        WSConsole.getInstance().terminateSession();
    }

    void refresh(boolean refreshParameters) throws OdaException {
        this.wsQueryText = WSConsole.getInstance().getTemplate();
        this.initViewer(refreshParameters);
    }

    private class ParametersViewerSorter
    extends ViewerSorter {
        private boolean descent;

        public ParametersViewerSorter(boolean descent) {
            this.descent = descent;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            assert (!(o1 instanceof SOAPParameter) || !(o2 instanceof SOAPParameter));
            int result = ((SOAPParameter)o1).getName().compareTo(((SOAPParameter)o2).getName());
            if (result == 0) {
                return 0;
            }
            if (result > 0) {
                if (this.descent) {
                    return -1;
                }
                return 1;
            }
            if (this.descent) {
                return 1;
            }
            return -1;
        }
    }
}

