/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.ConfigFileParser;
import org.junit.Assert;
import org.junit.Test;
import testutil.BaseTestCase;

public class ConfigFileParserTest
extends BaseTestCase {
    private ConfigFileParser.Node node;
    private ConfigFileParser parser;

    @Test
    public void testParseXML2DOM() throws IOException {
        this.parser = new ConfigFileParser(this.getInputFolder("testDomTree.txt"));
        this.node = this.parser.getNode();
        Assert.assertFalse((String)"parseXML2DOM() failed !!! ", (this.node == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"parseXML2DOM() failed !!! ", (boolean)this.parser.containDataSet("dset1"));
        Assert.assertFalse((String)"parseXML2DOM() failed !!! ", (boolean)this.parser.containDataSet("dataSet1"));
        Assert.assertEquals((String)"parseXML2DOM() occurrs errors !!!", (long)4L, (long)this.node.getChildren().size());
        Assert.assertEquals((String)"parseXML2DOM() occurrs errors !!!", (Object)"report", (Object)this.node.getName());
        Assert.assertEquals((String)"parseXML2DOM() occurrs errors !!!", (Object)"dset2", (Object)((ConfigFileParser.Node)this.node.getChildren().get(1)).getAttrValue("id"));
        Assert.assertEquals((String)"parseXML2DOM() occurrs errors !!!", (Object)"query-text", (Object)((ConfigFileParser.Node)((ConfigFileParser.Node)this.node.getChildren().get(0)).getChildren().get(1)).getName());
        Assert.assertEquals((String)"parseXML2DOM() occurrs errors !!!", (Object)"value1", (Object)((ConfigFileParser.Node)((ConfigFileParser.Node)((ConfigFileParser.Node)this.node.getChildren().get(2)).getChildren().get(2)).getChildren().get(0)).getValue());
        this.openOutputFile();
        this.print(this.node, "");
        this.closeOutputFile();
        this.checkOutputFile();
    }

    private void initConfigFileParser() throws IOException {
        this.parser = new ConfigFileParser(this.getInputFolder("testDomTree.txt"));
    }

    @Test
    public void testGetQueryTextByID() throws IOException, DataException {
        this.initConfigFileParser();
        Assert.assertEquals((String)"getQueryTextByID() failed!!!", (Object)"select * from BBHEGDCGHEBEA where ${timestamp-column}$ >=date('${date}$')", (Object)this.parser.getQueryTextByID("dset1"));
    }

    @Test
    public void testGetModeByID() throws IOException, DataException {
        this.initConfigFileParser();
        Assert.assertEquals((String)"getModeByID() failed!!!", (Object)"expire", (Object)this.parser.getModeByID("dset1"));
        Assert.assertEquals((String)"getModeByID() failed!!!", (Object)"persistent", (Object)this.parser.getModeByID("dset2"));
    }

    @Test
    public void testGetTimeStampColumnByID() throws IOException, DataException {
        this.initConfigFileParser();
        Assert.assertEquals((String)"getTimeStampColumnByID() failed!!!", (Object)"timestamp1", (Object)this.parser.getTimeStampColumnByID("dset3"));
        Assert.assertEquals((String)"getTimeStampColumnByID() failed!!!", (Object)"timestamp2", (Object)this.parser.getTimeStampColumnByID("dset4"));
    }

    @Test
    public void testGetParametersByID() throws IOException {
        this.initConfigFileParser();
        Assert.assertEquals((String)"getParametersByID() failed!!!", (Object)"value1", this.parser.getParametersByID("dset3").get("param1"));
        Assert.assertEquals((String)"getParametersByID() failed!!!", (Object)"value2", this.parser.getParametersByID("dset3").get("param2"));
    }

    @Test
    public void testGetTSFormatByID() throws IOException, DataException {
        this.initConfigFileParser();
        Assert.assertEquals((String)"getTSFormatByID() failed!!!", (Object)"yy-MM-dd hh:mm:ss", (Object)this.parser.getTSFormatByID("dset1"));
        Assert.assertEquals((String)"getTSFormatByID() failed!!!", (Object)"yy-MM-dd", (Object)this.parser.getTSFormatByID("dset3"));
    }

    private void print(ConfigFileParser.Node n, String padding) {
        this.testPrintln(padding + "{" + n.getName() + "}");
        this.testPrintln(padding + "\tvalue:" + n.getValue());
        Iterator it = n.getAttributes().keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            String value = n.getAttrValue(key);
            this.testPrintln(padding + "\t[" + key + "]:" + value);
        }
        if (n.getChildren() != null) {
            int i = 0;
            while (i < n.getChildren().size()) {
                this.print((ConfigFileParser.Node)n.getChildren().get(i), padding + "\t");
                ++i;
            }
        }
    }
}

