/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.monitor;

import java.util.ArrayList;
import org.apache.derby.iapi.services.monitor.DerbyObserver;

public class DerbyObservable {
    private boolean _hasChanged = false;
    private ArrayList<DerbyObserver> _observers = new ArrayList();

    public synchronized void addObserver(DerbyObserver observer) {
        if (observer == null) {
            throw new IllegalArgumentException("Null arguments not allowed.");
        }
        if (!this._observers.contains(observer)) {
            this._observers.add(observer);
        }
    }

    public synchronized int countObservers() {
        return this._observers.size();
    }

    public synchronized void deleteObserver(DerbyObserver observer) {
        this._observers.remove(observer);
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object extraInfo) {
        int lastIndex;
        DerbyObserver[] cachedObservers;
        DerbyObservable derbyObservable = this;
        synchronized (derbyObservable) {
            if (!this._hasChanged) {
                return;
            }
            cachedObservers = new DerbyObserver[this._observers.size()];
            this._observers.toArray(cachedObservers);
            this._hasChanged = false;
        }
        for (int idx = lastIndex = cachedObservers.length - 1; idx >= 0; --idx) {
            cachedObservers[idx].update(this, extraInfo);
        }
    }

    protected synchronized void setChanged() {
        this._hasChanged = true;
    }
}

