/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STSheetViewType;
import uk.co.spudsoft.birt.emitters.excel.AreaBorders;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedTableContainer;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedTableHandler;

public class AbstractRealListHandler
extends AbstractHandler
implements NestedTableContainer {
    protected int startRow;
    protected int startCol;
    private AreaBorders borderDefn;
    private List<NestedTableHandler> nestedTables;

    public AbstractRealListHandler(Logger log, IHandler parent, IListContent list) {
        super(log, parent, list);
    }

    @Override
    public void addNestedTable(NestedTableHandler nestedTableHandler) {
        if (this.nestedTables == null) {
            this.nestedTables = new ArrayList<NestedTableHandler>();
        }
        this.log.debug("Adding nested table: ", nestedTableHandler);
        this.nestedTables.add(nestedTableHandler);
    }

    @Override
    public boolean rowHasNestedTable(int rowNum) {
        if (this.nestedTables != null) {
            for (NestedTableHandler nestedTableHandler : this.nestedTables) {
                if (!nestedTableHandler.includesRow(rowNum)) continue;
                this.log.debug("Row ", rowNum, " has nested table ", nestedTableHandler);
                return true;
            }
        }
        this.log.debug("Row ", rowNum, " has no nested tables");
        return false;
    }

    @Override
    public int extendRowBy(int rowNum) {
        int offset = 1;
        if (this.nestedTables != null) {
            for (NestedTableHandler nestedTableHandler : this.nestedTables) {
                int nestedTablesOffset = nestedTableHandler.extendParentsRowBy(rowNum);
                if (nestedTablesOffset <= offset) continue;
                this.log.debug("Row ", rowNum, " is extended by ", nestedTablesOffset, " thanks to ", nestedTableHandler);
                offset = nestedTablesOffset;
            }
        }
        return offset;
    }

    @Override
    public void startList(HandlerState state, IListContent list) throws BirtException {
        this.startRow = state.rowNum;
        this.startCol = state.colNum;
        this.log.debug("List started at [", this.startRow, ",", this.startCol, "]");
    }

    @Override
    public void endList(HandlerState state, IListContent list) throws BirtException {
        String pagePreview;
        int displayZoom;
        state.setHandler(this.parent);
        int endRow = state.rowNum - 1;
        int colStart = 0;
        int colEnd = 0;
        int row = this.startRow;
        while (row < endRow) {
            int lastColInRow;
            if (state.currentSheet.getRow(row) != null && (lastColInRow = state.currentSheet.getRow(row).getLastCellNum() - 1) > colEnd) {
                colEnd = lastColInRow;
            }
            ++row;
        }
        state.getSmu().applyBordersToArea(state.getSm(), state.currentSheet, colStart, colEnd, this.startRow, endRow, new BirtStyle(list));
        if (this.borderDefn != null) {
            state.removeBorderOverload(this.borderDefn);
        }
        if (list.getBookmark() != null) {
            this.createName(state, AbstractRealListHandler.prepareName(list.getBookmark()), this.startRow, 0, state.rowNum - 1, 0);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), list, "ExcelEmitter.DisplayFormulas", false)) {
            state.currentSheet.setDisplayFormulas(true);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), list, "ExcelEmitter.DisplayGridlines", true)) {
            state.currentSheet.setDisplayGridlines(false);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), list, "ExcelEmitter.DisplayRowColHeadings", true)) {
            state.currentSheet.setDisplayRowColHeadings(false);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), list, "ExcelEmitter.DisplayZeros", true)) {
            state.currentSheet.setDisplayZeros(false);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), list, "ExcelEmitter.PrintGridlines", false)) {
            state.currentSheet.setPrintGridlines(true);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), list, "ExcelEmitter.PrintRowColHeadings", false)) {
            state.currentSheet.setPrintRowAndColumnHeadings(true);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), list, "ExcelEmitter.PrintFitToPage", false)) {
            state.currentSheet.setFitToPage(true);
        }
        if ((displayZoom = EmitterServices.integerOption(state.getRenderOptions(), list, "ExcelEmitter.DisplaySheetZoom", -1)) >= 10 && displayZoom <= 400) {
            state.currentSheet.setZoom(displayZoom);
        }
        if ((pagePreview = EmitterServices.stringOption((ITaskOption)state.getRenderOptions(), list, "ExcelEmitter.PagePreview", null)) != null) {
            if (pagePreview.equalsIgnoreCase("PageLayout")) {
                CTSheetView view = ((XSSFSheet)state.currentSheet).getCTWorksheet().getSheetViews().getSheetViewArray(0);
                view.setView(STSheetViewType.PAGE_LAYOUT);
            } else if (pagePreview.equalsIgnoreCase("PageBreak")) {
                CTSheetView view = ((XSSFSheet)state.currentSheet).getCTWorksheet().getSheetViews().getSheetViewArray(0);
                view.setView(STSheetViewType.PAGE_BREAK_PREVIEW);
            }
        }
    }

    @Override
    public void startListBand(HandlerState state, IListBandContent band) throws BirtException {
        state.colNum = this.startCol;
        this.log.debug("startListBand with startCol = ", this.startCol);
    }

    @Override
    public void endListBand(HandlerState state, IListBandContent band) throws BirtException {
        boolean rowHasNestedTable = this.rowHasNestedTable(state.rowNum);
        if (rowHasNestedTable) {
            state.rowNum += this.extendRowBy(state.rowNum);
        }
        state.colNum = this.startCol;
    }

    @Override
    public void startListGroup(HandlerState state, IListGroupContent group) throws BirtException {
    }

    @Override
    public void endListGroup(HandlerState state, IListGroupContent group) throws BirtException {
    }
}

