/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.olap.api.query.ICubeElementFactory;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.SortElementHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.util.CubeUtil;

public class CrosstabQueryUtil
implements ICrosstabConstants {
    private static ICubeElementFactory factory = null;

    private CrosstabQueryUtil() {
    }

    public static synchronized ICubeElementFactory getCubeElementFactory() throws BirtException {
        if (factory != null) {
            return factory;
        }
        try {
            Class<?> cls = Class.forName("org.eclipse.birt.data.engine.olap.impl.query.CubeElementFactory");
            factory = (ICubeElementFactory)cls.newInstance();
        }
        catch (Exception e) {
            throw new CrosstabException(e);
        }
        return factory;
    }

    @Deprecated
    public static ICubeQueryDefinition createCubeQuery(CrosstabReportItemHandle crosstabItem, IDataQueryDefinition parentQuery, boolean needMeasure, boolean needRowDimension, boolean needColumnDimension, boolean needBinding, boolean needSorting, boolean needFilter) throws BirtException {
        DataRequestSession session = DataRequestSession.newSession(new DataSessionContext(3));
        try {
            IModelAdapter modelAdapter = session.getModelAdaptor();
            ICubeQueryDefinition iCubeQueryDefinition = CrosstabQueryUtil.createCubeQuery(crosstabItem, parentQuery, modelAdapter, needMeasure, needRowDimension, needColumnDimension, needBinding, needSorting, needFilter);
            return iCubeQueryDefinition;
        }
        finally {
            session.shutdown();
        }
    }

    public static ICubeQueryDefinition createCubeQuery(CrosstabReportItemHandle crosstabItem, IDataQueryDefinition parentQuery, IModelAdapter modelAdapter, boolean needMeasure, boolean needRowDimension, boolean needColumnDimension, boolean needBinding, boolean needSorting, boolean needFilter) throws BirtException {
        Iterator bindingItr;
        ICubeQueryDefinition cubeQuery = CrosstabQueryUtil.getCubeElementFactory().createCubeQuery(crosstabItem.getCubeName());
        cubeQuery.setID(String.valueOf(crosstabItem.getModelHandle().getID()));
        boolean isBoundToLinkedDataSet = CrosstabUtil.isBoundToLinkedDataSet(crosstabItem);
        ArrayList<String> rowLevelNameList = new ArrayList<String>();
        ArrayList<String> columnLevelNameList = new ArrayList<String>();
        ArrayList<LevelViewHandle> levelViewList = new ArrayList<LevelViewHandle>();
        HashMap<String, ILevelDefinition> levelMapping = new HashMap<String, ILevelDefinition>();
        if (needMeasure) {
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = crosstabItem.getMeasure(i);
                CrosstabQueryUtil.addFactTableOrMeasureFilter(mv.filtersIterator(), cubeQuery, modelAdapter);
                if (!(mv instanceof ComputedMeasureViewHandle) || CrosstabUtil.isLinkedDataModelMeasureView(mv)) {
                    if (isBoundToLinkedDataSet) {
                        CrosstabQueryUtil.addLinkedDataModelMeasureDefinition(cubeQuery, crosstabItem, mv);
                    } else {
                        MeasureHandle mHandle = mv.getCubeMeasure();
                        if (mHandle == null) {
                            throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.measure", mv.getCubeMeasureName()));
                        }
                        if (mHandle.isCalculated()) {
                            cubeQuery.createDerivedMeasure(mHandle.getName(), DataAdapterUtil.adaptModelDataType(mHandle.getDataType()), modelAdapter.adaptExpression((Expression)mHandle.getExpressionProperty("measureExpression").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                        } else {
                            IMeasureDefinition mDef = cubeQuery.createMeasure(mHandle.getName());
                            mDef.setAggrFunction(DataAdapterUtil.getRollUpAggregationName(mHandle.getFunction()));
                        }
                    }
                }
                ++i;
            }
        }
        HashMap<String, String> exprMap = new HashMap();
        if (isBoundToLinkedDataSet) {
            exprMap = CrosstabUtil.getBindingExpressMap(crosstabItem);
        }
        if (needRowDimension && crosstabItem.getDimensionCount(0) > 0) {
            CrosstabQueryUtil.addEdgeDefinition(cubeQuery, crosstabItem, 0, rowLevelNameList, levelViewList, levelMapping, exprMap, modelAdapter, isBoundToLinkedDataSet);
        }
        if (needColumnDimension && crosstabItem.getDimensionCount(1) > 0) {
            CrosstabQueryUtil.addEdgeDefinition(cubeQuery, crosstabItem, 1, columnLevelNameList, levelViewList, levelMapping, exprMap, modelAdapter, isBoundToLinkedDataSet);
        }
        CrosstabQueryUtil.addFactTableOrMeasureFilter(crosstabItem.filtersIterator(), cubeQuery, modelAdapter);
        if (needSorting) {
            CrosstabQueryUtil.addLevelSorting(levelViewList, levelMapping, cubeQuery, modelAdapter);
        }
        if (needFilter) {
            CrosstabQueryUtil.addLevelFilter(levelViewList, levelMapping, cubeQuery, modelAdapter);
        }
        if (needBinding && (bindingItr = ((ExtendedItemHandle)crosstabItem.getModelHandle()).columnBindingsIterator()) != null) {
            HashMap<String, String> cache = new HashMap<String, String>();
            while (bindingItr.hasNext()) {
                ComputedColumnHandle column = (ComputedColumnHandle)bindingItr.next();
                IBinding binding = modelAdapter.adaptBinding(column, IModelAdapter.ExpressionLocation.CUBE);
                List aggrList = column.getAggregateOnList();
                if (aggrList != null) {
                    for (String baseLevel : aggrList) {
                        CrosstabUtil.addHierachyAggregateOn(crosstabItem, binding, baseLevel, rowLevelNameList, columnLevelNameList, cache);
                    }
                }
                cubeQuery.addBinding(binding);
            }
        }
        return cubeQuery;
    }

    private static void addLinkedDataModelMeasureDefinition(ICubeQueryDefinition cubeQuery, CrosstabReportItemHandle crosstabItem, MeasureViewHandle mv) {
        String linkedColumnName = mv instanceof ComputedMeasureViewHandle ? null : mv.getCubeMeasureName();
        AggregationCellHandle cell = mv.getCell();
        String measureBindingName = linkedColumnName;
        String aggrFunc = null;
        if (cell != null) {
            List contents = cell.getContents();
            for (Object obj : contents) {
                if (!(obj instanceof DataItemHandle)) continue;
                measureBindingName = ((DataItemHandle)obj).getResultSetColumn();
                ComputedColumnHandle column = CrosstabUtil.getColumnHandle(crosstabItem, measureBindingName);
                String string = aggrFunc = column != null ? column.getAggregateFunction() : null;
                if (CrosstabUtil.validateBinding(column, linkedColumnName)) break;
            }
        }
        if (measureBindingName != null) {
            IMeasureDefinition mDef = cubeQuery.createMeasure(measureBindingName);
            mDef.setAggrFunction(aggrFunc);
        }
    }

    private static ILevelDefinition createLinkedDataModelLevelDefinition(IHierarchyDefinition hieDef, CrosstabReportItemHandle crosstabItem, LevelViewHandle lv) {
        String levelBindingName = CrosstabUtil.getLevelBindingName(crosstabItem, lv, null, null);
        if (levelBindingName == null) {
            levelBindingName = CubeUtil.splitLevelName(lv.getCubeLevelName())[1];
        }
        if (levelBindingName != null) {
            return hieDef.createLevel(levelBindingName);
        }
        return null;
    }

    private static void addEdgeDefinition(ICubeQueryDefinition cubeQuery, CrosstabReportItemHandle crosstabItem, int axis, List<String> levelNameList, List<LevelViewHandle> levelViewList, Map<String, ILevelDefinition> levelMapping, Map<String, String> exprMap, IModelAdapter modelAdapter, boolean isBoundToLinkedDataSet) throws BirtException {
        List members;
        IEdgeDefinition edge = cubeQuery.createEdge(axis == 1 ? 2 : 1);
        LevelHandle mirrorLevel = crosstabItem.getCrosstabView(axis).getMirroredStartingLevel();
        int i = 0;
        while (i < crosstabItem.getDimensionCount(axis)) {
            DimensionViewHandle dv = crosstabItem.getDimension(axis, i);
            if (dv.getCubeDimension() == null) {
                if (axis == 1) {
                    throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.dimension.column", dv.getCubeDimensionName()));
                }
                throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.dimension.row", dv.getCubeDimensionName()));
            }
            IDimensionDefinition dimDef = edge.createDimension(dv.getCubeDimension().getName());
            IHierarchyDefinition hieDef = dimDef.createHierarchy(dv.getCubeDimension().getDefaultHierarchy().getName());
            int j = 0;
            while (j < dv.getLevelCount()) {
                LevelViewHandle lv = dv.getLevel(j);
                if (lv.getCubeLevel() == null) {
                    if (axis == 1) {
                        throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.level.column", lv.getCubeLevelName()));
                    }
                    throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.level.row", lv.getCubeLevelName()));
                }
                ILevelDefinition levelDef = null;
                levelDef = isBoundToLinkedDataSet ? CrosstabQueryUtil.createLinkedDataModelLevelDefinition(hieDef, crosstabItem, lv) : hieDef.createLevel(lv.getCubeLevel().getName());
                levelNameList.add(lv.getCubeLevel().getFullName());
                if (mirrorLevel != null && mirrorLevel.getQualifiedName().equals(lv.getCubeLevelName())) {
                    edge.setMirrorStartingLevel(levelDef);
                }
                levelViewList.add(lv);
                levelMapping.put(lv.getCubeLevel().getFullName(), levelDef);
                ++j;
            }
            ++i;
        }
        CrosstabViewHandle view = crosstabItem.getCrosstabView(axis);
        if (view != null && (members = view.getMembers()) != null && members.size() > 0) {
            int i2 = 0;
            while (i2 < members.size()) {
                MemberValueHandle mvh = (MemberValueHandle)members.get(i2);
                if (mvh != null) {
                    LevelHandle lv = mvh.getLevel();
                    if (lv == null) {
                        lv = crosstabItem.findLevelHandle(mvh.getCubeLevelName());
                    }
                    if (lv != null) {
                        CrosstabQueryUtil.addDrillDefinition(crosstabItem, edge, mvh, levelMapping);
                    }
                }
                ++i2;
            }
            CrosstabQueryUtil.addEdgeMemberFilter(cubeQuery, crosstabItem, modelAdapter, members, levelMapping, exprMap);
        }
    }

    private static void addEdgeMemberFilter(ICubeQueryDefinition cubeQuery, CrosstabReportItemHandle crosstabItem, IModelAdapter modelAdapter, List<MemberValueHandle> members, Map<String, ILevelDefinition> levelMapping, Map<String, String> exprMap) throws BirtException {
        ArrayList<ArrayList<IScriptExpression>> allTargetLevels = new ArrayList<ArrayList<IScriptExpression>>();
        ArrayList<ArrayList<List<IScriptExpression>>> allMemberValues = new ArrayList<ArrayList<List<IScriptExpression>>>();
        ArrayList<ArrayList<List<Boolean>>> allMemberFlags = new ArrayList<ArrayList<List<Boolean>>>();
        int[] op = new int[1];
        Boolean[] updateAggFlag = new Boolean[1];
        for (MemberValueHandle mvh : members) {
            if (mvh == null) continue;
            LevelHandle lv = mvh.getLevel();
            if (lv == null) {
                lv = crosstabItem.findLevelHandle(mvh.getCubeLevelName());
            }
            if (lv != null) continue;
            ArrayList<IScriptExpression> targetLevels = new ArrayList<IScriptExpression>();
            ArrayList<List<IScriptExpression>> arrayList = new ArrayList<List<IScriptExpression>>();
            ArrayList<List<Boolean>> memberFlags = new ArrayList<List<Boolean>>();
            CrosstabQueryUtil.traverseMemberFilter(crosstabItem, targetLevels, op, updateAggFlag, arrayList, memberFlags, mvh, levelMapping, exprMap, modelAdapter, 1, new int[]{1});
            allTargetLevels.add(targetLevels);
            allMemberValues.add(arrayList);
            allMemberFlags.add(memberFlags);
        }
        ArrayList<IScriptExpression> mergedTargetLevels = new ArrayList<IScriptExpression>();
        ArrayList<Collection<IScriptExpression>> mergedMemberValues = new ArrayList<Collection<IScriptExpression>>();
        ArrayList<String> keyList = new ArrayList<String>();
        int i = 0;
        while (i < allTargetLevels.size()) {
            List list = (List)allTargetLevels.get(i);
            String startLevel = ((IScriptExpression)list.get(0)).getText();
            int startIdx = keyList.indexOf(startLevel);
            if (startIdx == -1) {
                startIdx = keyList.size();
                for (IScriptExpression target : list) {
                    keyList.add(target.getText());
                    mergedTargetLevels.add(target);
                }
            }
            List memberValues = (List)allMemberValues.get(i);
            int j = 0;
            while (j < memberValues.size()) {
                List bucket = (List)memberValues.get(j);
                List flagBucket = (List)((List)allMemberFlags.get(i)).get(j);
                boolean effective = false;
                for (Boolean mark : flagBucket) {
                    if (mark == null || !mark.booleanValue()) continue;
                    effective = true;
                    break;
                }
                if (effective) {
                    if (startIdx == 0) {
                        mergedMemberValues.add(bucket);
                    } else {
                        ArrayList newBucket = new ArrayList();
                        int k = 0;
                        while (k < startIdx) {
                            newBucket.add(null);
                            ++k;
                        }
                        newBucket.addAll(bucket);
                        mergedMemberValues.add(newBucket);
                    }
                }
                ++j;
            }
            ++i;
        }
        int maxLen = keyList.size();
        for (Collection collection : mergedMemberValues) {
            int gap = maxLen - collection.size();
            while (gap > 0) {
                collection.add(null);
                --gap;
            }
        }
        if (mergedMemberValues.size() > 0) {
            IFilterDefinition iFilterDefinition = CrosstabQueryUtil.getCubeElementFactory().creatLevelMemberFilterDefinition(mergedTargetLevels, op[0], mergedMemberValues);
            if (updateAggFlag[0] != null) {
                iFilterDefinition.setUpdateAggregation(updateAggFlag[0]);
            }
            cubeQuery.addFilter(iFilterDefinition);
        }
    }

    private static void traverseMemberFilter(CrosstabReportItemHandle crosstabItem, List<IScriptExpression> targetLevels, int[] op, Boolean[] updateAggFlag, List<List<IScriptExpression>> memberValues, List<List<Boolean>> memberFlags, MemberValueHandle member, Map<String, ILevelDefinition> levelMapping, Map<String, String> exprMap, IModelAdapter modelAdapter, int depth, int[] pos) throws BirtException {
        List children;
        List<Expression> val1list;
        LevelHandle targetLevel = member.getLevel();
        if (targetLevel == null) {
            targetLevel = crosstabItem.findLevelHandle(member.getCubeLevelName());
        }
        if (targetLevel == null) {
            --depth;
        } else {
            boolean isLinkedDataModel = CrosstabUtil.isBoundToLinkedDataSet(crosstabItem);
            String targetDataType = targetLevel.getDataType();
            int dteDataType = DataAdapterUtil.adaptModelDataType(targetDataType);
            if (depth > targetLevels.size()) {
                ILevelDefinition targetLevelDef = levelMapping.get(targetLevel.getFullName());
                IDimensionDefinition targetDimDef = targetLevelDef.getHierarchy().getDimension();
                if (isLinkedDataModel) {
                    DesignElementHandle deh = targetLevel.getContainer().getContainer();
                    String levelBindingName = targetLevelDef.getName();
                    String expr = exprMap.get(levelBindingName);
                    if (expr == null) {
                        expr = ExpressionUtil.createDataSetRowExpression(targetDimDef.getName());
                    }
                    targetLevels.add(modelAdapter.adaptJSExpression(expr, targetDataType));
                } else {
                    targetLevels.add(modelAdapter.adaptJSExpression(ExpressionUtil.createJSDimensionExpression(targetDimDef.getName(), targetLevelDef.getName()), targetDataType));
                }
            }
            String val = member.getValue();
            CrosstabQueryUtil.matrixAdd(memberValues, memberFlags, depth, pos, modelAdapter.adaptJSExpression(ExpressionUtil.generateConstantExpr(val, dteDataType), targetDataType), false);
        }
        Iterator<FilterConditionHandle> filters = member.filtersIterator();
        if (filters == null || !filters.hasNext()) {
            return;
        }
        FilterConditionHandle fch = filters.next();
        int dop = DataAdapterUtil.adaptModelFilterOperator(fch.getOperator());
        assert (dop == 22 || dop == 23 || dop == 0);
        if (op[0] == 0) {
            op[0] = dop;
        } else {
            int cfr_ignored_0 = op[0];
        }
        if (updateAggFlag[0] == null) {
            boolean needUpdateAgg = fch.updateAggregation();
            updateAggFlag[0] = needUpdateAgg;
        }
        if ((val1list = fch.getValue1ExpressionList().getListValue()) != null && val1list.size() > 0) {
            if (depth + 1 > targetLevels.size()) {
                targetLevels.add(modelAdapter.adaptExpression((Expression)fch.getExpressionProperty("expr").getValue(), IModelAdapter.ExpressionLocation.CUBE));
            }
            for (Expression expr : val1list) {
                CrosstabQueryUtil.matrixAdd(memberValues, memberFlags, depth + 1, pos, modelAdapter.adaptExpression(expr, IModelAdapter.ExpressionLocation.CUBE), true);
            }
        }
        if ((children = member.getContents("memberValues")) != null) {
            int i = 0;
            while (i < children.size()) {
                MemberValueHandle child = (MemberValueHandle)children.get(i);
                if (child != null) {
                    CrosstabQueryUtil.traverseMemberFilter(crosstabItem, targetLevels, op, updateAggFlag, memberValues, memberFlags, child, levelMapping, exprMap, modelAdapter, depth + 1, pos);
                }
                ++i;
            }
        }
    }

    private static void matrixAdd(List<List<IScriptExpression>> values, List<List<Boolean>> flags, int depth, int[] pos, IScriptExpression val, boolean mark) {
        List<Object> flagBucket;
        List<Object> bucket;
        if (pos[0] > values.size()) {
            bucket = new ArrayList();
            values.add(bucket);
            flagBucket = new ArrayList();
            flags.add(flagBucket);
            if (pos[0] > 1) {
                List<IScriptExpression> lastBucket = values.get(pos[0] - 2);
                List<Boolean> lastFlagBucket = flags.get(pos[0] - 2);
                int i = 1;
                while (i < depth) {
                    bucket.add(lastBucket.get(i - 1));
                    flagBucket.add(lastFlagBucket.get(i - 1));
                    ++i;
                }
            }
            pos[0] = pos[0] + 1;
        } else {
            bucket = values.get(pos[0] - 1);
            flagBucket = flags.get(pos[0] - 1);
        }
        if (depth > bucket.size()) {
            bucket.add(val);
            flagBucket.add(mark);
        } else {
            bucket.set(depth - 1, val);
            flagBucket.set(depth - 1, mark);
        }
    }

    private static void addDrillDefinition(CrosstabReportItemHandle crosstabItem, IEdgeDefinition edge, MemberValueHandle member, Map<String, ILevelDefinition> levelMapping) {
        IHierarchyDefinition targetHierarchy = null;
        String targetLevelName = null;
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        Object[] output = new Object[]{targetLevelName, targetHierarchy};
        CrosstabQueryUtil.traverseDrillMember(crosstabItem, output, member, levelMapping, values, 0);
        targetLevelName = (String)output[0];
        targetHierarchy = (IHierarchyDefinition)output[1];
        IEdgeDrillFilter drillDef = edge.createDrillFilter(null);
        drillDef.setTargetHierarchy(targetHierarchy);
        drillDef.setTargetLevelName(targetLevelName);
        ArrayList<Object[]> tuples = new ArrayList<Object[]>();
        int i = 0;
        while (i < values.size()) {
            List vals = (List)values.get(i);
            if (vals == null || vals.size() == 0) {
                tuples.add(null);
            } else {
                tuples.add(vals.toArray(new Object[vals.size()]));
            }
            ++i;
        }
        drillDef.setTuple(tuples);
    }

    /*
     * Unable to fully structure code
     */
    private static void traverseDrillMember(CrosstabReportItemHandle crosstabItem, Object[] output, MemberValueHandle member, Map<String, ILevelDefinition> levelMapping, List<List<Object>> values, int depth) {
        targetLevel = member.getLevel();
        if (targetLevel == null) {
            targetLevel = crosstabItem.findLevelHandle(member.getCubeLevelName());
        }
        if (targetLevel != null) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            values.add(new ArrayList<E>());
lbl8:
            // 2 sources

            ** while (depth >= values.size())
        }
lbl9:
        // 1 sources

        val = member.getValue();
        if (val != null || CrosstabUtil.isBoundToLinkedDataSet(crosstabItem)) {
            vals = values.get(depth);
            vals.add(val);
        }
        targetLevelDef = levelMapping.get(targetLevel.getFullName());
        output[0] = targetLevel.getName();
        if (targetLevelDef != null) {
            output[1] = targetLevelDef.getHierarchy();
        }
        if ((children = member.getContents("memberValues")) != null) {
            i = 0;
            while (i < children.size()) {
                child = (MemberValueHandle)children.get(i);
                if (child != null) {
                    CrosstabQueryUtil.traverseDrillMember(crosstabItem, output, child, levelMapping, values, depth + 1);
                }
                ++i;
            }
        }
    }

    private static void addMembers(Map<String, ILevelDefinition> levelMapping, List<ILevelDefinition> levels, List<Object> values, MemberValueHandle member) {
        ILevelDefinition levelDef;
        if (member != null && (levelDef = levelMapping.get(member.getCubeLevelName())) != null) {
            levels.add(levelDef);
            values.add(member.getValue());
            if (member.getContentCount("memberValues") > 0) {
                CrosstabQueryUtil.addMembers(levelMapping, levels, values, (MemberValueHandle)member.getContent("memberValues", 0));
            }
        }
    }

    private static void addLevelSorting(List<LevelViewHandle> levelViews, Map<String, ILevelDefinition> levelMapping, ICubeQueryDefinition cubeQuery, IModelAdapter modelAdapter) throws BirtException {
        ArrayList<ILevelDefinition> levels = new ArrayList<ILevelDefinition>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (LevelViewHandle lv : levelViews) {
            Iterator sortItr = lv.sortsIterator();
            if (sortItr == null) continue;
            while (sortItr.hasNext()) {
                SortElementHandle sortKey = (SortElementHandle)sortItr.next();
                levels.clear();
                values.clear();
                CrosstabQueryUtil.addMembers(levelMapping, levels, values, sortKey.getMember());
                ILevelDefinition[] qualifyLevels = null;
                Object[] qualifyValues = null;
                if (levels.size() > 0) {
                    qualifyLevels = levels.toArray(new ILevelDefinition[levels.size()]);
                    qualifyValues = values.toArray(new Object[values.size()]);
                }
                ICubeSortDefinition sortDef = CrosstabQueryUtil.getCubeElementFactory().createCubeSortDefinition(modelAdapter.adaptExpression((Expression)sortKey.getExpressionProperty("key").getValue(), IModelAdapter.ExpressionLocation.CUBE), levelMapping.get(lv.getCubeLevel().getFullName()), qualifyLevels, qualifyValues, DataAdapterUtil.adaptModelSortDirection(sortKey.getDirection()));
                sortDef.setSortLocale(sortKey.getLocale());
                sortDef.setSortStrength(sortKey.getStrength());
                cubeQuery.addSort(sortDef);
            }
        }
    }

    private static void addLevelFilter(List<LevelViewHandle> levelViews, Map<String, ILevelDefinition> levelMapping, ICubeQueryDefinition cubeQuery, IModelAdapter modelAdapter) throws BirtException {
        ArrayList<ILevelDefinition> levels = new ArrayList<ILevelDefinition>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (LevelViewHandle lv : levelViews) {
            Iterator filterItr = lv.filtersIterator();
            if (filterItr == null) continue;
            while (filterItr.hasNext()) {
                ConditionalExpression filterCondExpr;
                FilterConditionElementHandle filterCon = (FilterConditionElementHandle)filterItr.next();
                levels.clear();
                values.clear();
                CrosstabQueryUtil.addMembers(levelMapping, levels, values, filterCon.getMember());
                ILevelDefinition[] qualifyLevels = null;
                Object[] qualifyValues = null;
                if (levels.size() > 0) {
                    qualifyLevels = levels.toArray(new ILevelDefinition[levels.size()]);
                    qualifyValues = values.toArray(new Object[values.size()]);
                }
                if (ModuleUtil.isListFilterValue(filterCon)) {
                    ArrayList<ScriptExpression> vals = null;
                    val1list = filterCon.getValue1ExpressionList().getListValue();
                    if (val1list != null) {
                        vals = new ArrayList<ScriptExpression>();
                        for (Expression expr : val1list) {
                            vals.add(modelAdapter.adaptExpression(expr, IModelAdapter.ExpressionLocation.CUBE));
                        }
                    }
                    filterCondExpr = new ConditionalExpression(modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("expr").getValue(), IModelAdapter.ExpressionLocation.CUBE), DataAdapterUtil.adaptModelFilterOperator(filterCon.getOperator()), vals);
                } else {
                    Expression value1 = null;
                    val1list = filterCon.getValue1ExpressionList().getListValue();
                    if (val1list != null && val1list.size() > 0) {
                        value1 = val1list.get(0);
                    }
                    filterCondExpr = new ConditionalExpression(modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("expr").getValue(), IModelAdapter.ExpressionLocation.CUBE), DataAdapterUtil.adaptModelFilterOperator(filterCon.getOperator()), modelAdapter.adaptExpression(value1, IModelAdapter.ExpressionLocation.CUBE), modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("value2").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                }
                ICubeFilterDefinition filterDef = CrosstabQueryUtil.getCubeElementFactory().creatCubeFilterDefinition(filterCondExpr, levelMapping.get(lv.getCubeLevel().getFullName()), qualifyLevels, qualifyValues, filterCon.updateAggregation());
                cubeQuery.addFilter(filterDef);
            }
        }
    }

    private static void addFactTableOrMeasureFilter(Iterator<FilterConditionElementHandle> filters, ICubeQueryDefinition cubeQuery, IModelAdapter modelAdapter) throws BirtException {
        if (filters != null) {
            while (filters.hasNext()) {
                ConditionalExpression filterCondExpr;
                FilterConditionElementHandle filterCon = filters.next();
                if (ModuleUtil.isListFilterValue(filterCon)) {
                    ArrayList<ScriptExpression> vals = null;
                    val1list = filterCon.getValue1ExpressionList().getListValue();
                    if (val1list != null) {
                        vals = new ArrayList<ScriptExpression>();
                        for (Expression expr : val1list) {
                            vals.add(modelAdapter.adaptExpression(expr, IModelAdapter.ExpressionLocation.CUBE));
                        }
                    }
                    filterCondExpr = new ConditionalExpression(modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("expr").getValue(), IModelAdapter.ExpressionLocation.CUBE), DataAdapterUtil.adaptModelFilterOperator(filterCon.getOperator()), vals);
                } else {
                    Expression value1 = null;
                    val1list = filterCon.getValue1ExpressionList().getListValue();
                    if (val1list != null && val1list.size() > 0) {
                        value1 = val1list.get(0);
                    }
                    filterCondExpr = new ConditionalExpression(modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("expr").getValue(), IModelAdapter.ExpressionLocation.CUBE), DataAdapterUtil.adaptModelFilterOperator(filterCon.getOperator()), modelAdapter.adaptExpression(value1, IModelAdapter.ExpressionLocation.CUBE), modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("value2").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                }
                ICubeFilterDefinition filterDef = CrosstabQueryUtil.getCubeElementFactory().creatCubeFilterDefinition(filterCondExpr, null, null, null, filterCon.updateAggregation());
                cubeQuery.addFilter(filterDef);
            }
        }
    }
}

