/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index.v0;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;
import org.eclipse.birt.report.engine.internal.index.IDocumentIndexReader;

public class DocumentIndexReaderV0
implements IDocumentIndexReader,
ReportDocumentConstants {
    IDocArchiveReader archive;
    HashMap<String, Long> bookmarks;
    HashMap<String, Long> reportlets;
    HashMap<String, Long> pageNumbers;

    public DocumentIndexReaderV0(IDocArchiveReader archive) throws IOException {
        this.archive = archive;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public void close() {
    }

    private HashMap<String, Long> loadIndexStream(IDocArchiveReader archive, String streamName) throws IOException {
        HashMap<String, Long> map = new HashMap<String, Long>();
        RAInputStream in = archive.getStream(streamName);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            try {
                DataInputStream di = new DataInputStream(in);
                long count = IOUtil.readLong(di);
                long i = 0L;
                while (i < count) {
                    String key = IOUtil.readString(di);
                    long offset = IOUtil.readLong(di);
                    map.put(key, new Long(offset));
                    ++i;
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return map;
    }

    @Override
    public long getOffsetOfBookmark(String bookmark) throws IOException {
        Long offset;
        if (this.bookmarks == null) {
            this.bookmarks = this.loadIndexStream(this.archive, "/reportletBookmarks");
        }
        if (this.bookmarks != null && (offset = this.bookmarks.get(bookmark)) != null) {
            return offset;
        }
        return -1L;
    }

    @Override
    public long getOffsetOfInstance(String instanceId) throws IOException {
        Long offset;
        if (this.reportlets == null) {
            this.reportlets = this.loadIndexStream(this.archive, "/reportlet");
        }
        if (this.reportlets != null && (offset = this.reportlets.get(instanceId)) != null) {
            return offset;
        }
        return -1L;
    }

    @Override
    public long getPageOfBookmark(String bookmark) throws IOException {
        Long offset;
        if (this.pageNumbers == null) {
            this.pageNumbers = this.loadIndexStream(this.archive, "/bookmark");
        }
        if (this.pageNumbers != null && (offset = this.pageNumbers.get(bookmark)) != null) {
            return offset;
        }
        return -1L;
    }

    @Override
    public List<String> getBookmarks() throws IOException {
        if (this.pageNumbers == null) {
            this.pageNumbers = this.loadIndexStream(this.archive, "/bookmark");
        }
        if (this.pageNumbers != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String bookmark : this.pageNumbers.keySet()) {
                if (bookmark == null || bookmark.startsWith("__TOC_")) continue;
                list.add(bookmark);
            }
            return list;
        }
        return null;
    }

    @Override
    public BookmarkContent getBookmark(String bookmark) {
        return null;
    }

    @Override
    public List<BookmarkContent> getBookmarkContents() throws IOException {
        return null;
    }
}

