/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ods;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.odf.style.StyleBuilder;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.style.StyleManager;

public class MasterPageWriter
extends org.eclipse.birt.report.engine.odf.writer.MasterPageWriter {
    private StyleManager styleManager;

    public MasterPageWriter(OutputStream out, StyleManager styleManager) {
        super(out);
        this.styleManager = styleManager;
    }

    protected void writeTableCell(ICellContent cell, StyleEntry rowStyle) {
        Collection<IContent> list = cell.getChildren();
        Iterator<IContent> iter = list.iterator();
        if (iter.hasNext()) {
            StyleEntry cellStyle = StyleBuilder.createStyleEntry(cell.getComputedStyle(), 5);
            if (cellStyle != null && rowStyle != null) {
                StyleBuilder.mergeInheritableProp(cellStyle, rowStyle);
            }
            StyleEntry textStyle = StyleBuilder.createEmptyStyleEntry(1);
            if (cellStyle != null) {
                StyleBuilder.mergeInheritableProp(textStyle, cellStyle);
            }
            this.writer.openTag("text:p");
            while (iter.hasNext()) {
                this.writeTextContent(iter.next(), textStyle);
            }
            this.writer.closeTag("text:p");
        }
    }

    protected void writeTableRow(IRowContent row, StyleEntry tableStyle) {
        StyleEntry rowStyle = StyleBuilder.createStyleEntry(row.getComputedStyle(), 4);
        if (rowStyle != null && tableStyle != null) {
            StyleBuilder.mergeInheritableProp(tableStyle, rowStyle);
        }
        Collection<IContent> list = row.getChildren();
        Iterator<IContent> iter = list.iterator();
        int currentCellCount = 0;
        while (iter.hasNext()) {
            ICellContent child = (ICellContent)iter.next();
            String tag = "";
            switch (++currentCellCount) {
                case 1: {
                    tag = "style:region-left";
                    break;
                }
                case 2: {
                    tag = "style:region-center";
                    break;
                }
                case 3: {
                    tag = "style:region-right";
                    break;
                }
            }
            this.writer.openTag(tag);
            this.writeTableCell(child, rowStyle);
            this.writer.closeTag(tag);
        }
    }

    protected void writeTable(ITableContent table) {
        Collection<IContent> list = table.getChildren();
        Iterator<IContent> iter = list.iterator();
        if (iter.hasNext()) {
            StyleEntry tableStyle = StyleBuilder.createStyleEntry(table.getComputedStyle(), 2);
            while (iter.hasNext()) {
                IContent child = iter.next();
                this.writeTableRow((IRowContent)child, tableStyle);
            }
        }
    }

    protected void writeTextContent(Object child, StyleEntry blockStyle) {
        StyleEntry entry = StyleBuilder.createStyleEntry(((IContent)child).getComputedStyle(), 1);
        if (blockStyle != null) {
            if (entry == null) {
                entry = StyleBuilder.createEmptyStyleEntry(1);
            }
            StyleBuilder.mergeInheritableProp(blockStyle, entry);
        }
        this.writer.openTag("text:span");
        if (entry != null) {
            this.styleManager.addStyle(entry);
            this.writer.attribute("text:style-name", entry.getName());
        }
        if (child instanceof IAutoTextContent) {
            this.writeAutoText(((IAutoTextContent)child).getType());
        } else if (child instanceof ITextContent) {
            this.writeString(((ITextContent)child).getText());
        } else if (child instanceof IForeignContent) {
            this.writeString(((IForeignContent)child).getRawValue().toString());
        }
        this.writer.closeTag("text:span");
    }

    public void writeHeaderFooter(IContent headerFooter) {
        if (headerFooter != null) {
            Collection<IContent> list = headerFooter.getChildren();
            for (IContent child : list) {
                if (child instanceof ITableContent) {
                    this.writeTable((ITableContent)child);
                    continue;
                }
                this.writer.openTag("text:p");
                StyleEntry blockEntry = StyleBuilder.createStyleEntry(headerFooter.getComputedStyle(), 1);
                this.writeTextContent(child, blockEntry);
                this.writer.closeTag("text:p");
            }
        }
    }
}

