/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.internal.util.DataProtocolUtil;
import org.eclipse.birt.report.engine.util.FlashFile;
import org.eclipse.birt.report.engine.util.ResourceLocatorWrapper;
import org.eclipse.birt.report.engine.util.SvgFile;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ImageReader {
    public static final int TYPE_IMAGE_OBJECT = 0;
    public static final int TYPE_FLASH_OBJECT = 1;
    public static final int TYPE_SVG_OBJECT = 2;
    public static final int TYPE_CONVERTED_SVG_OBJECT = 3;
    public static final int OBJECT_UNLOADED = -1;
    public static final int RESOURCE_UNREACHABLE = 0;
    public static final int UNSUPPORTED_OBJECTS = 1;
    public static final int OBJECT_LOADED_SUCCESSFULLY = 2;
    private int objectType = 0;
    private int status = -1;
    private IImageContent content;
    private String supportedImageFormats = null;
    private byte[] buffer;
    private ResourceLocatorWrapper rl = null;
    protected static Logger logger = Logger.getLogger(ImageReader.class.getName());
    private static final String URL_PROTOCOL_TYPE_DATA = "data:";
    private static final String URL_PROTOCOL_TYPE_FILE = "file:";
    private static final String URL_PROTOCOL_URL_ENCODED_SPACE = "%20";

    public ImageReader(IImageContent content, String supportedImageFormats) {
        this.content = content;
        this.supportedImageFormats = supportedImageFormats;
        ExecutionContext exeContext = ((ReportContent)content.getReportContent()).getExecutionContext();
        if (exeContext != null) {
            this.rl = exeContext.getResourceLocator();
        }
    }

    public int read() {
        this.buffer = null;
        this.checkObjectType(this.content);
        String uri = this.verifyURI(this.content.getURI());
        try {
            switch (this.content.getImageSource()) {
                case 0: {
                    ReportDesignHandle design = this.content.getReportContent().getDesign().getReportDesign();
                    if (this.rl == null) {
                        URL url = design.findResource(uri, 1, this.content.getReportContent().getReportContext() == null ? null : this.content.getReportContent().getReportContext().getAppContext());
                        this.readImage(url);
                    } else {
                        byte[] in = this.rl.findResource(design, uri, 1, this.content.getReportContent().getReportContext() == null ? null : this.content.getReportContent().getReportContext().getAppContext());
                        this.readImage(in);
                    }
                    break;
                }
                case 3: {
                    this.readImage(uri);
                    break;
                }
                case 1: 
                case 2: {
                    this.readImage(this.content.getData());
                    break;
                }
                default: {
                    assert (false);
                }
            }
        }
        catch (IOException e) {
            this.buffer = null;
            this.status = 0;
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return this.status;
    }

    public byte[] getByteArray() {
        return this.buffer;
    }

    public int getType() {
        return this.objectType;
    }

    private byte[] getImageByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int size = in.read(buffer);
        while (size != -1) {
            out.write(buffer, 0, size);
            size = in.read(buffer);
        }
        buffer = out.toByteArray();
        out.close();
        return buffer;
    }

    private void checkObjectType(IImageContent content) {
        String extension;
        String uri = content.getURI();
        String mimeType = content.getMIMEType();
        this.objectType = FlashFile.isFlash(mimeType, uri, extension = content.getExtension()) ? 1 : (SvgFile.isSvg(mimeType, uri, extension) ? 2 : 0);
    }

    private boolean isOutputSupported() {
        return this.objectType == 0 ? -1 != this.supportedImageFormats.indexOf("PNG") || -1 != this.supportedImageFormats.indexOf("GIF") || -1 != this.supportedImageFormats.indexOf("BMP") || -1 != this.supportedImageFormats.indexOf("JPG") : (this.objectType == 1 ? -1 != this.supportedImageFormats.indexOf("SWF") : this.objectType == 2 && -1 != this.supportedImageFormats.indexOf("SVG"));
    }

    private void readImage(String uri) throws IOException {
        block9: {
            if (uri == null) {
                this.status = 0;
                return;
            }
            if (uri.startsWith(URL_PROTOCOL_TYPE_DATA)) {
                try {
                    DataProtocolUtil.DataUrlInfo parseDataUrl = DataProtocolUtil.parseDataUrl(uri);
                    byte[] bytes = null;
                    bytes = Objects.equals(parseDataUrl.getEncoding(), "base64") ? Base64.getDecoder().decode(parseDataUrl.getData()) : parseDataUrl.getData().getBytes(StandardCharsets.UTF_8);
                    if (this.objectType == 2) {
                        try {
                            String decodedImg = URLDecoder.decode(new String(bytes), StandardCharsets.UTF_8);
                            bytes = decodedImg.getBytes(StandardCharsets.UTF_8);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if (bytes != null) {
                        this.readImage(bytes);
                        break block9;
                    }
                    this.status = 0;
                }
                catch (Exception e) {
                    this.status = 0;
                }
            } else {
                this.readImage(new URL(uri));
            }
        }
    }

    private void readImage(URL url) throws IOException {
        if (url == null) {
            this.status = 0;
            return;
        }
        if (this.rl != null) {
            byte[] in = this.rl.findResource(url);
            this.readImage(in);
        } else {
            InputStream in = url.openStream();
            this.readImage(in);
        }
    }

    private void readImage(InputStream in) throws IOException {
        if (this.isOutputSupported()) {
            this.buffer = this.getImageByteArray(in);
            this.status = 2;
        } else if (this.objectType == 2) {
            try {
                this.buffer = SvgFile.transSvgToArray(in);
            }
            catch (Exception e) {
                this.buffer = null;
                this.status = 1;
                return;
            }
            this.objectType = 3;
            this.status = 2;
        } else {
            this.buffer = null;
            this.status = 1;
        }
    }

    private void readImage(byte[] data) {
        if (data == null || data.length == 0) {
            this.buffer = null;
            this.status = 0;
            return;
        }
        if (this.isOutputSupported()) {
            this.buffer = data;
            this.status = 2;
        } else if (this.objectType == 2) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
                    this.buffer = SvgFile.transSvgToArray(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.buffer = null;
                this.status = 1;
                return;
            }
            this.objectType = 3;
            this.status = 2;
        } else {
            this.buffer = null;
            this.status = 1;
        }
    }

    private String verifyURI(String uri) {
        if (uri != null && !((String)uri).toLowerCase().startsWith(URL_PROTOCOL_TYPE_DATA)) {
            Object tmpUrl = ((String)uri).replaceAll(" ", URL_PROTOCOL_URL_ENCODED_SPACE);
            try {
                new URL((String)tmpUrl).toURI();
            }
            catch (MalformedURLException | URISyntaxException excUrl) {
                try {
                    tmpUrl = "file:///" + (String)uri;
                    new URL((String)tmpUrl).toURI();
                    uri = tmpUrl;
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        }
        return uri;
    }
}

