/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.olap.api.query.IDerivedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.DerivedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.MeasureDefinition;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.i18n.AdapterResourceHandle;
import org.eclipse.birt.report.data.adapter.impl.DataModelAdapter;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class CubeMeasureUtil {
    private static IModelAdapter getModelAdapter() throws BirtException {
        return new DataModelAdapter(new DataSessionContext(3));
    }

    public static void validateDerivedMeasures(CubeHandle cubeHandle) throws BirtException {
        HashMap<String, IMeasureDefinition> measures = new HashMap<String, IMeasureDefinition>();
        HashMap<String, IDerivedMeasureDefinition> calculatedMeasures = new HashMap<String, IDerivedMeasureDefinition>();
        HashMap<String, MeasureHandle> mHandles = new HashMap<String, MeasureHandle>();
        CubeMeasureUtil.populateMeasures(measures, calculatedMeasures, mHandles, cubeHandle);
        for (Map.Entry e : calculatedMeasures.entrySet()) {
            ArrayList<String> resolving = new ArrayList<String>();
            CubeMeasureUtil.checkDerivedMeasure((IDerivedMeasureDefinition)e.getValue(), resolving, measures, calculatedMeasures, mHandles);
        }
    }

    private static void populateMeasures(Map<String, IMeasureDefinition> measures, Map<String, IDerivedMeasureDefinition> calculatedMeasures, Map<String, MeasureHandle> measureHandles, CubeHandle cubeHandle) throws BirtException {
        List measureGroups = cubeHandle.getContents("measureGroups");
        int i = 0;
        while (i < measureGroups.size()) {
            MeasureGroupHandle mgh = (MeasureGroupHandle)measureGroups.get(i);
            List measureGroup = mgh.getContents("measures");
            int j = 0;
            while (j < measureGroup.size()) {
                MeasureHandle mHandle = (MeasureHandle)measureGroup.get(j);
                if (measureHandles != null) {
                    measureHandles.put(mHandle.getName(), mHandle);
                }
                if (mHandle.isCalculated()) {
                    m = new DerivedMeasureDefinition(mHandle.getName(), DataAdapterUtil.adaptModelDataType(mHandle.getDataType()), CubeMeasureUtil.getModelAdapter().adaptExpression((Expression)mHandle.getExpressionProperty("measureExpression").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                    calculatedMeasures.put(mHandle.getName(), (IDerivedMeasureDefinition)((Object)m));
                } else {
                    m = new MeasureDefinition(mHandle.getName());
                    m.setAggrFunction(DataAdapterUtil.getRollUpAggregationName(mHandle.getFunction()));
                    measures.put(m.getName(), m);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void checkDerivedMeasure(IDerivedMeasureDefinition dmeasure, List<String> resolving, Map<String, IMeasureDefinition> measures, Map<String, IDerivedMeasureDefinition> calculatedMeasure, Map<String, MeasureHandle> mHandles) throws DataException {
        List<String> referencedMeasures = ExpressionCompilerUtil.extractColumnExpression(dmeasure.getExpression(), "measure");
        resolving.add(dmeasure.getName());
        int i = 0;
        while (i < referencedMeasures.size()) {
            String measureName = referencedMeasures.get(i).toString();
            if (!measures.containsKey(measureName)) {
                if (!calculatedMeasure.containsKey(measureName)) {
                    MeasureHandle measureHandle = mHandles.get(measureName);
                    if (measureHandle == null) {
                        throw new DataException(AdapterResourceHandle.getInstance().getMessage("cube.derivedMeasure.invalid.reference", new Object[]{dmeasure.getName(), measureName}));
                    }
                    throw new DataException(AdapterResourceHandle.getInstance().getMessage("cube.derivedMeasure.resolve.error", new Object[]{resolving.get(0)}));
                }
                int j = 0;
                while (j < resolving.size()) {
                    if (measureName.equals(resolving.get(j))) {
                        resolving.add(measureName);
                        throw new DataException(AdapterResourceHandle.getInstance().getMessage("cube.derivedMeasure.recursive.ref", new Object[]{resolving.get(0), resolving.toString()}));
                    }
                    ++j;
                }
                CubeMeasureUtil.checkDerivedMeasure(calculatedMeasure.get(measureName), resolving, measures, calculatedMeasure, mHandles);
            }
            ++i;
        }
        resolving.remove(resolving.size() - 1);
    }

    public static List<MeasureHandle> getIndependentReferences(CubeHandle cubeHandle, String measureName) throws BirtException {
        ArrayList<MeasureHandle> iMeasures = new ArrayList<MeasureHandle>();
        ArrayList<String> mNames = new ArrayList<String>();
        HashMap<String, IMeasureDefinition> measures = new HashMap<String, IMeasureDefinition>();
        HashMap<String, IDerivedMeasureDefinition> calculatedMeasures = new HashMap<String, IDerivedMeasureDefinition>();
        HashMap<String, MeasureHandle> mHandles = new HashMap<String, MeasureHandle>();
        CubeMeasureUtil.populateMeasures(measures, calculatedMeasures, mHandles, cubeHandle);
        if (mHandles.get(measureName) != null && !((MeasureHandle)mHandles.get(measureName)).isCalculated()) {
            for (Map.Entry e : mHandles.entrySet()) {
                MeasureHandle handle = (MeasureHandle)e.getValue();
                if (measureName.equals(handle.getName())) continue;
                iMeasures.add(handle);
            }
            return iMeasures;
        }
        for (Map.Entry e : calculatedMeasures.entrySet()) {
            ArrayList<String> resolving = new ArrayList<String>();
            resolving.add(measureName);
            try {
                CubeMeasureUtil.checkDerivedMeasure((IDerivedMeasureDefinition)e.getValue(), resolving, measures, calculatedMeasures, mHandles);
                mNames.add(((IDerivedMeasureDefinition)e.getValue()).getName());
            }
            catch (BirtException birtException) {
                // empty catch block
            }
        }
        for (String i : mNames) {
            if (i.equals(measureName)) continue;
            iMeasures.add((MeasureHandle)mHandles.get(i));
        }
        for (Map.Entry e : measures.entrySet()) {
            iMeasures.add((MeasureHandle)mHandles.get(e.getKey()));
        }
        return iMeasures;
    }
}

