/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.data.adapter.api.IDimensionLevel;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.AbstractCrosstabModelTask;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;

public class DimensionViewTask
extends AbstractCrosstabModelTask {
    protected DimensionViewHandle dimensionView = null;
    protected int axisType;

    public DimensionViewTask(DimensionViewHandle focus) {
        super(focus);
        this.dimensionView = focus;
        this.axisType = this.dimensionView.getAxisType();
    }

    public LevelViewHandle insertLevel(LevelHandle levelHandle, int index) throws SemanticException {
        if (levelHandle != null) {
            if (!levelHandle.getContainer().getContainer().getQualifiedName().equals(this.dimensionView.getCubeDimensionName())) {
                this.dimensionView.getLogger().log(Level.WARNING, "");
                return null;
            }
            if (this.dimensionView.getLevel(levelHandle.getQualifiedName()) != null) {
                this.dimensionView.getLogger().log(Level.SEVERE, "Error.CrosstabException.DUPLICATE_LEVEL", levelHandle.getQualifiedName());
                throw new CrosstabException(this.dimensionView.getModelHandle().getElement(), Messages.getString("Error.CrosstabException.DUPLICATE_LEVEL", levelHandle.getQualifiedName()));
            }
        }
        CommandStack stack = this.dimensionView.getCommandStack();
        stack.startTrans(Messages.getString("DimensionViewTask.msg.insert.level"));
        LevelViewHandle levelView = null;
        try {
            ExtendedItemHandle extendedItemHandle = CrosstabExtendedItemFactory.createLevelView(this.dimensionView.getModuleHandle(), levelHandle);
            if (extendedItemHandle != null) {
                this.dimensionView.getLevelsProperty().add(extendedItemHandle, index);
                levelView = (LevelViewHandle)CrosstabUtil.getReportItem(extendedItemHandle, "LevelView");
                if (levelHandle != null && this.crosstab != null) {
                    this.doPostInsert(levelView);
                    CrosstabModelUtil.updateHeaderCell(this.dimensionView.getCrosstab(), CrosstabModelUtil.findPriorLevelCount(this.dimensionView) + index, this.dimensionView.getAxisType());
                }
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return levelView;
    }

    private void doPostInsert(LevelViewHandle levelView) throws SemanticException {
        if (levelView.isInnerMost()) {
            if (CrosstabModelUtil.getAllLevelCount(this.crosstab, this.axisType) <= 1) {
                this.addAggregationForLevel(levelView, this.axisType);
                if (this.crosstab.getGrandTotal(this.axisType) == null) {
                    this.removeMeasureAggregations(this.axisType);
                }
            } else {
                this.addAggregationForLevel(levelView, this.axisType);
                LevelViewHandle precedingLevel = CrosstabModelUtil.getPrecedingLevel(levelView);
                int counterAxisType = CrosstabModelUtil.getOppositeAxisType(this.axisType);
                assert (precedingLevel != null);
                LevelViewHandle innerMostLevelView = CrosstabModelUtil.getInnerMostLevel(this.crosstab, counterAxisType);
                if (precedingLevel.getAggregationHeader() != null) {
                    if (innerMostLevelView != null) {
                        String dimensionName = ((DimensionViewHandle)innerMostLevelView.getContainer()).getCubeDimensionName();
                        String levelName = innerMostLevelView.getCubeLevelName();
                        List measureList = precedingLevel.getAggregationMeasures();
                        ArrayList<String> functionList = new ArrayList<String>();
                        int i = 0;
                        while (i < measureList.size()) {
                            MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                            String function = precedingLevel.getAggregationFunction(measureView);
                            functionList.add(function);
                            ++i;
                        }
                        this.addMeasureAggregations(this.crosstab, dimensionName, levelName, counterAxisType, ((DimensionViewHandle)precedingLevel.getContainer()).getCubeDimensionName(), precedingLevel.getCubeLevelName(), measureList, functionList);
                    }
                } else {
                    this.removeMeasureAggregations(precedingLevel);
                }
            }
            LevelViewHandle innerestRowLevel = CrosstabModelUtil.getInnerMostLevel(this.crosstab, 0);
            LevelViewHandle innerestColLevel = CrosstabModelUtil.getInnerMostLevel(this.crosstab, 1);
            this.validateMeasureDetails(innerestRowLevel, innerestColLevel);
        } else if (levelView.getAggregationHeader() != null) {
            this.addAggregationForLevel(levelView, this.axisType);
            this.addTotalMeasureHeader(this.axisType, levelView);
        }
    }

    private void addMeasureAggregations(CrosstabReportItemHandle crosstab, String leftDimension, String leftLevel, int axisType, String rightDimension, String rightLevel, List<MeasureViewHandle> measures, List<String> functions) throws SemanticException {
        if (crosstab == null || !CrosstabModelUtil.isValidAxisType(axisType) || measures == null) {
            return;
        }
        if (functions == null || functions.size() != measures.size()) {
            return;
        }
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;
        if (axisType == 0) {
            rowDimension = leftDimension;
            rowLevel = leftLevel;
            colDimension = rightDimension;
            colLevel = rightLevel;
        } else if (axisType == 1) {
            rowDimension = rightDimension;
            rowLevel = rightLevel;
            colDimension = leftDimension;
            colLevel = leftLevel;
        }
        int i = 0;
        while (i < measures.size()) {
            MeasureViewHandle measureView = measures.get(i);
            if (measureView.getCrosstab() == crosstab) {
                this.validateSingleMeasureAggregation(crosstab, measureView, functions.get(i), rowDimension, rowLevel, colDimension, colLevel);
            }
            ++i;
        }
    }

    private void addAggregationForLevel(LevelViewHandle levelView, int axisType) throws SemanticException {
        assert (CrosstabModelUtil.isValidAxisType(axisType));
        if (levelView != null && levelView.getAxisType() != axisType) {
            return;
        }
        int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
        int dimension = 0;
        while (dimension < this.crosstab.getDimensionCount(counterAxisType)) {
            DimensionViewHandle tempDimensionView = this.crosstab.getDimension(counterAxisType, dimension);
            int level = 0;
            while (level < tempDimensionView.getLevelCount()) {
                boolean isInnerMost;
                LevelViewHandle tempLevelView = tempDimensionView.getLevel(level);
                if (!(levelView != null && (isInnerMost = levelView.isInnerMost()) && tempLevelView.isInnerMost() || tempLevelView.getAggregationHeader() == null)) {
                    List measureList = tempLevelView.getAggregationMeasures();
                    AbstractCrosstabModelTask.AggregationInfo infor = this.getAggregationInfo(levelView, tempLevelView);
                    int i = 0;
                    while (i < measureList.size()) {
                        MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                        String function = tempLevelView.getAggregationFunction(measureView);
                        this.validateSingleMeasureAggregation(this.crosstab, measureView, function, infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
                        ++i;
                    }
                }
                ++level;
            }
            ++dimension;
        }
        if (this.crosstab.getGrandTotal(counterAxisType) != null || CrosstabModelUtil.getAllLevelCount(this.crosstab, counterAxisType) == 0) {
            List<MeasureViewHandle> measureList = this.crosstab.getAggregationMeasures(counterAxisType);
            AbstractCrosstabModelTask.AggregationInfo infor = this.getAggregationInfo(levelView, null);
            int i = 0;
            while (i < measureList.size()) {
                MeasureViewHandle measureView = measureList.get(i);
                String function = this.crosstab.getAggregationFunction(counterAxisType, measureView);
                this.validateSingleMeasureAggregation(this.crosstab, measureView, function, infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
                ++i;
            }
        }
    }

    public void removeLevel(String name) throws SemanticException {
        LevelViewHandle levelView = this.dimensionView.getLevel(name);
        if (levelView != null) {
            this.removeLevel(levelView, true);
        }
    }

    void removeLevel(LevelViewHandle levelView, boolean needTransaction) throws SemanticException {
        assert (levelView != null);
        CommandStack stack = null;
        if (needTransaction) {
            stack = this.dimensionView.getCommandStack();
            stack.startTrans(Messages.getString("DimensionViewTask.msg.remove.level"));
        }
        try {
            if (this.crosstab != null) {
                this.doPreRemove(levelView);
            }
            int count = CrosstabModelUtil.findPriorLevelCount(this.dimensionView);
            levelView.getModelHandle().drop();
            CrosstabModelUtil.updateHeaderCell(this.dimensionView.getCrosstab(), count += levelView.getIndex(), this.dimensionView.getAxisType(), true);
            CrosstabModelUtil.updateRPTMeasureAggregation(this.dimensionView.getCrosstab());
            if (this.crosstab != null) {
                this.validateFilterCondition();
                this.validateSort();
            }
        }
        catch (SemanticException e) {
            if (needTransaction) {
                stack.rollback();
            }
            throw e;
        }
        if (needTransaction) {
            stack.commit();
        }
    }

    public void removeLevel(int index) throws SemanticException {
        LevelViewHandle levelView = this.dimensionView.getLevel(index);
        if (levelView != null) {
            this.removeLevel(levelView, true);
        }
    }

    private void doPreRemove(LevelViewHandle levelView) throws SemanticException {
        if (this.crosstab == null) {
            return;
        }
        int axisType = this.dimensionView.getAxisType();
        if (levelView.isInnerMost()) {
            if (CrosstabModelUtil.getAllLevelCount(this.crosstab, axisType) <= 1) {
                if (this.crosstab.getGrandTotal(axisType) == null) {
                    this.addAggregationForLevel(null, axisType);
                }
                this.removeMeasureAggregations(levelView);
                int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
                LevelViewHandle innerestCounterAxisLevel = CrosstabModelUtil.getInnerMostLevel(this.crosstab, counterAxisType);
                if (axisType == 0) {
                    this.validateMeasureDetails(null, innerestCounterAxisLevel);
                } else {
                    this.validateMeasureDetails(innerestCounterAxisLevel, null);
                }
            } else {
                LevelViewHandle precedingLevel = CrosstabModelUtil.getPrecedingLevel(levelView);
                int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
                assert (precedingLevel != null);
                if (precedingLevel.getAggregationHeader() != null) {
                    LevelViewHandle innerMostLevelView = CrosstabModelUtil.getInnerMostLevel(this.crosstab, counterAxisType);
                    if (innerMostLevelView != null) {
                        this.removeTotalMeasureHeader(axisType, precedingLevel);
                        this.removeMeasureAggregation(precedingLevel, innerMostLevelView);
                        precedingLevel.getAggregationHeaderProperty().drop(0);
                        this.addAggregationForLevel(precedingLevel, axisType);
                    } else {
                        precedingLevel.removeSubTotal();
                    }
                } else {
                    this.addAggregationForLevel(precedingLevel, axisType);
                }
                this.removeMeasureAggregations(levelView);
                LevelViewHandle innerestCounterAxisLevel = CrosstabModelUtil.getInnerMostLevel(this.crosstab, counterAxisType);
                if (axisType == 0) {
                    this.validateMeasureDetails(precedingLevel, innerestCounterAxisLevel);
                } else {
                    this.validateMeasureDetails(innerestCounterAxisLevel, precedingLevel);
                }
            }
        } else if (levelView.getAggregationHeader() != null) {
            this.removeTotalMeasureHeader(axisType, levelView);
            this.removeMeasureAggregations(levelView);
        }
        LevelHandle mirrorLevel = this.crosstab.getCrosstabView(axisType).getMirroredStartingLevel();
        if (mirrorLevel != null && levelView.getCubeLevel() == mirrorLevel) {
            this.crosstab.getCrosstabView(axisType).setMirroredStartingLevel(null);
        }
    }

    private void validateFilterCondition() throws SemanticException {
        this.validateProperty("filter", "expr", "member");
    }

    private void validateSort() throws SemanticException {
        this.validateProperty("sort", "key", "member");
    }

    private void validateProperty(String propName, String exprePropName, String memberValuePropName) throws SemanticException {
        assert (this.crosstab != null);
        CubeHandle cube = this.crosstab.getCube();
        if (cube == null) {
            return;
        }
        int counterAxisType = CrosstabModelUtil.getOppositeAxisType(this.axisType);
        int dimension = 0;
        while (dimension < this.crosstab.getDimensionCount(counterAxisType)) {
            DimensionViewHandle dimensionView = this.crosstab.getDimension(counterAxisType, dimension);
            int level = 0;
            while (level < dimensionView.getLevelCount()) {
                LevelViewHandle levelView = dimensionView.getLevel(level);
                DesignElementHandle levelHandle = levelView.getModelHandle();
                int count = levelHandle.getContentCount(propName);
                int i = 0;
                while (i < count) {
                    DesignElementHandle item = levelHandle.getContent(propName, i);
                    String expression = item.getStringProperty(exprePropName);
                    this.validateMemberValue(cube, levelView, item, expression, memberValuePropName);
                    ++i;
                }
                ++level;
            }
            ++dimension;
        }
    }

    private void validateMemberValue(CubeHandle cube, LevelViewHandle levelView, DesignElementHandle item, String expression, String memberValuePropName) throws SemanticException {
        MemberValueHandle newMemberValue;
        assert (this.crosstab != null);
        assert (cube != null);
        if (!(cube instanceof TabularCubeHandle) || expression == null || expression.length() == 0) {
            return;
        }
        List<IDimensionLevel> validatedLevelList = CrosstabUtil.getReferencedLevels(levelView, expression);
        MemberValueHandle oldMemberValue = (MemberValueHandle)item.getContent(memberValuePropName, 0);
        HashMap<String, String> levelValueMap = new HashMap<String, String>();
        MemberValueHandle tempMember = oldMemberValue;
        while (tempMember != null) {
            String levelName = tempMember.getCubeLevelName();
            String levelValue = tempMember.getValue();
            levelValueMap.put(levelName, levelValue);
            tempMember = (MemberValueHandle)tempMember.getContent("memberValues", 0);
        }
        ElementFactory factory = this.dimensionView.getModuleHandle().getElementFactory();
        tempMember = newMemberValue = factory.newMemberValue();
        MemberValueHandle parentMember = null;
        if (validatedLevelList != null) {
            int i = 0;
            while (i < validatedLevelList.size()) {
                IDimensionLevel levelDefn = validatedLevelList.get(i);
                String levelName = this.getLevelHandle(levelDefn);
                tempMember.setStringProperty("level", levelName);
                Object levelValue = levelValueMap.get(levelName);
                if (levelValue != null) {
                    tempMember.setProperty("value", levelValue);
                    if (parentMember != null) {
                        parentMember.add("memberValues", tempMember, 0);
                    }
                    parentMember = tempMember;
                    tempMember = factory.newMemberValue();
                }
                ++i;
            }
        }
        item.clearProperty(memberValuePropName);
        if (!this.isEmptyMemberValue(newMemberValue)) {
            item.add(memberValuePropName, newMemberValue);
        }
    }

    private boolean isEmptyMemberValue(MemberValueHandle memberValue) {
        assert (memberValue != null);
        String levelName = memberValue.getStringProperty("level");
        if (levelName != null && levelName.length() > 0) {
            return false;
        }
        MemberValueHandle tempMember = (MemberValueHandle)memberValue.getContent("memberValues", 0);
        return tempMember == null || this.isEmptyMemberValue(tempMember);
    }

    private String getLevelHandle(IDimensionLevel levelDefn) {
        assert (this.crosstab != null);
        String levelName = levelDefn.getLevelName();
        String dimensionName = levelDefn.getDimensionName();
        DimensionViewHandle dimension = this.crosstab.getDimension(dimensionName);
        assert (dimension != null);
        LevelViewHandle level = dimension.findLevel(levelName);
        return level.getCubeLevelName();
    }
}

