/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.XAException;
import org.apache.derby.client.BasicClientDataSource;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientCallableStatement;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientDatabaseMetaData;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.ExceptionFormatter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.Version;
import org.apache.derby.shared.common.sanity.SanityManager;

public class LogWriter {
    protected final PrintWriter printWriter_;
    private final int traceLevel_;
    private boolean driverConfigurationHasBeenWrittenToJdbc1Stream_ = false;
    private boolean driverConfigurationHasBeenWrittenToJdbc2Stream_ = false;
    public boolean printWriterNeedsToBeClosed_;

    public LogWriter(PrintWriter printWriter, int traceLevel) {
        this.printWriter_ = printWriter;
        this.traceLevel_ = traceLevel;
    }

    protected final boolean loggingEnabled(int traceLevel) {
        if (this.printWriter_ == null) {
            SanityManager.THROWASSERT("Broken invariant: printWriter_ == null");
        }
        return (traceLevel & this.traceLevel_) != 0;
    }

    void close() {
        if (this.printWriterNeedsToBeClosed_) {
            this.printWriter_.close();
            this.printWriterNeedsToBeClosed_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprintln(String s) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.println("[derby] " + s);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprint(String s) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby] " + s);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprintln(String header, String s) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.println("[derby]" + header + " " + s);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprint(String header, String s) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby]" + header + " " + s);
            this.printWriter_.flush();
        }
    }

    public void tracepoint(String component, int tracepoint, String classContext, String methodContext) {
        String staticContextTracepointRecord = component + "[time:" + System.currentTimeMillis() + "][thread:" + Thread.currentThread().getName() + "][tracepoint:" + tracepoint + "][" + classContext + "." + methodContext + "]";
        this.dncprintln(staticContextTracepointRecord);
    }

    private void traceExternalMethod(Object instance, String className, String methodName) {
        this.dncprint(this.buildExternalMethodHeader(instance, className), methodName);
    }

    private void traceExternalDeprecatedMethod(Object instance, String className, String methodName) {
        this.dncprint(this.buildExternalMethodHeader(instance, className), "Deprecated " + methodName);
    }

    private String buildExternalMethodHeader(Object instance, String className) {
        return "[Time:" + System.currentTimeMillis() + "][Thread:" + Thread.currentThread().getName() + "][" + className + "@" + Integer.toHexString(instance.hashCode()) + "]";
    }

    private String getClassNameOfInstanceIfTraced(Object instance) {
        if (instance == null) {
            return null;
        }
        if (instance instanceof ClientConnection && this.loggingEnabled(1)) {
            return "ClientConnection";
        }
        if (instance instanceof ClientResultSet && this.loggingEnabled(4)) {
            return "ClientResultSet";
        }
        if (instance instanceof ClientCallableStatement && this.loggingEnabled(2)) {
            return "ClientCallableStatement";
        }
        if (instance instanceof ClientPreparedStatement && this.loggingEnabled(2)) {
            return "ClientPreparedStatement";
        }
        if (instance instanceof ClientStatement && this.loggingEnabled(2)) {
            return "ClientStatement";
        }
        if (instance instanceof ClientBlob && this.loggingEnabled(-1)) {
            return "ClientBlob";
        }
        if (instance instanceof ClientClob && this.loggingEnabled(-1)) {
            return "ClientClob";
        }
        if (instance instanceof ClientDatabaseMetaData && this.loggingEnabled(-1)) {
            return "ClientDatabaseMetaData";
        }
        if (this.loggingEnabled(2048) && instance.getClass().getName().startsWith("org.apache.derby.client.net.NetXAResource")) {
            return "NetXAResource";
        }
        if (this.loggingEnabled(-1) && instance.getClass().getName().equals("org.apache.derby.client.ClientPooledConnection")) {
            return "ClientPooledConnection";
        }
        if (this.loggingEnabled(-1) && instance.getClass().getName().equals("org.apache.derby.jdbc.ClientConnectionPoolDataSource")) {
            return "ClientConnectionPoolDataSource";
        }
        if (this.loggingEnabled(-1) && instance.getClass().getName().equals("org.apache.derby.client.ClientXAConnection")) {
            return "ClientXAConnection";
        }
        if (this.loggingEnabled(-1) && instance.getClass().getName().equals("org.apache.derby.jdbc.ClientDataSource")) {
            return "ClientDataSource";
        }
        if (this.loggingEnabled(-1) && instance.getClass().getName().equals("org.apache.derby.jdbc.ClientXADataSource")) {
            return "ClientXADataSource";
        }
        return instance.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceExit(Object instance, String methodName, Object returnValue) {
        String className = this.getClassNameOfInstanceIfTraced(instance);
        if (className == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalMethod(instance, className, methodName);
            this.printWriter_.println(" () returned " + returnValue);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceDeprecatedExit(Object instance, String methodName, Object returnValue) {
        String className = this.getClassNameOfInstanceIfTraced(instance);
        if (className == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalDeprecatedMethod(instance, className, methodName);
            this.printWriter_.println(" () returned " + returnValue);
            this.printWriter_.flush();
        }
    }

    void traceExit(Object instance, String methodName, ClientResultSet resultSet) {
        String returnValue = resultSet == null ? "ResultSet@null" : "ResultSet@" + Integer.toHexString(resultSet.hashCode());
        this.traceExit(instance, methodName, returnValue);
    }

    void traceExit(Object instance, String methodName, ClientStatement returnValue) {
        this.traceExit(instance, methodName, "Statement@" + Integer.toHexString(returnValue.hashCode()));
    }

    void traceExit(Object instance, String methodName, ClientBlob blob) {
        String returnValue = blob == null ? "Blob@null" : "Blob@" + Integer.toHexString(blob.hashCode());
        this.traceExit(instance, methodName, returnValue);
    }

    void traceExit(Object instance, String methodName, ClientClob clob) {
        String returnValue = clob == null ? "Clob@null" : "Clob@" + Integer.toHexString(clob.hashCode());
        this.traceExit(instance, methodName, returnValue);
    }

    void traceExit(Object instance, String methodName, ClientDatabaseMetaData returnValue) {
        this.traceExit(instance, methodName, "DatabaseMetaData@" + Integer.toHexString(returnValue.hashCode()));
    }

    void traceExit(Object instance, String methodName, ClientConnection returnValue) {
        this.traceExit(instance, methodName, "Connection@" + Integer.toHexString(returnValue.hashCode()));
    }

    void traceExit(Object instance, String methodName, ColumnMetaData returnValue) {
        this.traceExit(instance, methodName, "MetaData@" + (returnValue != null ? Integer.toHexString(returnValue.hashCode()) : null));
    }

    void traceExit(Object instance, String methodName, byte[] returnValue) {
        this.traceExit(instance, methodName, Utils.getStringFromBytes(returnValue));
    }

    void traceExit(Object instance, String methodName, byte returnValue) {
        this.traceExit(instance, methodName, "0x" + Integer.toHexString(returnValue & 0xFF));
    }

    public void traceEntry(Object instance, String methodName, Object ... args) {
        this.traceEntryAllArgs(instance, methodName, false, args);
    }

    public void traceDeprecatedEntry(Object instance, String methodName, Object ... args) {
        this.traceEntryAllArgs(instance, methodName, true, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceEntryAllArgs(Object instance, String methodName, boolean deprecated, Object[] args) {
        String className = this.getClassNameOfInstanceIfTraced(instance);
        if (className == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            if (deprecated) {
                this.traceExternalDeprecatedMethod(instance, className, methodName);
            } else {
                this.traceExternalMethod(instance, className, methodName);
            }
            this.printWriter_.print(" (");
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    this.printWriter_.print(", ");
                }
                this.printWriter_.print(LogWriter.toPrintableString(args[i]));
            }
            this.printWriter_.println(") called");
            this.printWriter_.flush();
        }
    }

    private static String toPrintableString(Object o) {
        if (o instanceof byte[]) {
            return Utils.getStringFromBytes((byte[])o);
        }
        if (o instanceof Byte) {
            return "0x" + Integer.toHexString((Byte)o & 0xFF);
        }
        return String.valueOf(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceDiagnosable(SqlException e) {
        if (!this.loggingEnabled(512)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_DIAGNOSTICS");
            ExceptionFormatter.printTrace(e, this.printWriter_, "[derby]", true);
            this.dncprintln("END TRACE_DIAGNOSTICS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceDiagnosable(SQLException e) {
        if (!this.loggingEnabled(512)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_DIAGNOSTICS");
            ExceptionFormatter.printTrace(e, this.printWriter_, "[derby]", true);
            this.dncprintln("END TRACE_DIAGNOSTICS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceDiagnosable(XAException e) {
        if (!this.loggingEnabled(512)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_DIAGNOSTICS");
            ExceptionFormatter.printTrace(e, this.printWriter_, "[derby]");
            this.dncprintln("END TRACE_DIAGNOSTICS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceParameterMetaData(ClientStatement statement, ColumnMetaData columnMetaData) {
        if (!this.loggingEnabled(256) || columnMetaData == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String header = "[ParameterMetaData@" + Integer.toHexString(columnMetaData.hashCode()) + "]";
            try {
                this.dncprintln(header, "BEGIN TRACE_PARAMETER_META_DATA");
                this.dncprintln(header, "Parameter meta data for statement Statement@" + Integer.toHexString(statement.hashCode()));
                this.dncprintln(header, "Number of parameter columns: " + columnMetaData.getColumnCount());
                this.traceColumnMetaData(header, columnMetaData);
                this.dncprintln(header, "END TRACE_PARAMETER_META_DATA");
            }
            catch (SQLException e) {
                this.dncprintln(header, "Encountered an SQL exception while trying to trace parameter meta data");
                this.dncprintln(header, "END TRACE_PARAMETER_META_DATA");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceResultSetMetaData(ClientStatement statement, ColumnMetaData columnMetaData) {
        if (!this.loggingEnabled(128) || columnMetaData == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String header = "[ResultSetMetaData@" + Integer.toHexString(columnMetaData.hashCode()) + "]";
            try {
                this.dncprintln(header, "BEGIN TRACE_RESULT_SET_META_DATA");
                this.dncprintln(header, "Result set meta data for statement Statement@" + Integer.toHexString(statement.hashCode()));
                this.dncprintln(header, "Number of result set columns: " + columnMetaData.getColumnCount());
                this.traceColumnMetaData(header, columnMetaData);
                this.dncprintln(header, "END TRACE_RESULT_SET_META_DATA");
            }
            catch (SQLException e) {
                this.dncprintln(header, "Encountered an SQL exception while trying to trace result set meta data");
                this.dncprintln(header, "END TRACE_RESULT_SET_META_DATA");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceColumnMetaData(String header, ColumnMetaData columnMetaData) {
        try {
            PrintWriter printWriter = this.printWriter_;
            synchronized (printWriter) {
                for (int column = 1; column <= columnMetaData.getColumnCount(); ++column) {
                    this.dncprint(header, "Column " + column + ": { ");
                    this.printWriter_.print("label=" + columnMetaData.getColumnLabel(column) + ", ");
                    this.printWriter_.print("name=" + columnMetaData.getColumnName(column) + ", ");
                    this.printWriter_.print("type name=" + columnMetaData.getColumnTypeName(column) + ", ");
                    this.printWriter_.print("type=" + columnMetaData.getColumnType(column) + ", ");
                    this.printWriter_.print("nullable=" + columnMetaData.isNullable(column) + ", ");
                    this.printWriter_.print("precision=" + columnMetaData.getPrecision(column) + ", ");
                    this.printWriter_.print("scale=" + columnMetaData.getScale(column) + ", ");
                    this.printWriter_.print("schema name=" + columnMetaData.getSchemaName(column) + ", ");
                    this.printWriter_.print("table name=" + columnMetaData.getTableName(column) + ", ");
                    this.printWriter_.print("writable=" + columnMetaData.isWritable(column) + ", ");
                    this.printWriter_.print("sqlPrecision=" + (String)(columnMetaData.sqlPrecision_ == null ? "<null>" : "" + columnMetaData.sqlPrecision_[column - 1]) + ", ");
                    this.printWriter_.print("sqlScale=" + (String)(columnMetaData.sqlScale_ == null ? "<null>" : "" + columnMetaData.sqlScale_[column - 1]) + ", ");
                    this.printWriter_.print("sqlLength=" + (String)(columnMetaData.sqlLength_ == null ? "<null>" : "" + columnMetaData.sqlLength_[column - 1]) + ", ");
                    this.printWriter_.print("sqlType=" + (String)(columnMetaData.sqlType_ == null ? "<null>" : "" + columnMetaData.sqlType_[column - 1]) + ", ");
                    this.printWriter_.print("sqlCcsid=" + (String)(columnMetaData.sqlCcsid_ == null ? "<null>" : "" + columnMetaData.sqlCcsid_[column - 1]) + ", ");
                    this.printWriter_.print("sqlName=" + (columnMetaData.sqlName_ == null ? "<null>" : columnMetaData.sqlName_[column - 1]) + ", ");
                    this.printWriter_.print("sqlLabel=" + (columnMetaData.sqlLabel_ == null ? "<null>" : columnMetaData.sqlLabel_[column - 1]) + ", ");
                    this.printWriter_.print("sqlUnnamed=" + (String)(columnMetaData.sqlUnnamed_ == null ? "<null>" : "" + columnMetaData.sqlUnnamed_[column - 1]) + ", ");
                    this.printWriter_.print("sqlComment=" + (columnMetaData.sqlComment_ == null ? "<null>" : columnMetaData.sqlComment_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxKeymem=" + (String)(columnMetaData.sqlxKeymem_ == null ? "<null>" : "" + columnMetaData.sqlxKeymem_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxGenerated=" + (String)(columnMetaData.sqlxGenerated_ == null ? "<null>" : "" + columnMetaData.sqlxGenerated_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxParmmode=" + (String)(columnMetaData.sqlxParmmode_ == null ? "<null>" : "" + columnMetaData.sqlxParmmode_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxCorname=" + (columnMetaData.sqlxCorname_ == null ? "<null>" : columnMetaData.sqlxCorname_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxName=" + (columnMetaData.sqlxName_ == null ? "<null>" : columnMetaData.sqlxName_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxBasename=" + (columnMetaData.sqlxBasename_ == null ? "<null>" : columnMetaData.sqlxBasename_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxUpdatable=" + (String)(columnMetaData.sqlxUpdatable_ == null ? "<null>" : "" + columnMetaData.sqlxUpdatable_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxSchema=" + (columnMetaData.sqlxSchema_ == null ? "<null>" : columnMetaData.sqlxSchema_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxRdbnam=" + (columnMetaData.sqlxRdbnam_ == null ? "<null>" : columnMetaData.sqlxRdbnam_[column - 1]) + ", ");
                    this.printWriter_.print("internal type=" + columnMetaData.types_[column - 1] + ", ");
                    this.printWriter_.println(" }");
                }
                this.dncprint(header, "{ ");
                this.printWriter_.print("sqldHold=" + columnMetaData.sqldHold_ + ", ");
                this.printWriter_.print("sqldReturn=" + columnMetaData.sqldReturn_ + ", ");
                this.printWriter_.print("sqldScroll=" + columnMetaData.sqldScroll_ + ", ");
                this.printWriter_.print("sqldSensitive=" + columnMetaData.sqldSensitive_ + ", ");
                this.printWriter_.print("sqldFcode=" + columnMetaData.sqldFcode_ + ", ");
                this.printWriter_.print("sqldKeytype=" + columnMetaData.sqldKeytype_ + ", ");
                this.printWriter_.print("sqldRdbnam=" + columnMetaData.sqldRdbnam_ + ", ");
                this.printWriter_.print("sqldSchema=" + columnMetaData.sqldSchema_);
                this.printWriter_.println(" }");
                this.printWriter_.flush();
            }
        }
        catch (SQLException e) {
            this.dncprintln(header, "Encountered an SQL exception while trying to trace column meta data");
        }
    }

    void traceConnectEntry(BasicClientDataSource dataSource) {
        if (this.loggingEnabled(16)) {
            this.traceDriverConfigurationJdbc2();
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsEntry(dataSource);
        }
    }

    void traceConnectEntry(String server, int port, String database, Properties properties) {
        if (this.loggingEnabled(16)) {
            this.traceDriverConfigurationJdbc1();
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsEntry(server, port, database, properties);
        }
    }

    void traceConnectResetEntry(Object instance, LogWriter logWriter, String user, BasicClientDataSource ds) {
        this.traceEntry(instance, "reset", logWriter, user, "<escaped>", ds);
        if (this.loggingEnabled(32)) {
            this.traceConnectsResetEntry(ds);
        }
    }

    void traceConnectExit(ClientConnection connection) {
        if (this.loggingEnabled(32)) {
            this.traceConnectsExit(connection);
        }
    }

    public void traceConnectResetExit(ClientConnection connection) {
        if (this.loggingEnabled(32)) {
            this.traceConnectsResetExit(connection);
        }
    }

    private void traceConnectsResetEntry(BasicClientDataSource dataSource) {
        try {
            this.traceConnectsResetEntry(dataSource.getServerName(), dataSource.getPortNumber(), dataSource.getDatabaseName(), this.getProperties(dataSource));
        }
        catch (SqlException se) {
            this.dncprintln("Encountered an SQL exception while trying to trace connection reset entry");
        }
    }

    private void traceConnectsEntry(BasicClientDataSource dataSource) {
        try {
            this.traceConnectsEntry(dataSource.getServerName(), dataSource.getPortNumber(), dataSource.getDatabaseName(), this.getProperties(dataSource));
        }
        catch (SqlException se) {
            this.dncprintln("Encountered an SQL exception while trying to trace connection entry");
        }
    }

    private void traceConnectsResetEntry(String server, int port, String database, Properties properties) {
        this.dncprintln("BEGIN TRACE_CONNECT_RESET");
        this.dncprintln("Connection reset requested for " + server + ":" + port + "/" + database);
        this.dncprint("Using properties: ");
        this.writeProperties(properties);
        this.dncprintln("END TRACE_CONNECT_RESET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceConnectsEntry(String server, int port, String database, Properties properties) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_CONNECTS");
            this.dncprintln("Attempting connection to " + server + ":" + port + "/" + database);
            this.dncprint("Using properties: ");
            this.writeProperties(properties);
            this.dncprintln("END TRACE_CONNECTS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceConnectsExit(ClientConnection c) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String header = "[Connection@" + Integer.toHexString(c.hashCode()) + "]";
            try {
                this.dncprintln(header, "BEGIN TRACE_CONNECTS");
                this.dncprintln(header, "Successfully connected to server " + c.databaseMetaData_.getURL());
                this.dncprintln(header, "User: " + c.databaseMetaData_.getUserName());
                this.dncprintln(header, "Database product name: " + c.databaseMetaData_.getDatabaseProductName());
                this.dncprintln(header, "Database product version: " + c.databaseMetaData_.getDatabaseProductVersion());
                this.dncprintln(header, "Driver name: " + c.databaseMetaData_.getDriverName());
                this.dncprintln(header, "Driver version: " + c.databaseMetaData_.getDriverVersion());
                this.dncprintln(header, "END TRACE_CONNECTS");
            }
            catch (SQLException e) {
                this.dncprintln(header, "Encountered an SQL exception while trying to trace connection exit");
                this.dncprintln(header, "END TRACE_CONNECTS");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceConnectsResetExit(ClientConnection c) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String header = "[Connection@" + Integer.toHexString(c.hashCode()) + "]";
            try {
                this.dncprintln(header, "BEGIN TRACE_CONNECT_RESET");
                this.dncprintln(header, "Successfully reset connection to server " + c.databaseMetaData_.getURL());
                this.dncprintln(header, "User: " + c.databaseMetaData_.getUserName());
                this.dncprintln(header, "Database product name: " + c.databaseMetaData_.getDatabaseProductName());
                this.dncprintln(header, "Database product version: " + c.databaseMetaData_.getDatabaseProductVersion());
                this.dncprintln(header, "Driver name: " + c.databaseMetaData_.getDriverName());
                this.dncprintln(header, "Driver version: " + c.databaseMetaData_.getDriverVersion());
                this.dncprintln(header, "END TRACE_CONNECT_RESET");
            }
            catch (SQLException e) {
                this.dncprintln(header, "Encountered an SQL exception while trying to trace connection reset exit");
                this.dncprintln(header, "END TRACE_CONNECT_RESET");
            }
        }
    }

    private void writeProperties(Properties properties) {
        this.printWriter_.print("{ ");
        Iterator<Map.Entry<Object, Object>> i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> e = i.next();
            if ("password".equals(e.getKey())) {
                this.printWriter_.print("password=" + this.escapePassword((String)e.getValue()));
            } else {
                this.printWriter_.print(e.getKey() + "=" + e.getValue());
            }
            if (!i.hasNext()) continue;
            this.printWriter_.print(", ");
        }
        this.printWriter_.println(" }");
        this.printWriter_.flush();
    }

    private String escapePassword(String pw) {
        StringBuilder sb = new StringBuilder(pw);
        for (int j = 0; j < pw.length(); ++j) {
            sb.setCharAt(j, '*');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDriverConfigurationJdbc2() {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            if (!this.driverConfigurationHasBeenWrittenToJdbc2Stream_) {
                this.writeDriverConfiguration();
                this.driverConfigurationHasBeenWrittenToJdbc2Stream_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDriverConfigurationJdbc1() {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            if (!this.driverConfigurationHasBeenWrittenToJdbc1Stream_) {
                this.writeDriverConfiguration();
                this.driverConfigurationHasBeenWrittenToJdbc1Stream_ = true;
            }
        }
    }

    private void writeDriverConfiguration() {
        Version.writeDriverConfiguration(this.printWriter_);
    }

    private Properties getProperties(BasicClientDataSource cds) throws SqlException {
        Properties properties = BasicClientDataSource.getProperties(cds);
        if (properties.getProperty("password") != null) {
            properties.setProperty("password", "********");
        }
        return properties;
    }
}

