/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.intro.contentproviders;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EclipseRSSViewer
implements IIntroContentProvider {
    private static final int SOCKET_TIMEOUT = 6000;
    private static final String INTRO_SHOW_IN_BROWSER = "http://org.eclipse.ui.intro/openBrowser?url=";
    private static final String HREF_BULLET = "bullet";
    private Map<String, String> params;
    private IIntroContentProviderSite site;
    private boolean disposed;
    private String id;
    private List<NewsItem> items;
    private Composite parent;
    private FormToolkit toolkit;
    private FormText formText;
    private Image bulletImage;
    private boolean threadRunning = false;

    @Override
    public void init(IIntroContentProviderSite site) {
        this.site = site;
        this.refresh();
    }

    @Override
    public void createContent(String id, PrintWriter out) {
        if (this.disposed) {
            return;
        }
        this.id = id;
        this.params = this.setParams(id);
        if (this.items == null) {
            this.createNewsItems();
        }
        if (this.items == null || this.threadRunning) {
            out.print("<p class=\"status-text\">");
            out.print(Messages.RSS_Loading);
            out.println("</p>");
        } else {
            if (this.items.size() > 0) {
                out.println("<ul id=\"news-feed\" class=\"news-list\">");
                for (NewsItem item : this.items) {
                    out.print("<li>");
                    out.print("<a class=\"topicList\" href=\"");
                    out.print(this.createExternalURL(item.url));
                    out.print("\">");
                    out.print(item.label);
                    out.print("</a>");
                    out.print("</li>\n");
                }
                out.println("</ul>");
            } else {
                out.print("<p class=\"status-text\">");
                out.print(Messages.RSS_No_news_please_visit);
                out.print(" <a href=\"");
                out.print(this.createExternalURL(this.getParameter("no_news_url")));
                out.print("\">");
                out.print(this.getParameter("no_news_text"));
                out.print("</a>");
                out.println("</p>");
            }
            URL url = null;
            try {
                url = new URL(this.getParameter("url"));
            }
            catch (MalformedURLException e) {
                ILog.of(this.getClass()).error("Bad URL: " + String.valueOf(url), (Throwable)e);
            }
            if (url != null) {
                out.println("<p><span class=\"rss-feed-link\">");
                out.println("<a href=\"");
                out.println(this.createExternalURL(url.toString()));
                out.println("\">");
                out.println(Messages.RSS_Subscribe);
                out.println("</a>");
                out.println("</span></p>");
            }
        }
    }

    @Override
    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        if (this.disposed) {
            return;
        }
        this.id = id;
        this.params = this.setParams(id);
        if (this.formText == null) {
            this.formText = toolkit.createFormText(parent, true);
            this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    EclipseRSSViewer.this.doNavigate((String)e.getHref());
                }
            });
            this.bulletImage = this.createImage(IPath.fromOSString((String)"icons/arrow.svg"));
            if (this.bulletImage != null) {
                this.formText.setImage(HREF_BULLET, this.bulletImage);
            }
            this.parent = parent;
            this.toolkit = toolkit;
            this.id = id;
            this.params = this.setParams(id);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<form>");
        if (this.items == null) {
            this.createNewsItems();
        }
        if (this.items == null || this.threadRunning) {
            buffer.append("<p>");
            buffer.append(Messages.RSS_Loading);
            buffer.append("</p>");
        } else if (this.items.size() > 0) {
            int i = 0;
            while (i < this.items.size()) {
                NewsItem item = this.items.get(i);
                buffer.append("<li style=\"image\" value=\"");
                buffer.append(HREF_BULLET);
                buffer.append("\">");
                buffer.append("<a href=\"");
                buffer.append(this.createExternalURL(item.url));
                buffer.append("\">");
                buffer.append(item.label);
                buffer.append("</a>");
                buffer.append("</li>");
                ++i;
            }
        } else {
            buffer.append("<p>");
            buffer.append(Messages.RSS_No_news);
            buffer.append("</p>");
        }
        buffer.append("</form>");
        String text = buffer.toString();
        text = text.replaceAll("&{1}", "&amp;");
        this.formText.setText(text, true, false);
    }

    private String createExternalURL(String url) {
        return INTRO_SHOW_IN_BROWSER + URLEncoder.encode(url, StandardCharsets.UTF_8);
    }

    @Override
    public void dispose() {
        if (this.bulletImage != null) {
            this.bulletImage.dispose();
            this.bulletImage = null;
        }
        this.disposed = true;
    }

    private void createNewsItems() {
        ContentThread contentThread = new ContentThread();
        contentThread.start();
        TimeoutThread timeThread = new TimeoutThread();
        timeThread.start();
    }

    private void refresh() {
        Thread newsWorker = new Thread(new NewsFeed());
        newsWorker.start();
    }

    private Image createImage(IPath path) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.intro");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        try {
            url = FileLocator.toFileURL((URL)url);
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            return desc.createImage();
        }
        catch (IOException e) {
            return null;
        }
    }

    private void doNavigate(String url) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), () -> {
            IIntroURL introUrl = IntroURLFactory.createIntroURL(url);
            if (introUrl != null) {
                introUrl.execute();
                return;
            }
            this.openBrowser(url);
        });
    }

    private void openBrowser(String href) {
        try {
            URL url = new URL(href);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(url);
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private Map<String, String> setParams(String query) {
        HashMap<String, String> _params = new HashMap<String, String>();
        if (query != null && query.length() > 1) {
            String[] kvPairs = query.split("##");
            int i = 0;
            while (i < kvPairs.length) {
                String[] kv = kvPairs[i].split("=", 2);
                if (kv.length > 1) {
                    _params.put(kv[0], kv[1]);
                } else {
                    _params.put(kv[0], "");
                }
                ++i;
            }
        }
        return _params;
    }

    private String getParameter(String name) {
        return this.params.get(name);
    }

    private class ContentThread
    extends Thread {
        private ContentThread() {
        }

        @Override
        public void run() {
            EclipseRSSViewer.this.threadRunning = true;
            EclipseRSSViewer.this.items = Collections.synchronizedList(new ArrayList());
            try {
                try {
                    IntroPlugin.logDebug("Open Connection: " + EclipseRSSViewer.this.getParameter("url"));
                    URL url = new URL(EclipseRSSViewer.this.getParameter("url"));
                    URLConnection conn = url.openConnection();
                    conn.setConnectTimeout(6000);
                    conn.connect();
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream in = url.openStream();){
                        SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
                        parser.parse(in, (DefaultHandler)new RSSHandler());
                        EclipseRSSViewer.this.refresh();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    ILog.of(this.getClass()).error(NLS.bind((String)Messages.RSS_Malformed_feed, (Object)EclipseRSSViewer.this.getParameter("url")), (Throwable)e);
                    EclipseRSSViewer.this.refresh();
                    EclipseRSSViewer.this.threadRunning = false;
                }
            }
            finally {
                EclipseRSSViewer.this.threadRunning = false;
            }
        }
    }

    class NewsFeed
    implements Runnable {
        NewsFeed() {
        }

        @Override
        public void run() {
            if (EclipseRSSViewer.this.disposed) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                if (EclipseRSSViewer.this.parent != null) {
                    EclipseRSSViewer.this.createContent(EclipseRSSViewer.this.id, EclipseRSSViewer.this.parent, EclipseRSSViewer.this.toolkit);
                }
                EclipseRSSViewer.this.site.reflow(EclipseRSSViewer.this, true);
            });
        }
    }

    static class NewsItem {
        String label;
        String url;

        NewsItem() {
        }

        void setLabel(String label) {
            this.label = label;
        }

        void setUrl(String url) {
            this.url = url;
        }
    }

    private class RSSHandler
    extends DefaultHandler {
        private static final String ELEMENT_RSS = "rss";
        private static final String ELEMENT_CHANNEL = "channel";
        private static final String ELEMENT_ITEM = "item";
        private static final String ELEMENT_TITLE = "title";
        private static final String ELEMENT_LINK = "link";
        private final Stack<String> stack = new Stack();
        private StringBuilder buf;
        private NewsItem item;

        private RSSHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.stack.push(qName);
            if ((ELEMENT_TITLE.equals(qName) || ELEMENT_LINK.equals(qName)) && this.item != null) {
                this.buf = new StringBuilder();
            } else if (ELEMENT_ITEM.equals(qName) && ELEMENT_CHANNEL.equals(this.stack.get(1)) && ELEMENT_RSS.equals(this.stack.get(0)) && this.stack.size() == 3 && EclipseRSSViewer.this.items.size() < Integer.parseInt(EclipseRSSViewer.this.getParameter("welcome_items"))) {
                this.item = new NewsItem();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.stack.pop();
            if (this.item != null) {
                if (this.buf != null) {
                    if (ELEMENT_TITLE.equals(qName)) {
                        this.item.setLabel(this.buf.toString().trim());
                        this.buf = null;
                    } else if (ELEMENT_LINK.equals(qName)) {
                        this.item.setUrl(this.buf.toString().trim());
                        this.buf = null;
                    }
                } else if (ELEMENT_ITEM.equals(qName)) {
                    if (this.item.label != null && this.item.label.length() > 0 && this.item.url != null && this.item.url.length() > 0) {
                        EclipseRSSViewer.this.items.add(this.item);
                    }
                    this.item = null;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buf != null) {
                this.buf.append(new String(ch, start, length));
            }
        }
    }

    private class TimeoutThread
    extends Thread {
        private TimeoutThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(6000L);
            }
            catch (Exception ex) {
                ILog.of(this.getClass()).error("Timeout failed.", (Throwable)ex);
            }
            if (EclipseRSSViewer.this.threadRunning) {
                EclipseRSSViewer.this.threadRunning = false;
                EclipseRSSViewer.this.refresh();
            }
        }
    }
}

