/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.compare.internal.AddFromHistoryDialog;
import org.eclipse.compare.internal.BaseCompareAction;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class AddFromHistoryAction
extends BaseCompareAction {
    private static final String BUNDLE_NAME = "org.eclipse.compare.internal.AddFromHistoryAction";

    @Override
    protected boolean isEnabled(ISelection selection) {
        return Utilities.getResources(selection).length == 1;
    }

    @Override
    protected void run(ISelection selection) {
        IResource[] s;
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        String title = Utilities.getString(bundle, "title");
        Shell parentShell = CompareUIPlugin.getShell();
        AddFromHistoryDialog dialog = null;
        IResource[] iResourceArray = s = Utilities.getResources(selection);
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            IResource o = iResourceArray[n2];
            if (o instanceof IContainer) {
                AddFromHistoryDialog.HistoryInput[] selected;
                IContainer container = (IContainer)o;
                ProgressMonitorDialog pmdialog = new ProgressMonitorDialog(parentShell);
                IProgressMonitor pm = pmdialog.getProgressMonitor();
                IFile[] states = null;
                try {
                    states = container.findDeletedMembersWithHistory(2, pm);
                }
                catch (CoreException ex) {
                    pm.done();
                }
                if (states.length == 1 && states[0].getFullPath().equals((Object)container.getFullPath())) {
                    states = null;
                }
                if (states == null || states.length <= 0) {
                    String msg = Utilities.getString(bundle, "noLocalHistoryError");
                    MessageDialog.openInformation((Shell)parentShell, (String)title, (String)msg);
                    return;
                }
                if (dialog == null) {
                    dialog = new AddFromHistoryDialog(parentShell, bundle);
                    dialog.setHelpContextId("org.eclipse.compare.add_from_history_dialog_context");
                }
                if (dialog.select(container, states) && (selected = dialog.getSelected()) != null && selected.length > 0) {
                    try {
                        this.updateWorkspace(bundle, parentShell, selected);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException x) {
                        String reason = x.getTargetException().getMessage();
                        MessageDialog.openError((Shell)parentShell, (String)title, (String)Utilities.getFormattedString(bundle, "replaceError", reason));
                    }
                }
            }
            ++n2;
        }
    }

    void createContainers(IResource resource) throws CoreException {
        IFolder parent;
        IContainer container = resource.getParent();
        if (container instanceof IFolder && (parent = (IFolder)container) != null && !parent.exists()) {
            this.createContainers((IResource)parent);
            parent.create(false, true, null);
        }
    }

    private void updateWorkspace(final ResourceBundle bundle, Shell shell, final AddFromHistoryDialog.HistoryInput[] selected) throws InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    try {
                        String taskName = Utilities.getString(bundle, "taskName");
                        pm.beginTask(taskName, selected.length);
                        AddFromHistoryDialog.HistoryInput[] historyInputArray = selected;
                        int n = selected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AddFromHistoryDialog.HistoryInput s = historyInputArray[n2];
                            IFile file = s.fFile;
                            IFileState fileState = s.fFileState;
                            AddFromHistoryAction.this.createContainers((IResource)file);
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)1);
                            try {
                                file.create(fileState.getContents(), false, (IProgressMonitor)subMonitor);
                            }
                            finally {
                                subMonitor.done();
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    pm.done();
                }
            }
        };
        ProgressMonitorDialog pmdialog = new ProgressMonitorDialog(shell);
        pmdialog.run(false, true, (IRunnableWithProgress)operation);
    }
}

