/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.datatools.connectivity.oda.OdaException;

public final class SPParameterPositionUtil {
    private int[] position;
    private SPElement[] spElements;
    private boolean containsReturnValue = false;
    private String identifierQuoteString;

    public SPParameterPositionUtil(String sqlTxt, String identifierQuoteString) throws OdaException {
        try {
            assert (sqlTxt != null);
            this.identifierQuoteString = identifierQuoteString;
            if (this.identifierQuoteString == null || this.identifierQuoteString.equals(" ")) {
                this.identifierQuoteString = "";
            } else if (this.identifierQuoteString.length() > 0) {
                sqlTxt = sqlTxt.replaceAll("\\Q" + this.identifierQuoteString + "\\E", "\"");
                this.identifierQuoteString = "\"";
            }
            int[] point = this.getPosition(sqlTxt);
            String paramTxt = this.getParameterDefinitionChars(sqlTxt, point);
            this.parseQueryText(paramTxt);
            this.parseProcedureName(sqlTxt, point);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void parseQueryText(String queryText) throws IOException {
        int i;
        StringReader reader = new StringReader(queryText);
        int nextPosition = 1;
        ArrayList<Integer> result = new ArrayList<Integer>();
        while ((i = reader.read()) != -1) {
            if (String.valueOf(i).equals(this.identifierQuoteString)) {
                this.readNextQuote(reader, i);
                continue;
            }
            if (i == 40) {
                if (!this.readNextBracket(reader)) continue;
                result.add(nextPosition);
                continue;
            }
            if (i == 44) {
                ++nextPosition;
                continue;
            }
            if (i != 63) continue;
            result.add(nextPosition);
        }
        this.position = new int[result.size()];
        int k = 0;
        while (k < result.size()) {
            this.position[k] = Integer.parseInt(result.get(k).toString());
            ++k;
        }
    }

    private void readNextQuote(StringReader reader, int quote) throws IOException {
        int i = -1;
        while ((i = reader.read()) != -1) {
            if (i == quote) break;
        }
    }

    private boolean readNextBracket(StringReader reader) throws IOException {
        int i = -1;
        boolean hasPlaceHolder = false;
        while ((i = reader.read()) != -1) {
            if (i == 63) {
                hasPlaceHolder = true;
                continue;
            }
            if (i == 41) break;
        }
        return hasPlaceHolder;
    }

    public int[] getParameterPositions() {
        return this.position == null ? new int[]{} : this.position;
    }

    public SPElement getProcedure() throws JDBCException {
        if (this.spElements != null && this.spElements.length > 0) {
            return this.spElements[this.spElements.length - 1];
        }
        throw new JDBCException("odajdbc.InvalidStoredPrecedure", 118);
    }

    public SPElement getSchema() {
        if (this.spElements != null && this.spElements.length >= 2) {
            return this.spElements[0];
        }
        return null;
    }

    public SPElement getPackage() {
        if (this.spElements != null && this.spElements.length > 2) {
            return this.spElements[1];
        }
        return null;
    }

    public boolean containsReturnValue() {
        return this.containsReturnValue;
    }

    private void parseProcedureName(String sqlTxt, int[] point) throws JDBCException {
        int start = sqlTxt.toLowerCase().indexOf("call");
        int end = point[0];
        if (point[0] == -1 && point[1] == -1) {
            end = sqlTxt.indexOf("}");
        }
        if (start == -1 || start + 4 >= end) {
            throw new JDBCException("odajdbc.InvalidStoredPrecedure", 118);
        }
        if (sqlTxt.substring(0, start).matches(".*\\Q?\\E[ \t]*\\Q=\\E.*")) {
            this.containsReturnValue = true;
        }
        String name = sqlTxt.substring(start + 4, end).trim();
        String idq = Pattern.quote(this.identifierQuoteString);
        String patternStr = "([^" + idq + "][^\\.]*|" + idq + ".*?" + idq + ")\\.{0,1}";
        Matcher matcher = Pattern.compile(patternStr).matcher(name);
        ArrayList<SPElement> elemList = new ArrayList<SPElement>();
        while (matcher.find()) {
            String elem = matcher.group(1);
            if (elem.startsWith(this.identifierQuoteString) && elem.endsWith(this.identifierQuoteString)) {
                elem = elem.substring(this.identifierQuoteString.length(), elem.length() - this.identifierQuoteString.length());
                elemList.add(new SPElement(elem, true));
                continue;
            }
            elemList.add(new SPElement(elem, false));
        }
        this.spElements = elemList.toArray(new SPElement[elemList.size()]);
    }

    private String getParameterDefinitionChars(String sqlTxt, int[] point) throws OdaException {
        int startPoint = point[0];
        int endPoint = point[1];
        if (startPoint == -1 && endPoint == -1) {
            return "";
        }
        if (startPoint >= endPoint || startPoint == -1) {
            throw new JDBCException("odajdbc.InvalidStoredPrecedure", 118);
        }
        return sqlTxt.substring(startPoint + 1, endPoint);
    }

    private int[] getPosition(String queryText) {
        char[] temp = queryText.toCharArray();
        int[] point = new int[]{-1, -1};
        boolean validBracket = true;
        int i = 0;
        while (i < temp.length) {
            if (validBracket && '(' == temp[i]) {
                point[0] = i;
                break;
            }
            if (this.identifierQuoteString.equals(String.valueOf(temp[i]))) {
                validBracket = !validBracket;
            }
            ++i;
        }
        validBracket = true;
        i = temp.length - 1;
        while (i >= 0) {
            if (validBracket && ')' == temp[i]) {
                point[1] = i;
                break;
            }
            if (this.identifierQuoteString.equals(String.valueOf(temp[i]))) {
                validBracket = !validBracket;
            }
            --i;
        }
        return point;
    }

    public static class SPElement {
        private String name;
        private boolean isIdentifierQuoted;

        public SPElement(String name, boolean isIdentifierQuoted) {
            this.name = name;
            this.isIdentifierQuoted = isIdentifierQuoted;
        }

        public String getName() {
            return this.name;
        }

        public boolean isIdentifierQuoted() {
            return this.isIdentifierQuoted;
        }
    }
}

