/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import org.eclipse.birt.data.engine.odaconsumer.DataTypeUtil;
import org.eclipse.birt.data.engine.odaconsumer.DriverManager;
import org.eclipse.birt.data.engine.odaconsumer.OdaconsumerTestCase;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.junit.Assert;

public class DriverManagerTest
extends OdaconsumerTestCase {
    public final void testGetInstance() {
        Assert.assertNotNull((Object)DriverManager.getInstance());
    }

    public final void testGetDriver() throws Exception {
        IDriver driverHelper = DriverManager.getInstance().getDriverHelper("org.eclipse.birt.report.data.oda.jdbc");
        Assert.assertNotNull((Object)driverHelper);
    }

    public final void testGetExtensionDataSourceType() throws Exception {
        String dataSourceType = DriverManager.getInstance().getExtensionDataSourceId("org.eclipse.birt.report.data.oda.jdbc");
        Assert.assertEquals((Object)"org.eclipse.birt.report.data.oda.jdbc", (Object)dataSourceType);
    }

    public final void testGetNativeToOdaMapping() throws Exception {
        this.testConversion(-5, 3);
        this.testConversion(-2, 2004);
        this.testConversion(-7, 4);
        this.testConversion(16, 16);
        this.testConversion(1, 1);
        this.testConversion(91, 91);
        this.testConversion(3, 3);
        this.testConversion(8, 8);
        this.testConversion(6, 8);
        this.testConversion(4, 4);
        this.testConversion(-4, 2004);
        this.testConversion(-1, 1);
        this.testConversion(2, 3);
        this.testConversion(7, 8);
        this.testConversion(5, 4);
        this.testConversion(92, 92);
        this.testConversion(93, 93);
        this.testConversion(-6, 4);
        this.testConversion(-3, 2004);
        this.testConversion(12, 1);
    }

    private void testConversion(int nativeType, int expectedOdaType) throws Exception {
        Assert.assertEquals((long)expectedOdaType, (long)DataTypeUtil.toOdaType((int)nativeType, (String)"org.eclipse.birt.report.data.oda.jdbc", (String)"org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet"));
    }
}

