/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.regression.Title;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class Regression_78699_swt
extends Composite
implements PaintListener,
IUpdateNotifier,
SelectionListener {
    private IDeviceRenderer idr = null;
    private Chart cm = null;
    private static Combo cbType = null;
    private static Button btn = null;
    private GeneratedChartState gcs = null;
    private boolean bNeedsGeneration = true;
    private Map contextMap = new HashMap();

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setSize(600, 400);
        shell.setLayout((Layout)new GridLayout());
        Regression_78699_swt siv = new Regression_78699_swt((Composite)shell, 262144);
        siv.setLayoutData(new GridData(1808));
        siv.addPaintListener(siv);
        Composite cBottom = new Composite((Composite)shell, 0);
        cBottom.setLayoutData((Object)new GridData(768));
        cBottom.setLayout((Layout)new RowLayout());
        Label la = new Label(cBottom, 0);
        la.setText("Choose: ");
        cbType = new Combo(cBottom, 12);
        cbType.add("Bar Chart");
        cbType.select(0);
        btn = new Button(cBottom, 0);
        btn.setText("Update");
        btn.addSelectionListener((SelectionListener)siv);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    Regression_78699_swt(Composite parent, int style) {
        super(parent, style);
        PluginSettings ps = PluginSettings.instance();
        try {
            this.idr = ps.getDevice("dv.SWT");
            this.idr.setProperty("device.component", (Object)this);
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = this.createChart();
        this.bindGroupingData(this.cm);
    }

    public void paintControl(PaintEvent e) {
        Rectangle d = this.getClientArea();
        Image imgChart = new Image((Device)this.getDisplay(), d);
        GC gcImage = new GC((Drawable)imgChart);
        this.idr.setProperty("device.output.context", (Object)gcImage);
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)d.width, (double)d.height);
        bo.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        if (this.bNeedsGeneration) {
            this.bNeedsGeneration = false;
            try {
                this.gcs = gr.build(this.idr.getDisplayServer(), this.cm, bo, null, null, null);
            }
            catch (ChartException ce) {
                ce.printStackTrace();
            }
        }
        try {
            gr.render(this.idr, this.gcs);
            GC gc = e.gc;
            gc.drawImage(imgChart, d.x, d.y);
        }
        catch (ChartException ce) {
            ce.printStackTrace();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.equals(btn)) {
            int iSelection = cbType.getSelectionIndex();
            switch (iSelection) {
                case 0: {
                    this.cm = Title.BarChart();
                }
            }
            this.bNeedsGeneration = true;
            this.redraw();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.gcs.getChartModel();
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
        this.bNeedsGeneration = true;
        this.redraw();
    }

    public void repaintChart() {
        this.redraw();
    }

    public Object getContext(Object key) {
        return this.contextMap.get(key);
    }

    public Object putContext(Object key, Object value) {
        return this.contextMap.put(key, value);
    }

    public Object removeContext(Object key) {
        return this.contextMap.remove(key);
    }

    private void bindGroupingData(Chart chart) {
        final Object[][] data = new Object[][]{{"x1", new Integer(1), "g1"}, {"x2", new Integer(2), "g2"}, {"x3", new Integer(3), "g1"}, {"x4", new Integer(4), "g3"}, {"x5", new Integer(5), "g2"}, {"x6", new Integer(6), "g1"}, {"x7", new Integer(7), "g3"}, {"x8", new Integer(8), "g2"}, {"x9", new Integer(9), "g2"}, {"x0", new Integer(0), "g2"}};
        try {
            Generator gr = Generator.instance();
            gr.bindData(new IDataRowExpressionEvaluator(){
                int idx = 0;

                public void close() {
                }

                public Object evaluate(String expression) {
                    if ("X".equals(expression)) {
                        return data[this.idx][0];
                    }
                    if ("Y".equals(expression)) {
                        return data[this.idx][1];
                    }
                    if ("G".equals(expression)) {
                        return data[this.idx][2];
                    }
                    return null;
                }

                public Object evaluateGlobal(String expression) {
                    return this.evaluate(expression);
                }

                public boolean first() {
                    this.idx = 0;
                    return true;
                }

                public boolean next() {
                    ++this.idx;
                    return this.idx < 9;
                }
            }, chart, new RunTimeContext());
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    private Chart createChart() {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        Axis xAxisPrimary = cwaBar.getPrimaryBaseAxes()[0];
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        Axis yAxisPrimary = cwaBar.getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        Series seCategory = SeriesImpl.create();
        Query xQ = QueryImpl.create((String)"G");
        seCategory.getDataDefinition().add((Object)xQ);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seCategory);
        sdX.setSorting(SortOption.DESCENDING_LITERAL);
        sdX.getGrouping().setEnabled(true);
        sdX.getGrouping().setGroupType(DataType.TEXT_LITERAL);
        sdX.getGrouping().setAggregateExpression("Sum");
        sdX.getGrouping().setGroupingInterval(0.0);
        LineSeries bs = (LineSeries)LineSeriesImpl.create();
        bs.getLabel().setVisible(false);
        Query yQ = QueryImpl.create((String)"Y");
        bs.getDataDefinition().add((Object)yQ);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update(0);
        sdY.getSeries().add((Object)bs);
        return cwaBar;
    }
}

