/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.attribute.impl.GradientImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class Regression_123554
extends ChartTestCase {
    private static String GOLDEN = "Reg_123554.jpg";
    private static String OUTPUT = "Reg_123554.jpg";
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new Regression_123554();
    }

    public Regression_123554() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_123554.createScatterChart();
        BufferedImage img = new BufferedImage(500, 500, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)500.0, (double)500.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public void test_regression_123554() throws Exception {
        Regression_123554 st = new Regression_123554();
        Regression_123554.assertTrue((boolean)st.compareImages(GOLDEN, OUTPUT));
    }

    public static final Chart createScatterChart() {
        ChartWithAxes cwaScatter = ChartWithAxesImpl.create();
        cwaScatter.setType("Scatter Chart");
        cwaScatter.getTitle().getLabel().getCaption().setValue("Sample Scatter Chart");
        cwaScatter.getBlock().setBackground((Fill)ColorDefinitionImpl.GREY());
        Plot p = cwaScatter.getPlot();
        p.getOutline().setStyle(LineStyle.DASH_DOTTED_LITERAL);
        p.getOutline().setColor(ColorDefinitionImpl.create((int)214, (int)100, (int)12));
        p.getOutline().setVisible(true);
        p.setBackground((Fill)ColorDefinitionImpl.CREAM());
        p.setAnchor(Anchor.NORTH_LITERAL);
        p.getClientArea().getOutline().setVisible(true);
        Legend lg = cwaScatter.getLegend();
        lg.getText().getFont().setSize(16.0f);
        lg.getInsets().set(10.0, 5.0, 0.0, 0.0);
        lg.getOutline().setStyle(LineStyle.DOTTED_LITERAL);
        lg.getOutline().setColor(ColorDefinitionImpl.create((int)214, (int)100, (int)12));
        lg.getOutline().setVisible(true);
        lg.setBackground((Fill)GradientImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)225, (int)225, (int)255), (ColorDefinition)ColorDefinitionImpl.create((int)255, (int)255, (int)225), (double)-35.0, (boolean)false));
        lg.setAnchor(Anchor.SOUTH_LITERAL);
        lg.setItemType(LegendItemType.CATEGORIES_LITERAL);
        lg.getClientArea().setBackground((Fill)ColorDefinitionImpl.ORANGE());
        lg.setPosition(Position.BELOW_LITERAL);
        lg.setOrientation(Orientation.HORIZONTAL_LITERAL);
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaScatter).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.BLACK().darker());
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaScatter).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getLabel().getCaption().setValue("");
        yAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE());
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{22.49, 163.55, -65.43, 0.0, -107.0});
        NumberDataSet dsNumericValues2 = NumberDataSetImpl.create((Object)new double[]{-36.53, 43.9, 8.29, 97.45, 32.0});
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsNumericValues1);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.getSeriesPalette().update(3);
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        ScatterSeries ss = (ScatterSeries)ScatterSeriesImpl.create();
        DataPoint dp = ss.getDataPoint();
        dp.getComponents().clear();
        dp.setPrefix("(");
        dp.setSuffix(")");
        dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.BASE_VALUE_LITERAL, (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0.00")));
        dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.ORTHOGONAL_VALUE_LITERAL, (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0.00")));
        ss.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        ss.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        ss.getLabel().setVisible(true);
        ss.setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)117, (int)137, (int)223), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        ss.setShadowColor(ColorDefinitionImpl.create((int)30, (int)55, (int)90));
        ss.setDataSet((DataSet)dsNumericValues2);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update((Fill)ColorDefinitionImpl.GREEN());
        sdY.getSeries().add((Object)ss);
        return cwaScatter;
    }
}

