/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.birt.core.data.IDimLevel;
import org.eclipse.birt.core.data.OlapExpressionCompiler;
import org.eclipse.birt.core.exception.CoreException;
import org.junit.Test;

public class OlapExpressionCompilerTest
extends TestCase {
    @Test
    public void testGetDimLevels() throws CoreException {
        OlapExpressionCompilerTest.assertEquals((String)"dim1/level1", (String)this.getDimLevels("dimension['dim1']['level1']"));
        OlapExpressionCompilerTest.assertEquals((String)"dim1/level1/attr1", (String)this.getDimLevels("dimension['dim1']['level1']['attr1']"));
        OlapExpressionCompilerTest.assertEquals((String)"dim1/level1,dim2/level2", (String)this.getDimLevels("dimension['dim1']['level1'] * dimension['dim2']['level2']"));
        OlapExpressionCompilerTest.assertEquals((String)"dim1/level1", (String)this.getDimLevels("func(dimension['dim1']['level1'])"));
    }

    @Test
    public void testGetReferencedMeasures() {
        OlapExpressionCompilerTest.assertEquals((String)"m1", (String)this.getMeasureNames("measure.m1"));
        OlapExpressionCompilerTest.assertEquals((String)"m1", (String)this.getMeasureNames("measure[\"m1\"]"));
        OlapExpressionCompilerTest.assertEquals((String)"m1", (String)this.getMeasureNames("measure['m1']"));
        OlapExpressionCompilerTest.assertEquals((String)"m1,m2", (String)this.getMeasureNames("measure[\"m1\"] + measure[\"m2\"]"));
        OlapExpressionCompilerTest.assertEquals((String)"m1,m2", (String)this.getMeasureNames("measure[\"m1\"] + measure[\"m2\"] //measure[\"m3\"] "));
        OlapExpressionCompilerTest.assertEquals((String)"m1", (String)this.getMeasureNames("global.test(measure[\"m1\"]) "));
    }

    private String getDimLevels(String expr) throws CoreException {
        Set levels = OlapExpressionCompiler.getReferencedDimLevel((String)expr);
        return this.toString(levels);
    }

    private String getMeasureNames(String expr) {
        Set measures = OlapExpressionCompiler.getReferencedMeasure((String)expr);
        return this.toString(measures);
    }

    private String toString(Collection<String> values) {
        StringBuilder sb = new StringBuilder();
        if (values.size() > 0) {
            Object[] lines = values.toArray(new String[values.size()]);
            Arrays.sort(lines);
            Object[] objectArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                Object line = objectArray[n2];
                sb.append((String)line);
                sb.append(",");
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private String toString(IDimLevel dim) {
        StringBuilder sb = new StringBuilder();
        sb.append(dim.getDimensionName());
        if (dim.getLevelName() != null) {
            sb.append("/");
            sb.append(dim.getLevelName());
        }
        if (dim.getAttrName() != null) {
            sb.append("/");
            sb.append(dim.getAttrName());
        }
        return sb.toString();
    }

    private String toString(Set<IDimLevel> dims) {
        ArrayList<String> lines = new ArrayList<String>();
        for (IDimLevel dim : dims) {
            lines.add(this.toString(dim));
        }
        return this.toString(lines);
    }
}

