/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.FolderArchive;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SpecialCharacterTest
extends TestCase {
    public void doTest(IDocArchiveWriter writer, IDocArchiveReader reader) throws IOException {
        String fileName;
        String[] fileNames;
        String[] stringArray = fileNames = new String[]{"d:/abc.txt", "../abc/txt", "./txt", "...txt", "....txt", ".//.txt", "%25.txt", ":.txt", "::", "\\\\.txt", "\\.txt"};
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            fileName = stringArray[n2];
            RAOutputStream ws = writer.createRandomAccessStream(fileName);
            ws.write(fileName.getBytes("utf-8"));
            ws.close();
            ++n2;
        }
        stringArray = fileNames;
        n = fileNames.length;
        n2 = 0;
        while (n2 < n) {
            fileName = stringArray[n2];
            RAInputStream rs = reader.getInputStream(fileName);
            byte[] b = new byte[rs.available()];
            rs.read(b);
            SpecialCharacterTest.assertEquals((String)new String(b, "utf-8"), (String)fileName);
            ++n2;
        }
    }

    @Before
    @After
    public void removeDirectory() {
        ArchiveUtil.deleteAllFiles((File)new File("./utest"));
    }

    @Test
    public void testFolderReaderWriter() throws IOException {
        FolderArchiveWriter writer = new FolderArchiveWriter("./utest/folder.rw");
        FolderArchiveReader reader = new FolderArchiveReader("./utest/folder.rw");
        try {
            this.doTest((IDocArchiveWriter)writer, (IDocArchiveReader)reader);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    @Test
    public void testFolderArchive() throws IOException {
        try (FolderArchive archive = new FolderArchive("./utest/folder.archive");){
            this.doTest((IDocArchiveWriter)archive, (IDocArchiveReader)archive);
        }
    }

    @Test
    public void testFileArchive() throws IOException {
        ArchiveFile af = new ArchiveFile("./utest/archive.test", "rwt");
        ArchiveReader reader = new ArchiveReader((IArchiveFile)af);
        ArchiveWriter writer = new ArchiveWriter((IArchiveFile)af);
        try {
            this.doTest((IDocArchiveWriter)writer, (IDocArchiveReader)reader);
        }
        finally {
            af.close();
        }
    }
}

