/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFont;
import org.eclipse.birt.report.engine.layout.pdf.font.FontConfigReader;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingConfig;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManagerFactory;
import org.xml.sax.SAXException;

public class FontConfigReaderTest
extends TestCase {
    private FontMappingManager fontMappingManager = null;

    public void testFontMappingHandler() throws IOException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        this.fontMappingManager = this.getFontMappingManager("fontsConfig3.xml", Locale.CHINA);
        FontConfigReaderTest.assertEquals((String)"Courier", (String)this.fontMappingManager.getAliasedFont("serif"));
        FontConfigReaderTest.assertEquals((int)16, (int)this.fontMappingManager.getFontEncodings().size());
        FontConfigReaderTest.assertEquals((int)2, (int)this.fontMappingManager.getSearchSequences().size());
        CompositeFont cf = this.fontMappingManager.getCompositeFont("all-fonts");
        FontConfigReaderTest.assertTrue((cf != null ? 1 : 0) != 0);
        FontConfigReaderTest.assertEquals((String)"Zapfdingbats", (String)cf.getUsedFont('a'));
        FontConfigReaderTest.assertEquals((String)"STSong-Light", (String)cf.getUsedFont('\u624b'));
        FontConfigReaderTest.assertEquals((String)"Times-Roman", (String)cf.getUsedFont('b'));
        this.fontMappingManager = this.getFontMappingManager("fontsConfig3.xml", Locale.JAPANESE);
        FontConfigReaderTest.assertEquals((String)"Courier", (String)this.fontMappingManager.getAliasedFont("serif"));
        FontConfigReaderTest.assertEquals((int)16, (int)this.fontMappingManager.getFontEncodings().size());
        cf = this.fontMappingManager.getCompositeFont("all-fonts");
        FontConfigReaderTest.assertTrue((cf != null ? 1 : 0) != 0);
        FontConfigReaderTest.assertEquals((String)"Zapfdingbats", (String)cf.getUsedFont('a'));
        FontConfigReaderTest.assertEquals((String)"HeiseiMin-W3", (String)cf.getUsedFont('\u624b'));
        FontConfigReaderTest.assertEquals((String)"Times-Roman", (String)cf.getUsedFont('b'));
    }

    public void testFontMapWhenAllFontsNotDefined() throws IOException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        this.fontMappingManager = this.getFontMappingManager("fontsConfig2.xml");
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('1', "alias1", "Courier"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('\u0e81', "alias1", "Courier"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('\u0080', "alias1", "Times Roman"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('1', "alias2", "Helvetica"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('1', "Alias2", "Helvetica"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('1', "Symbol", "Courier"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('\u0e81', "Symbol", "Courier"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('\u0080', "Symbol", "Times Roman"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('1', "Helvetica", "Helvetica"));
    }

    public void testFontMapWhenAllFontsDefined() throws IOException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        this.fontMappingManager = this.getFontMappingManager("fontsConfig1.xml");
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('1', "alias1", "Courier"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('1', "alias2", "Helvetica"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('1', "Symbol", "Courier"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('1', "Helvetica", "Helvetica"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('\u0e81', "Symbol", "Courier"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('\uff01', "Symbol", "Times Roman"));
    }

    public void testCompatibleParser() throws IOException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        this.fontMappingManager = this.getFontMappingManager("fontsConfigCompatible.xml");
        Map fontAliases = this.fontMappingManager.getFontAliases();
        FontConfigReaderTest.assertEquals((int)2, (int)fontAliases.size());
        FontConfigReaderTest.assertEquals((Object)"font alias in font-aliases", fontAliases.get("font alias overridden"));
        FontConfigReaderTest.assertEquals((Object)"font alias in font-mappings", fontAliases.get("font alias not overridden"));
        Map compositeFonts = this.fontMappingManager.getCompositeFonts();
        FontConfigReaderTest.assertEquals((int)3, (int)compositeFonts.size());
        CompositeFont overriddenFont = this.fontMappingManager.getCompositeFont("font overridden");
        FontConfigReaderTest.assertEquals((String)"font in composite-font", (String)overriddenFont.getUsedFont('\u0000'));
        FontConfigReaderTest.assertEquals((String)"font in composite-font", (String)overriddenFont.getUsedFont('\u007f'));
        CompositeFont notOverriddenFont = this.fontMappingManager.getCompositeFont("font not overridden");
        FontConfigReaderTest.assertEquals((String)"font in all-fonts", (String)notOverriddenFont.getUsedFont('\u0000'));
        FontConfigReaderTest.assertEquals((String)"font in all-fonts", (String)notOverriddenFont.getUsedFont('\u007f'));
        CompositeFont allFonts = this.fontMappingManager.getCompositeFont("all-fonts");
        FontConfigReaderTest.assertEquals((String)"Times-Roman", (String)allFonts.getUsedFont('\u0000'));
        FontConfigReaderTest.assertEquals((String)"Times-Roman", (String)allFonts.getUsedFont('\u007f'));
        FontConfigReaderTest.assertEquals((String)"Helvetica", (String)allFonts.getUsedFont('\u0080'));
        FontConfigReaderTest.assertEquals((String)"Helvetica", (String)allFonts.getUsedFont('\u00ff'));
        FontConfigReaderTest.assertEquals(null, (String)allFonts.getDefaultFont());
    }

    public void testFontConfigParser() throws IOException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        this.fontMappingManager = this.getFontMappingManager("fontsConfigParser.xml");
        Map fontAliases = this.fontMappingManager.getFontAliases();
        FontConfigReaderTest.assertEquals((int)1, (int)fontAliases.size());
        FontConfigReaderTest.assertEquals((Object)"Times-Roman", fontAliases.get("test alias"));
        Map compositeFonts = this.fontMappingManager.getCompositeFonts();
        FontConfigReaderTest.assertEquals((int)1, (int)compositeFonts.size());
        CompositeFont testFont = (CompositeFont)compositeFonts.get("test font");
        FontConfigReaderTest.assertEquals((String)"Symbol", (String)testFont.getUsedFont('\u0000'));
        FontConfigReaderTest.assertEquals((String)"Symbol", (String)testFont.getUsedFont('\u007f'));
        FontConfigReaderTest.assertEquals((String)"Helvetica", (String)testFont.getDefaultFont());
    }

    public void testCharacterFontMapping() throws IOException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        this.fontMappingManager = this.getFontMappingManager("fontsConfig_character.xml");
        String testFontForCharacterMapping = "testForCharacterMapping";
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('a', testFontForCharacterMapping, "Helvetica"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('b', testFontForCharacterMapping, "Times Roman"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('c', testFontForCharacterMapping, "Courier"));
        FontConfigReaderTest.assertTrue((boolean)this.isMappedTo('a', "testForDefaultFont", "Symbol"));
    }

    private void testPriority(final String testDir, String format) {
        FontMappingManagerFactory factory = new FontMappingManagerFactory(){

            protected URL getConfigURL(String configName) {
                URL fileURL = ((Object)((Object)this)).getClass().getResource("/org/eclipse/birt/report/engine/layout/pdf/font/" + testDir + "/" + configName + ".xml");
                return fileURL;
            }
        };
        FontMappingManager manager = factory.getFontMappingManager(format, Locale.CHINESE);
        this.testMergedProperty(manager.getFontAliases(), 8);
        this.testMergedProperty(manager.getFontEncodings(), 9);
        Map compositeFonts = manager.getCompositeFonts();
        FontConfigReaderTest.assertEquals((int)3, (int)compositeFonts.size());
        CompositeFont compositeFont = manager.getCompositeFont("common");
        FontConfigReaderTest.assertEquals((String)"Courier", (String)compositeFont.getUsedFont('\u0000'));
        FontConfigReaderTest.assertEquals((String)"Courier", (String)compositeFont.getUsedFont('\u0e80'));
        compositeFont = manager.getCompositeFont("higher priority");
        FontConfigReaderTest.assertEquals((String)"Courier", (String)compositeFont.getUsedFont('\u0000'));
        compositeFont = manager.getCompositeFont("lower priority");
        FontConfigReaderTest.assertEquals((String)"Courier", (String)compositeFont.getUsedFont('\u0000'));
    }

    private void testMergedProperty(Map map, int size) {
        FontConfigReaderTest.assertEquals((int)size, (int)map.size());
        FontConfigReaderTest.assertEquals((Object)"higher priority", map.get("common"));
        FontConfigReaderTest.assertEquals((Object)"higher priority", map.get("higher priority"));
        FontConfigReaderTest.assertEquals((Object)"lower priority", map.get("lower priority"));
    }

    private boolean isMappedTo(char c, String from, String to) {
        FontHandler handler = new FontHandler(this.fontMappingManager, new String[]{from}, 0, true);
        BaseFont font = handler.getMappedFont(c);
        return this.hasName(font, to);
    }

    private boolean hasName(BaseFont font, String fontName) {
        String[][] familyFontNames = font.getFullFontName();
        int i = 0;
        while (i < familyFontNames.length) {
            int j = 0;
            while (j < familyFontNames[i].length) {
                if (fontName.equals(familyFontNames[i][j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private FontMappingManager getFontMappingManager(String configFile) throws IOException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        return this.getFontMappingManager(configFile, Locale.CHINA);
    }

    private FontMappingManager getFontMappingManager(String configFile, Locale locale) throws IOException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        URL url = this.getURL(configFile);
        long start = System.currentTimeMillis();
        FontMappingConfig config = new FontConfigReader().parseConfig(url);
        long end = System.currentTimeMillis();
        System.out.println("load font config in " + String.valueOf(url) + " cost " + (end - start) + "ms");
        return FontMappingManagerFactory.getInstance().createFontMappingManager(config, locale);
    }

    private URL getURL(String configFile) {
        URL fileURL = ((Object)((Object)this)).getClass().getResource("/org/eclipse/birt/report/engine/layout/pdf/font/" + configFile);
        return fileURL;
    }
}

