/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.IOException;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.internal.document.OffsetIndexReader;
import org.eclipse.birt.report.engine.internal.document.OffsetIndexWriter;

public class OffsetIndexReaderWriterTest
extends EngineCase {
    static final String INDEX_STREAM = "org.eclipse.birt.report.engine.OffsetIndexReaderWriterTest.index";

    public void setUp() {
        this.removeFile(INDEX_STREAM);
    }

    public void tearDown() {
        this.removeFile(INDEX_STREAM);
    }

    public void testReadWrite() {
        try {
            this.doCreateIndex();
            this.doReadIndex();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            OffsetIndexReaderWriterTest.fail();
        }
    }

    protected void doCreateIndex() throws IOException {
        OffsetIndexWriter writer = new OffsetIndexWriter(INDEX_STREAM);
        writer.open();
        writer.write(0L, 0L);
        writer.write(10L, 10L);
        writer.write(20L, 20L);
        writer.write(30L, 30L);
        writer.write(40L, 40L);
        writer.close();
    }

    protected void doReadIndex() throws IOException {
        OffsetIndexReader reader = new OffsetIndexReader(INDEX_STREAM);
        reader.open();
        OffsetIndexReaderWriterTest.assertEquals((long)-1L, (long)reader.find(-1L));
        OffsetIndexReaderWriterTest.assertEquals((long)0L, (long)reader.find(0L));
        OffsetIndexReaderWriterTest.assertEquals((long)10L, (long)reader.find(10L));
        OffsetIndexReaderWriterTest.assertEquals((long)20L, (long)reader.find(20L));
        OffsetIndexReaderWriterTest.assertEquals((long)30L, (long)reader.find(30L));
        OffsetIndexReaderWriterTest.assertEquals((long)40L, (long)reader.find(40L));
        OffsetIndexReaderWriterTest.assertEquals((long)-1L, (long)reader.find(90L));
        reader.close();
    }
}

