/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.script;

import java.io.File;
import java.util.HashMap;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.impl.RunTask;
import org.eclipse.birt.report.engine.api.script.IReportContext;

public class PageScriptHandlerTest
extends EngineCase {
    static final String PAGE_SCRIPT_HANDLER = "org/eclipse/birt/report/engine/api/script/PageScriptTest.xml";
    static final String PAGE_SCRIPT_JAR = "org/eclipse/birt/report/engine/api/script/script.jar";
    static final String REPORT_DESIGN = "design.rptdesign";
    static final String JAR = "script.jar";
    static final String REPORT_DOCUMENT = "./reportdocument.folder/";
    static final String SCRIPT_CANCEL = "org/eclipse/birt/report/engine/api/ScriptCancel.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public IReportEngine createReportEngine() {
        EngineConfig config = new EngineConfig();
        HashMap<String, String> map = new HashMap<String, String>();
        File jar = new File(JAR);
        map.put("user.projectclasspath", jar.getAbsolutePath());
        config.setAppContext(map);
        Object factory = Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        if (factory instanceof IReportEngineFactory) {
            return ((IReportEngineFactory)factory).createReportEngine(config);
        }
        return null;
    }

    public void testScriptCancel() throws Exception {
        this.copyResource(PAGE_SCRIPT_HANDLER, REPORT_DESIGN);
        this.copyResource(PAGE_SCRIPT_JAR, JAR);
        this.removeFile(REPORT_DOCUMENT);
        IReportRunnable runnable = this.engine.openReportDesign(REPORT_DESIGN);
        IRunTask runTask = this.engine.createRunTask(runnable);
        runTask.run(REPORT_DOCUMENT);
        IReportContext reportContext = ((RunTask)runTask).getReportContext();
        PageScriptHandlerTest.assertTrue((boolean)this.convertToBoolean(reportContext.getGlobalVariable("REPORT_ONPAGESTART")));
        PageScriptHandlerTest.assertTrue((boolean)this.convertToBoolean(reportContext.getGlobalVariable("REPORT_ONPAGEEND")));
        PageScriptHandlerTest.assertTrue((boolean)this.convertToBoolean(reportContext.getGlobalVariable("MASTERPAGE_ONPAGESTART")));
        PageScriptHandlerTest.assertTrue((boolean)this.convertToBoolean(reportContext.getGlobalVariable("MASTERPAGE_ONPAGEEND")));
        runTask.close();
        this.removeFile(REPORT_DESIGN);
        this.removeFile(JAR);
        this.removeFile(REPORT_DOCUMENT);
    }

    protected boolean convertToBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }
}

