/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.regre;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import testutil.ConfigText;

public class DataSourceTest
extends APITestCase {
    private DataEngine myDataEngine;

    public DataSourceTest() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(DataSourceTest.getTempDir());
        this.myDataEngine = DataEngine.newDataEngine((DataEngineContext)context);
    }

    @After
    public void tearDown() throws Exception {
        this.myDataEngine.shutdown();
    }

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestDataCalls.TableName"), ConfigText.getString("Api.TestDataCalls.TableSQL"), ConfigText.getString("Api.TestDataCalls.TestDataFileName"));
    }

    @Test
    public void testDefineDataSource() throws BirtException {
        IResultIterator it;
        IQueryResults queryResults;
        IPreparedQuery preparedQuery;
        ScriptExpression expr = new ScriptExpression("dataSetRow.NUM");
        IQueryDefinition queryDefn = this.getScriptQueryDefn(expr);
        try {
            preparedQuery = this.myDataEngine.prepare(queryDefn);
            queryResults = preparedQuery.execute(null);
            it = queryResults.getResultIterator();
            it.close();
            queryResults.close();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        expr = new ScriptExpression("dataSetRow.CUSTOMERID");
        queryDefn = this.getJDBCQueryDefn(expr);
        try {
            preparedQuery = this.myDataEngine.prepare(queryDefn);
            queryResults = preparedQuery.execute(null);
            it = queryResults.getResultIterator();
            it.close();
            queryResults.close();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private IQueryDefinition getJDBCQueryDefn(ScriptExpression expr) throws BirtException {
        QueryDefinition queryDefn = new QueryDefinition();
        queryDefn.setDataSetName(this.dataSet.getName());
        queryDefn.addResultSetExpression("NAME_1", (IBaseExpression)expr);
        this.myDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSourceInstance.getOdaDataSourceDesign());
        this.myDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSourceInstance.getOdaDataSetDesign());
        return queryDefn;
    }

    private IQueryDefinition getScriptQueryDefn(ScriptExpression expr) throws BirtException {
        ScriptDataSourceDesign scriptDatasource = new ScriptDataSourceDesign(this.dataSourceInstance.getOdaDataSourceDesign().getName());
        ScriptDataSetDesign scriptDataSet = new ScriptDataSetDesign(this.dataSourceInstance.getOdaDataSetDesign().getName());
        scriptDataSet.setDataSource(scriptDatasource.getName());
        scriptDataSet.setOpenScript("count=11; dset_open=true; count--;");
        scriptDataSet.setFetchScript("if (count==0) {return false; } else { dataSetRow.NUM=count; --count; return true; }");
        ColumnDefinition col = new ColumnDefinition("NUM");
        col.setDataType(2);
        scriptDataSet.getResultSetHints().add(col);
        QueryDefinition queryDefn = new QueryDefinition();
        queryDefn.setDataSetName(scriptDataSet.getName());
        queryDefn.addResultSetExpression("NAME_2", (IBaseExpression)expr);
        this.myDataEngine.defineDataSource((IBaseDataSourceDesign)scriptDatasource);
        this.myDataEngine.defineDataSet((IBaseDataSetDesign)scriptDataSet);
        return queryDefn;
    }
}

