/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.birt.data.engine.olap.data.document.BlockRandomAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.BufferedRandomDataAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObjectAllocatedTable;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.IObjectAllocTable;
import org.eclipse.birt.data.engine.olap.data.document.IRandomAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.SimpleRandomAccessObject;
import org.eclipse.birt.data.engine.olap.data.util.BufferedRandomAccessFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BufferedRandomAccessObjectTest {
    private static final String tmpPath = System.getProperty("java.io.tmpdir");
    IDocumentManager documentManager = null;

    @Before
    public void bufferedRandomAccessObjectSetUp() throws Exception {
        this.documentManager = DocumentManagerFactory.createFileDocumentManager();
    }

    @After
    public void bufferedRandomAccessObjectTearDown() throws Exception {
        this.documentManager.close();
    }

    @Test
    public void testInteger() throws IOException {
        int objectNumber = 1001;
        Assert.assertTrue((this.documentManager.createDocumentObject("testInteger") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = this.documentManager.openDocumentObject("testInteger");
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeInt(i);
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((long)documentObject.readInt(), (long)i);
            ++i;
        }
        documentObject.seek(400L);
        Assert.assertEquals((long)documentObject.readInt(), (long)100L);
        documentObject.seek(804L);
        Assert.assertEquals((long)documentObject.readInt(), (long)201L);
        Assert.assertEquals((long)documentObject.readInt(), (long)202L);
        documentObject.seek(2804L);
        documentObject.writeInt(1000001);
        Assert.assertEquals((long)documentObject.readInt(), (long)702L);
        documentObject.seek(2804L);
        Assert.assertEquals((long)documentObject.readInt(), (long)1000001L);
        documentObject.close();
    }

    @Test
    public void testInteger1() throws IOException {
        int objectNumber = 1001;
        BufferedRandomDataAccessObject documentObject = new BufferedRandomDataAccessObject((IRandomAccessObject)new SimpleRandomAccessObject(new File(tmpPath + File.separatorChar + "testInteger1"), "rw"), 1024);
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeInt(i);
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((long)documentObject.readInt(), (long)i);
            ++i;
        }
        documentObject.seek(400L);
        Assert.assertEquals((long)documentObject.readInt(), (long)100L);
        documentObject.seek(804L);
        Assert.assertEquals((long)documentObject.readInt(), (long)201L);
        Assert.assertEquals((long)documentObject.readInt(), (long)202L);
        documentObject.seek(2804L);
        documentObject.writeInt(1000001);
        Assert.assertEquals((long)documentObject.readInt(), (long)702L);
        documentObject.seek(2804L);
        Assert.assertEquals((long)documentObject.readInt(), (long)1000001L);
        documentObject.close();
    }

    @Test
    public void testLong() throws IOException {
        int objectNumber = 1001;
        BufferedRandomDataAccessObject documentObject = new BufferedRandomDataAccessObject((IRandomAccessObject)new SimpleRandomAccessObject(new File(tmpPath + File.separatorChar + "testInteger1"), "rw"), 1024);
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeLong((long)i);
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((long)documentObject.readLong(), (long)i);
            ++i;
        }
        documentObject.seek(800L);
        Assert.assertEquals((long)documentObject.readLong(), (long)100L);
        documentObject.seek(1608L);
        Assert.assertEquals((long)documentObject.readLong(), (long)201L);
        Assert.assertEquals((long)documentObject.readLong(), (long)202L);
        documentObject.seek(5608L);
        documentObject.writeLong(1000001L);
        Assert.assertEquals((long)documentObject.readLong(), (long)702L);
        documentObject.seek(5608L);
        Assert.assertEquals((long)documentObject.readLong(), (long)1000001L);
        documentObject.close();
    }

    @Test
    public void testInteger2() throws IOException {
        BlockRandomAccessObject documentObject = new BlockRandomAccessObject(new BufferedRandomAccessFile(new File(tmpPath + File.separatorChar + "testInteger1"), "rw", 1024), "testInteger2", 0, 0L, (IObjectAllocTable)new DocumentObjectAllocatedTable());
        byte[] bytes = new byte[1024];
        bytes[0] = 1;
        bytes[1] = 2;
        documentObject.seek(0L);
        documentObject.write(bytes, 0, bytes.length);
        documentObject.write(bytes, 0, bytes.length);
        documentObject.write(bytes, 0, bytes.length);
        bytes = new byte[932];
        documentObject.write(bytes, 0, bytes.length);
        bytes = new byte[1024];
        documentObject.seek(0L);
        Assert.assertEquals((long)documentObject.read(bytes, 0, bytes.length), (long)1024L);
        Assert.assertEquals((long)bytes[0], (long)1L);
        Assert.assertEquals((long)bytes[1], (long)2L);
        documentObject.close();
    }

    @Test
    public void testInteger3() throws IOException {
        BlockRandomAccessObject documentObject = new BlockRandomAccessObject(new BufferedRandomAccessFile(new File(tmpPath + File.separatorChar + "testInteger1"), "rw", 1024), "testInteger2", 0, 0L, (IObjectAllocTable)new DocumentObjectAllocatedTable());
        byte[] bytes = new byte[1024];
        bytes[0] = 1;
        bytes[1] = 2;
        documentObject.seek(0L);
        documentObject.write(bytes, 0, bytes.length);
        documentObject.write(bytes, 0, bytes.length);
        documentObject.write(bytes, 0, bytes.length);
        bytes = new byte[932];
        documentObject.write(bytes, 0, bytes.length);
        Assert.assertEquals((long)documentObject.read(bytes, 0, bytes.length), (long)-1L);
        documentObject.close();
    }

    @Test
    public void testByteA() throws IOException {
        BlockRandomAccessObject documentObject = new BlockRandomAccessObject(new BufferedRandomAccessFile(new File(tmpPath + File.separatorChar + "testByteA1"), "rw", 1024), "testByteA2", 0, 0L, (IObjectAllocTable)new DocumentObjectAllocatedTable());
        byte[] bytes = new byte[15978];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)(i % 128);
            ++i;
        }
        documentObject.seek(0L);
        documentObject.write(bytes, 0, bytes.length);
        documentObject.seek(0L);
        byte[] tBytes = new byte[4096];
        Assert.assertEquals((long)documentObject.read(tBytes, 0, 10), (long)10L);
        Assert.assertEquals((long)documentObject.read(tBytes, 10, tBytes.length - 10), (long)(tBytes.length - 10));
        System.arraycopy(tBytes, 0, bytes, 0, tBytes.length);
        Assert.assertEquals((long)documentObject.read(tBytes, 0, tBytes.length), (long)tBytes.length);
        System.arraycopy(tBytes, 0, bytes, tBytes.length, tBytes.length);
        Assert.assertEquals((long)documentObject.read(tBytes, 0, tBytes.length), (long)tBytes.length);
        System.arraycopy(tBytes, 0, bytes, tBytes.length * 2, tBytes.length);
        Assert.assertEquals((long)documentObject.read(tBytes, 0, tBytes.length), (long)(bytes.length - 3 * tBytes.length));
        System.arraycopy(tBytes, 0, bytes, tBytes.length * 3, bytes.length - 3 * tBytes.length);
        int i2 = 0;
        while (i2 < bytes.length) {
            Assert.assertEquals((long)bytes[i2], (long)((byte)(i2 % 128)));
            ++i2;
        }
        documentObject.close();
    }

    @Test
    public void testString() throws IOException {
        int objectNumber = 3000;
        Assert.assertTrue((this.documentManager.createDocumentObject("testString") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = this.documentManager.openDocumentObject("testString");
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeString("string" + i);
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)documentObject.readString(), (Object)("string" + i));
            ++i;
        }
        documentObject.close();
    }

    @Test
    public void testBigDecimal() throws IOException {
        int objectNumber = 3000;
        Assert.assertTrue((this.documentManager.createDocumentObject("testBigDecimal") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = this.documentManager.openDocumentObject("testBigDecimal");
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeBigDecimal(new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)documentObject.readBigDecimal(), (Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        documentObject.close();
    }

    @Test
    public void testDate() throws IOException {
        int objectNumber = 4101;
        Assert.assertTrue((this.documentManager.createDocumentObject("testDate") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = this.documentManager.openDocumentObject("testDate");
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeDate(new Date(1900100000 + i * 1000));
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)documentObject.readDate(), (Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        documentObject.close();
    }

    @Test
    public void testMixed() throws IOException {
        int objectNumber = 1001;
        Assert.assertTrue((this.documentManager.createDocumentObject("testMixed") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = this.documentManager.openDocumentObject("testMixed");
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeInt(i);
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((long)documentObject.readInt(), (long)i);
            ++i;
        }
        documentObject.writeBigDecimal(new BigDecimal("1010101010101"));
        documentObject.writeDate(new Date(12202000L));
        documentObject.writeString("testString");
        documentObject.writeShort(1300);
        documentObject.writeInt(30000011);
        documentObject.writeObject((Object)new StringBuffer("s1"));
        documentObject.seek(0L);
        documentObject.skipBytes(objectNumber * 4);
        Assert.assertEquals((Object)documentObject.readBigDecimal(), (Object)new BigDecimal("1010101010101"));
        Assert.assertEquals((Object)documentObject.readDate(), (Object)new Date(12202000L));
        Assert.assertEquals((Object)documentObject.readString(), (Object)"testString");
        Assert.assertEquals((long)documentObject.readShort(), (long)1300L);
        Assert.assertEquals((long)documentObject.readInt(), (long)30000011L);
        Object o = documentObject.readObject();
        Assert.assertTrue((boolean)(o instanceof StringBuffer));
        Assert.assertEquals((Object)o.toString(), (Object)"s1");
    }
}

