/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.script;

import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.tests.script.BaseChartTestCase;
import org.eclipse.birt.report.model.api.extension.IColor;
import org.eclipse.birt.report.model.api.extension.IFont;

public class ChartTest
extends BaseChartTestCase {
    public void testTitle() {
        ChartTest.assertEquals((String)"IChart.getTitle", (String)this.getChartWithAxes().getTitle().getCaption().getValue(), (String)"Bar Chart Title");
        String newTitle = "Test title";
        this.getChartWithAxes().getTitle().getCaption().setValue(newTitle);
        ChartTest.assertEquals((String)"IChart.SetTitle", (String)this.getChartWithAxes().getTitle().getCaption().getValue(), (String)newTitle);
    }

    public void testTitleCaptionFont() {
        IFont font = this.getChartWithAxes().getTitle().getCaption().getFont();
        ChartTest.assertNotNull((Object)font);
        ChartTest.assertEquals((Object)new Float(font.getSize()), (Object)new Float(16.0f));
        font.setSize(9.0f);
        ChartTest.assertEquals((Object)new Float(font.getSize()), (Object)new Float(9.0f));
        ChartTest.assertTrue((boolean)font.isBold());
        font.setBold(false);
        ChartTest.assertFalse((boolean)font.isBold());
    }

    public void testTitleCaptionColor() {
        IColor color = this.getChartWithAxes().getTitle().getCaption().getColor();
        ChartTest.assertNotNull((Object)color);
        ChartTest.assertEquals((String)"Dummy color - Red", (int)color.getRed(), (int)0);
        color.setRed(255);
        ChartTest.assertEquals((int)color.getRed(), (int)255);
        ChartTest.assertEquals((String)"Dummy color - transparency", (int)color.getTransparency(), (int)255);
        color.setTransparency(0);
        ChartTest.assertEquals((int)color.getTransparency(), (int)0);
    }

    public void testDescription() {
        ChartTest.assertEquals((String)"IChart.getDescription", (String)this.getChartWithAxes().getDescription().getValue(), (String)"Description");
        String newDesc = "Test description";
        this.getChartWithAxes().getDescription().setValue(newDesc);
        ChartTest.assertEquals((String)"IChart.SetDescription", (String)this.getChartWithAxes().getDescription().getValue(), (String)newDesc);
        ChartTest.assertEquals((String)"IChart.getDescription test null", (String)this.getChartWithoutAxes().getDescription().getValue(), (String)"");
        this.getChartWithoutAxes().getDescription().setValue(newDesc);
        ChartTest.assertEquals((String)"IChart.SetDescription test null", (String)this.getChartWithoutAxes().getDescription().getValue(), (String)newDesc);
    }

    public void testColorByCategory() {
        ChartTest.assertFalse((String)"IChart.isColorByCategory", (boolean)this.getChartWithAxes().isColorByCategory());
        this.getChartWithAxes().setColorByCategory(true);
        ChartTest.assertTrue((String)"IChart.setColorByCategory", (boolean)this.getChartWithAxes().isColorByCategory());
    }

    public void testOutput() {
        ChartTest.assertEquals((String)"IChart.getOutputType", (String)this.getChartWithAxes().getOutputType().toUpperCase(), (String)"PNG");
        this.getChartWithAxes().setOutputType("SVG");
        ChartTest.assertEquals((String)"IChart.setOutputType", (String)this.getChartWithAxes().getOutputType().toUpperCase(), (String)"SVG");
    }

    public void testDimension() {
        ChartTest.assertEquals((String)"IChart.getDimension", (String)this.getChartWithAxes().getDimension(), (String)ChartDimension.TWO_DIMENSIONAL_LITERAL.getName());
        this.getChartWithAxes().setDimension("ThreeDimensional");
        ChartTest.assertEquals((String)"IChart.setDimension", (String)this.getChartWithAxes().getDimension(), (String)ChartDimension.THREE_DIMENSIONAL_LITERAL.getName());
        this.getChartWithAxes().setDimension("3d");
        ChartTest.assertEquals((String)"Test invalid chart dimension", (String)this.getChartWithAxes().getDimension(), (String)ChartDimension.TWO_DIMENSIONAL_LITERAL.getName());
    }

    public void testGetCategory() {
        ChartTest.assertNotNull((String)"IChart.getCategorySeries", (Object)this.getChartWithAxes().getCategory());
    }

    public void testFactory() {
        ChartTest.assertNotNull((String)"IChart.getFactory", (Object)this.getChartWithAxes().getFactory());
    }
}

