/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import junit.framework.TestCase;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;

public class DimensionUtilTest
extends TestCase {
    public void testIsAbsoluteUnit() {
        DimensionUtilTest.assertTrue((boolean)DimensionUtil.isAbsoluteUnit((String)"cm"));
        DimensionUtilTest.assertFalse((boolean)DimensionUtil.isAbsoluteUnit((String)"em"));
        DimensionUtilTest.assertFalse((boolean)DimensionUtil.isAbsoluteUnit((String)"ex"));
        DimensionUtilTest.assertTrue((boolean)DimensionUtil.isAbsoluteUnit((String)"in"));
        DimensionUtilTest.assertTrue((boolean)DimensionUtil.isAbsoluteUnit((String)"mm"));
        DimensionUtilTest.assertTrue((boolean)DimensionUtil.isAbsoluteUnit((String)"pc"));
        DimensionUtilTest.assertFalse((boolean)DimensionUtil.isAbsoluteUnit((String)"%"));
        DimensionUtilTest.assertTrue((boolean)DimensionUtil.isAbsoluteUnit((String)"pt"));
        DimensionUtilTest.assertFalse((boolean)DimensionUtil.isAbsoluteUnit((String)"px"));
    }

    public void testConvertToForAbsoluteUnits() {
        DimensionValue value = DimensionUtil.convertTo((double)100.0, (String)"cm", (String)"in");
        DimensionUtilTest.assertEquals((double)39.37, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"in", (String)"in");
        DimensionUtilTest.assertEquals((double)100.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"mm", (String)"in");
        DimensionUtilTest.assertEquals((double)3.94, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pc", (String)"in");
        DimensionUtilTest.assertEquals((double)16.67, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pt", (String)"in");
        DimensionUtilTest.assertEquals((double)1.39, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"px", (String)"in");
        DimensionUtilTest.assertEquals((double)1.04, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"cm", (String)"cm");
        DimensionUtilTest.assertEquals((double)100.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"mm", (String)"cm");
        DimensionUtilTest.assertEquals((double)10.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"in", (String)"cm");
        DimensionUtilTest.assertEquals((double)254.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pt", (String)"cm");
        DimensionUtilTest.assertEquals((double)3.53, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pc", (String)"cm");
        DimensionUtilTest.assertEquals((double)42.33, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"px", (String)"cm");
        DimensionUtilTest.assertEquals((double)2.64, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"cm", (String)"mm");
        DimensionUtilTest.assertEquals((double)1000.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"mm", (String)"mm");
        DimensionUtilTest.assertEquals((double)100.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"in", (String)"mm");
        DimensionUtilTest.assertEquals((double)2540.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pt", (String)"mm");
        DimensionUtilTest.assertEquals((double)35.28, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pc", (String)"mm");
        DimensionUtilTest.assertEquals((double)423.33, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"px", (String)"mm");
        DimensionUtilTest.assertEquals((double)26.45, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"cm", (String)"pt");
        DimensionUtilTest.assertEquals((double)2834.65, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"mm", (String)"pt");
        DimensionUtilTest.assertEquals((double)283.46, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"in", (String)"pt");
        DimensionUtilTest.assertEquals((double)7200.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pt", (String)"pt");
        DimensionUtilTest.assertEquals((double)100.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pc", (String)"pt");
        DimensionUtilTest.assertEquals((double)1200.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"px", (String)"pt");
        DimensionUtilTest.assertEquals((double)75.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"cm", (String)"pc");
        DimensionUtilTest.assertEquals((double)236.22, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"mm", (String)"pc");
        DimensionUtilTest.assertEquals((double)23.62, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"in", (String)"pc");
        DimensionUtilTest.assertEquals((double)600.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pt", (String)"pc");
        DimensionUtilTest.assertEquals((double)8.33, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pc", (String)"pc");
        DimensionUtilTest.assertEquals((double)100.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"px", (String)"pc");
        DimensionUtilTest.assertEquals((double)6.25, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"cm", (String)"px");
        DimensionUtilTest.assertEquals((double)3779.52, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"mm", (String)"px");
        DimensionUtilTest.assertEquals((double)377.95, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"in", (String)"px");
        DimensionUtilTest.assertEquals((double)9600.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pt", (String)"px");
        DimensionUtilTest.assertEquals((double)133.33, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"pc", (String)"px");
        DimensionUtilTest.assertEquals((double)1600.0, (double)value.getMeasure(), (double)0.01);
        value = DimensionUtil.convertTo((double)100.0, (String)"px", (String)"px");
        DimensionUtilTest.assertEquals((double)100.0, (double)value.getMeasure(), (double)0.01);
    }

    public void testConvertToForRelativeUnits() {
        int dpi = 72;
        DimensionUtilTest.assertEquals((double)0.0, (double)DimensionUtil.convertTo(null, (String)"cm", (String)"mm", (double)10.0, (int)dpi), (double)0.01);
        String value = "10em";
        DimensionUtilTest.assertEquals((double)DimensionUtil.convertTo((Object)value, (String)"in", (String)"cm", (double)10.0, (String)"pt", (int)dpi), (double)DimensionUtil.convertTo((double)100.0, (String)"pt", (String)"cm").getMeasure(), (double)0.01);
        value = "30ex";
        DimensionUtilTest.assertEquals((double)DimensionUtil.convertTo((Object)value, (String)"in", (String)"cm", (double)10.0, (String)"pt", (int)dpi), (double)DimensionUtil.convertTo((double)100.0, (String)"pt", (String)"cm").getMeasure(), (double)0.01);
        value = "50%";
        DimensionUtilTest.assertEquals((double)DimensionUtil.convertTo((Object)value, (String)"in", (String)"cm", (double)10.0, (String)"pt", (int)dpi), (double)DimensionUtil.convertTo((double)5.0, (String)"pt", (String)"cm").getMeasure(), (double)0.01);
        value = "144px";
        DimensionUtilTest.assertEquals((double)DimensionUtil.convertTo((Object)value, (String)"in", (String)"cm", (double)10.0, (String)"pt", (int)dpi), (double)DimensionUtil.convertTo((double)2.0, (String)"in", (String)"cm").getMeasure(), (double)0.01);
    }

    public void testMerge() throws Exception {
        DimensionValue in = DimensionValue.parse((String)"1in");
        DimensionValue cm = DimensionValue.parse((String)"1cm");
        DimensionValue mm = DimensionValue.parse((String)"10mm");
        DimensionValue percentage = DimensionValue.parse((String)"25%");
        DimensionValue px = DimensionValue.parse((String)"10px");
        DimensionValue ex = DimensionValue.parse((String)"10ex");
        DimensionUtilTest.assertEquals((String)"2in", (String)DimensionUtil.mergeDimension((DimensionValue)in, (DimensionValue)in).toString());
        DimensionUtilTest.assertEquals((String)"2cm", (String)DimensionUtil.mergeDimension((DimensionValue)cm, (DimensionValue)cm).toString());
        DimensionUtilTest.assertEquals((String)"20mm", (String)DimensionUtil.mergeDimension((DimensionValue)mm, (DimensionValue)mm).toString());
        DimensionUtilTest.assertEquals((String)"2cm", (String)DimensionUtil.mergeDimension((DimensionValue)cm, (DimensionValue)mm).toString());
        DimensionUtilTest.assertEquals((String)"20mm", (String)DimensionUtil.mergeDimension((DimensionValue)mm, (DimensionValue)cm).toString());
        DimensionUtilTest.assertEquals((String)"50%", (String)DimensionUtil.mergeDimension((DimensionValue)percentage, (DimensionValue)percentage).toString());
        DimensionUtilTest.assertEquals((String)"20px", (String)DimensionUtil.mergeDimension((DimensionValue)px, (DimensionValue)px).toString());
        DimensionUtilTest.assertEquals((String)"20ex", (String)DimensionUtil.mergeDimension((DimensionValue)ex, (DimensionValue)ex).toString());
        DimensionUtilTest.assertEquals((String)"2in", (String)DimensionUtil.mergeDimension((DimensionValue)in, (DimensionValue)px, (int)10).toString());
        DimensionUtilTest.assertEquals((String)DimensionUtil.mergeDimension((DimensionValue)px, (DimensionValue)in, (int)100).toString(), (String)DimensionUtil.mergeDimension((DimensionValue)px, (DimensionValue)in).toString());
        DimensionUtilTest.assertNull((Object)DimensionUtil.mergeDimension((DimensionValue)percentage, (DimensionValue)ex));
        DimensionUtilTest.assertNull((Object)DimensionUtil.mergeDimension((DimensionValue)percentage, (DimensionValue)px));
        DimensionUtilTest.assertNull((Object)DimensionUtil.mergeDimension((DimensionValue)px, (DimensionValue)ex));
        DimensionUtilTest.assertNull((Object)DimensionUtil.mergeDimension((DimensionValue)cm, (DimensionValue)percentage));
        DimensionUtilTest.assertNull((Object)DimensionUtil.mergeDimension((DimensionValue)cm, (DimensionValue)ex));
        DimensionUtilTest.assertNull((Object)DimensionUtil.mergeDimension((DimensionValue)mm, (DimensionValue)percentage));
        DimensionUtilTest.assertNull((Object)DimensionUtil.mergeDimension((DimensionValue)mm, (DimensionValue)ex));
    }
}

