/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class TextDataItemParseTest
extends BaseTestCase {
    String fileName = "TextDataItemParseTest.xml";
    String goldenFileName = "TextDataItemParseTest_golden.xml";
    String checkFileName = "TextDataItemParseTest_1.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        this.openDesign(this.fileName);
        TextDataHandle dataHandle = (TextDataHandle)this.designHandle.findElement("Text Data");
        TextDataItemParseTest.assertNotNull((Object)dataHandle.getElement());
        TextDataItemParseTest.assertEquals((String)"value expr", (String)dataHandle.getValueExpr());
        TextDataItemParseTest.assertEquals((String)"auto", (String)dataHandle.getContentType());
        TextDataItemParseTest.assertTrue((boolean)dataHandle.hasExpression());
        TextDataItemParseTest.assertEquals((String)"Div", (String)dataHandle.getTagType());
        TextDataItemParseTest.assertEquals((String)"English", (String)dataHandle.getLanguage());
        TextDataItemParseTest.assertEquals((String)"Alt Text", (String)dataHandle.getAltTextExpression().getStringExpression());
        TextDataItemParseTest.assertEquals((int)1, (int)dataHandle.getOrder());
        TextDataHandle data2Handle = (TextDataHandle)this.designHandle.findElement("Text Data2");
        TextDataItemParseTest.assertEquals((String)"p", (String)data2Handle.getTagType());
    }

    public void testWriter() throws Exception {
        this.openDesign(this.fileName);
        TextDataHandle dataHandle = (TextDataHandle)this.designHandle.findElement("Text Data");
        TextDataItemParseTest.assertNotNull((Object)dataHandle.getElement());
        dataHandle.setValueExpr("new value expr");
        dataHandle.setContentType("rtf");
        dataHandle.setHasExpression(false);
        dataHandle.setTagType("Div");
        dataHandle.setLanguage("English");
        dataHandle.setAltTextExpression(new Expression((Object)"Alt Text", "constant"));
        dataHandle.setOrder(1);
        this.save();
        TextDataItemParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testSemanticError() throws Exception {
        this.openDesign(this.checkFileName);
        List errors = this.design.getErrorList();
        TextDataItemParseTest.assertEquals((int)1, (int)errors.size());
        int i = 0;
        TextDataItemParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)errors.get(i++)).getErrorCode());
    }
}

