/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ScriptDataSetParseTest
extends BaseTestCase {
    String fileName = "ScriptDataSetTest.xml";
    String outFileName = "ScriptDataSetTest_out.xml";
    String goldenFileName = "ScriptDataSetTest_golden.xml";
    String semanticCheckFileName = "ScriptDataSetTest_1.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        ScriptDataSetHandle dataSet = this.getDataSet();
        ScriptDataSetParseTest.assertEquals((String)"open script", (String)dataSet.getOpen());
        ScriptDataSetParseTest.assertEquals((String)"describe script", (String)dataSet.getDescribe());
        ScriptDataSetParseTest.assertEquals((String)"fetch script", (String)dataSet.getFetch());
        ScriptDataSetParseTest.assertEquals((String)"close script", (String)dataSet.getClose());
    }

    public void testWriter() throws Exception {
        ScriptDataSetHandle dataSet = this.getDataSet();
        dataSet.setOpen("New open script");
        dataSet.setDescribe("New describe script");
        dataSet.setFetch("New fetch script");
        dataSet.setClose("New close script");
        this.save();
        ScriptDataSetParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testSemanticCheck() throws Exception {
        this.openDesign(this.semanticCheckFileName);
        ScriptDataSetParseTest.assertEquals((int)0, (int)this.design.getErrorList().size());
    }

    private ScriptDataSetHandle getDataSet() throws Exception {
        this.openDesign(this.fileName);
        ScriptDataSetHandle dataSet = (ScriptDataSetHandle)this.designHandle.findDataSet("firstDataSet");
        ScriptDataSetParseTest.assertNotNull((Object)dataSet);
        return dataSet;
    }
}

