/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class PropertyStateTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testConflictPropertyName() {
        try {
            this.openDesign("PropertyStateTest.xml");
            PropertyStateTest.fail();
        }
        catch (DesignFileException e) {
            PropertyStateTest.assertEquals((int)2, (int)e.getErrorList().size());
            int i = 0;
            PropertyStateTest.assertEquals((String)"Error.DesignParserException.INVALID_PROPERTY_SYNTAX", (String)((ErrorDetail)e.getErrorList().get(i++)).getErrorCode());
            PropertyStateTest.assertEquals((String)"Error.DesignParserException.INVALID_PROPERTY_SYNTAX", (String)((ErrorDetail)e.getErrorList().get(i++)).getErrorCode());
        }
    }

    public void testEmptyString() throws Exception {
        this.openDesign("PropertyStateTest_1.xml");
        OdaDataSourceHandle dataSourceHandle = (OdaDataSourceHandle)this.designHandle.findDataSource("myDataSource");
        PropertyStateTest.assertEquals(null, (String)dataSourceHandle.getDriverName());
        dataSourceHandle = (OdaDataSourceHandle)this.designHandle.findDataSource("myDataSource1");
        PropertyStateTest.assertEquals(null, (String)dataSourceHandle.getDriverName());
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label1");
        PropertyStateTest.assertEquals(null, (String)labelHandle.getHelpText());
        PropertyStateTest.assertEquals((String)" ", (String)labelHandle.getHelpTextKey());
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.findElement("data1");
        PropertyStateTest.assertNull((Object)dataHandle.getResultSetExpression());
        dataHandle.setResultSetColumn("   a   ");
        PropertyStateTest.assertEquals((String)"a", (String)dataHandle.getResultSetColumn());
        Iterator iter = this.designHandle.imagesIterator();
        EmbeddedImageHandle imageHandle = (EmbeddedImageHandle)iter.next();
        PropertyStateTest.assertNotNull((Object)imageHandle);
        PropertyStateTest.assertEquals(null, (Object)imageHandle.getData());
        TextItemHandle textHandle = (TextItemHandle)this.designHandle.findElement("text1");
        PropertyStateTest.assertEquals((String)"   ", (String)textHandle.getContent());
        textHandle.setContent("   a   ");
        PropertyStateTest.assertEquals((String)"   a   ", (String)textHandle.getContent());
        PropertyStateTest.assertEquals((String)"html", (String)textHandle.getContentType());
        textHandle.setContentType("   auto   ");
        PropertyStateTest.assertEquals((String)"auto", (String)textHandle.getContentType());
        PropertyStateTest.assertEquals((String)"html", (String)this.designHandle.getStringProperty("description"));
        this.designHandle.setStringProperty("description", "   <p> html </p>   ");
        PropertyStateTest.assertEquals((String)"<p> html </p>", (String)this.designHandle.getStringProperty("description"));
        this.save();
        PropertyStateTest.assertTrue((boolean)this.compareFile("PropertyStateTest_golden.xml"));
    }

    public void testBlankStructureName() {
        try {
            this.openDesign("PropertyStateTest_2.xml");
            PropertyStateTest.fail();
        }
        catch (DesignFileException e) {
            List list = e.getErrorList();
            PropertyStateTest.assertEquals((int)1, (int)list.size());
            PropertyStateTest.assertEquals((String)"Error.DesignParserException.NAME_REQUIRED", (String)((ErrorDetail)list.get(0)).getErrorCode());
        }
    }

    public void testWrongStructureName() {
        try {
            this.openDesign("PropertyStateTest_3.xml");
            PropertyStateTest.fail();
        }
        catch (DesignFileException e) {
            List list = e.getErrorList();
            PropertyStateTest.assertEquals((int)1, (int)list.size());
            PropertyStateTest.assertEquals((String)"Error.DesignParserException.INVALID_STRUCTURE_NAME", (String)((ErrorDetail)list.get(0)).getErrorCode());
        }
    }

    public void testBlankMemberName() {
        try {
            this.openDesign("PropertyStateTest_4.xml");
            PropertyStateTest.fail();
        }
        catch (DesignFileException e) {
            List list = e.getErrorList();
            PropertyStateTest.assertEquals((int)2, (int)list.size());
            PropertyStateTest.assertEquals((String)"Error.DesignParserException.NAME_REQUIRED", (String)((ErrorDetail)list.get(0)).getErrorCode());
            PropertyStateTest.assertEquals((String)"Error.DesignParserException.NAME_REQUIRED", (String)((ErrorDetail)list.get(1)).getErrorCode());
        }
    }

    public void testBlankPropertyListName() {
        try {
            this.openDesign("PropertyStateTest_5.xml");
            PropertyStateTest.fail();
        }
        catch (DesignFileException e) {
            List list = e.getErrorList();
            PropertyStateTest.assertEquals((int)1, (int)list.size());
            PropertyStateTest.assertEquals((String)"Error.DesignParserException.NAME_REQUIRED", (String)((ErrorDetail)list.get(0)).getErrorCode());
        }
    }

    public void testWrongNameInExtendedProperty() throws DesignFileException {
        this.openDesign("PropertyStateTest_6.xml");
    }

    public void testWrongPropertyListName() throws DesignFileException {
        this.openDesign("PropertyStateTest_7.xml");
        List list = this.designHandle.getErrorList();
        PropertyStateTest.assertEquals((int)2, (int)list.size());
        PropertyStateTest.assertEquals((String)"Error.SemanticError.MISSING_MASTER_PAGE", (String)((ErrorDetail)list.get(0)).getErrorCode());
        PropertyStateTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)((ErrorDetail)list.get(1)).getErrorCode());
    }

    public void testWrongMemberName() throws DesignFileException {
        this.openDesign("PropertyStateTest_8.xml");
        List list = this.designHandle.getErrorList();
        PropertyStateTest.assertEquals((int)2, (int)list.size());
        PropertyStateTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)((ErrorDetail)list.get(1)).getErrorCode());
    }

    public void testWrongPropertyNameInTextProperty() throws DesignFileException {
        this.openDesign("PropertyStateTest_9.xml");
        List list = this.designHandle.getErrorList();
        PropertyStateTest.assertEquals((int)1, (int)list.size());
        PropertyStateTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)((ErrorDetail)list.get(0)).getErrorCode());
    }

    public void testBlankResourceKeyValueInTextProperty() throws DesignFileException {
        this.openDesign("PropertyStateTest_10.xml");
    }

    public void testUserPropertyWithBlankChoices() {
        try {
            this.openDesign("PropertyStateTest_11.xml");
            PropertyStateTest.fail();
        }
        catch (DesignFileException e) {
            List list = e.getErrorList();
            PropertyStateTest.assertEquals((int)2, (int)list.size());
            PropertyStateTest.assertEquals((String)"Error.DesignParserException.NAME_REQUIRED", (String)((ErrorDetail)list.get(0)).getErrorCode());
            PropertyStateTest.assertEquals((String)"Error.UserPropertyException.MISSING_CHOICES", (String)((ErrorDetail)list.get(1)).getErrorCode());
        }
    }

    public void testUserPropertyWithWrongChoices() {
        try {
            this.openDesign("PropertyStateTest_12.xml");
            PropertyStateTest.fail();
        }
        catch (DesignFileException e) {
            List list = e.getErrorList();
            PropertyStateTest.assertEquals((int)2, (int)list.size());
            PropertyStateTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)((ErrorDetail)list.get(1)).getErrorCode());
            PropertyStateTest.assertEquals((String)"Error.UserPropertyException.MISSING_CHOICES", (String)((ErrorDetail)list.get(0)).getErrorCode());
        }
    }

    public void testUserPropertyWithValue() throws DesignFileException {
        this.openDesign("PropertyStateTest_13.xml");
        List list = this.designHandle.getErrorList();
        PropertyStateTest.assertEquals((int)1, (int)list.size());
        PropertyStateTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)((ErrorDetail)list.get(0)).getErrorCode());
    }

    public void testChoiceNotAllowed() throws DesignFileException {
    }

    public void testValidator() throws DesignFileException {
        this.openDesign("PropertyStateTest_15.xml");
        List errors = this.designHandle.getErrorList();
        PropertyStateTest.assertEquals((int)4, (int)errors.size());
        ErrorDetail error = (ErrorDetail)errors.get(0);
        PropertyStateTest.assertEquals((String)"Error.PropertyValueException.NEGATIVE_VALUE", (String)error.getErrorCode());
        PropertyStateTest.assertEquals((String)"style1", (String)error.getElement().getName());
        PropertyStateTest.assertEquals((int)10, (int)error.getLineNo());
        error = (ErrorDetail)errors.get(1);
        PropertyStateTest.assertEquals((String)"Error.PropertyValueException.NON_POSITIVE_VALUE", (String)error.getErrorCode());
        PropertyStateTest.assertEquals((String)"style1", (String)error.getElement().getName());
        PropertyStateTest.assertEquals((int)12, (int)error.getLineNo());
        error = (ErrorDetail)errors.get(2);
        PropertyStateTest.assertEquals((String)"Error.PropertyValueException.NON_POSITIVE_VALUE", (String)error.getErrorCode());
        PropertyStateTest.assertEquals((String)"parent", (String)error.getElement().getName());
        PropertyStateTest.assertEquals((int)19, (int)error.getLineNo());
        error = (ErrorDetail)errors.get(3);
        PropertyStateTest.assertEquals((String)"Error.PropertyValueException.NEGATIVE_VALUE", (String)error.getErrorCode());
        PropertyStateTest.assertEquals((String)"form1", (String)error.getElement().getName());
        PropertyStateTest.assertEquals((int)24, (int)error.getLineNo());
        SharedStyleHandle styleHandle = this.designHandle.findStyle("style1");
        Iterator iter = styleHandle.highlightRulesIterator();
        HighlightRuleHandle ruleHandle = (HighlightRuleHandle)iter.next();
        PropertyStateTest.assertEquals((String)"-2cm", (String)ruleHandle.getBorderBottomWidth().getStringValue());
        PropertyStateTest.assertEquals((String)"0pt", (String)ruleHandle.getFontSize().getStringValue());
        GraphicMasterPageHandle pageHandle = (GraphicMasterPageHandle)this.designHandle.findMasterPage("parent");
        PropertyStateTest.assertEquals((int)0, (int)pageHandle.getColumnCount());
        FreeFormHandle handle = (FreeFormHandle)this.designHandle.findElement("form1");
        PropertyStateTest.assertEquals((String)"-1in", (String)handle.getWidth().getStringValue());
        PropertyStateTest.assertEquals((String)"-1in", (String)handle.getStringProperty("width"));
    }
}

