/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.SlotIterator;
import org.eclipse.birt.report.model.api.SortedSlotIterator;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ParameterGroupTest
extends BaseTestCase {
    private final String FILE_NAME = "ParameterGroupTest.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("ParameterGroupTest.xml");
    }

    public void testProperty() throws Exception {
        ParameterGroupHandle h = this.getParameterGroup("My Param Group");
        ParameterGroupTest.assertNotNull((Object)h);
        ParameterGroupTest.assertEquals((String)"This group contains a bunch of parameters.", (String)h.getHelpText());
        ParameterGroupTest.assertEquals((String)"group key", (String)h.getHelpTextKey());
        ParameterGroupTest.assertTrue((boolean)h.startExpanded());
        h.setStartExpanded(false);
        h.setStringProperty("startExpanded", "false");
        ParameterGroupTest.assertFalse((boolean)h.startExpanded());
        ParameterGroupHandle countryStateCity = this.getParameterGroup("Country-State-City");
        ParameterGroupTest.assertEquals((String)"Group 2", (String)countryStateCity.getDisplayName());
    }

    public void testParameters() throws Exception {
        ParameterGroupHandle h = this.getParameterGroup("My Param Group");
        ParameterGroupTest.assertNotNull((Object)h);
        SlotHandle slotHandle = h.getParameters();
        ParameterGroupTest.assertTrue((slotHandle.getCount() == 1 ? 1 : 0) != 0);
        DesignElementHandle elementHandle = slotHandle.get(0);
        String o = elementHandle.getName();
        ParameterGroupTest.assertEquals((Object)"Param 2", (Object)o);
        ParameterGroupHandle countryStateCity = this.getParameterGroup("Country-State-City");
        SlotHandle cascadingParameters = countryStateCity.getParameters();
        ParameterGroupTest.assertEquals((int)3, (int)cascadingParameters.getCount());
        ScalarParameterHandle p1 = (ScalarParameterHandle)cascadingParameters.get(0);
        ParameterGroupTest.assertEquals((String)"dynamic", (String)p1.getValueType());
        ParameterGroupTest.assertEquals((String)"ds1", (String)p1.getDataSetName());
        ParameterGroupTest.assertEquals((String)"country", (String)p1.getValueExpr());
        ParameterGroupTest.assertEquals((String)"Enter country:", (String)p1.getLabelExpr());
    }

    public void testFlattenParameters() throws Exception {
        String[] goldenArray = new String[]{"City", "Country", "Group 1", "Group 2", "Param 1", "Param 2", "Param 3", "State"};
        List it = this.designHandle.getFlattenParameters();
        int i = 0;
        while (i < it.size()) {
            DesignElementHandle h = (DesignElementHandle)it.get(i);
            String displayName = h.getElement().getDisplayName();
            ParameterGroupTest.assertEquals((String)goldenArray[i], (String)displayName);
            ++i;
        }
    }

    public void testSortedSlotIterator() throws Exception {
        String[] goldenArray = new String[]{"Group 1", "Group 2", "Param 1", "Param 3"};
        SlotHandle handle = this.designHandle.getParameters();
        SortedSlotIterator it = new SortedSlotIterator(handle);
        int i = 0;
        while (it.hasNext()) {
            DesignElementHandle h = (DesignElementHandle)it.next();
            String displayName = h.getElement().getDisplayName();
            ParameterGroupTest.assertEquals((String)goldenArray[i++], (String)displayName);
        }
    }

    private ParameterGroupHandle getParameterGroup(String name) {
        SlotHandle slotHandle = this.designHandle.getParameters();
        SlotIterator iter = new SlotIterator(slotHandle);
        while (iter.hasNext()) {
            DesignElementHandle h = iter.next();
            if (!(h instanceof ParameterGroupHandle) || !name.equals(h.getName())) continue;
            return (ParameterGroupHandle)h;
        }
        return null;
    }

    public void testWriter() throws Exception {
        ParameterGroupHandle h = this.getParameterGroup("My Param Group");
        ParameterGroupTest.assertNotNull((Object)h);
        h.setHelpText("new help text");
        h.setHelpTextKey("key of new help text");
        this.save();
        ParameterGroupTest.assertTrue((boolean)this.compareFile("ParameterGroupTest_golden.xml"));
    }
}

