/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ScalarParameterHandleTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        this.openDesign("ScalarParameterHandleTest.xml");
    }

    public void testGetsPropertiesOnParameter() throws SemanticException {
        SlotHandle params = this.designHandle.getParameters();
        ScalarParameterHandle handle = (ScalarParameterHandle)params.get(4);
        ScalarParameterHandleTest.assertEquals((String)"date", (String)handle.getDataType());
        handle = (ScalarParameterHandle)params.get(5);
        ScalarParameterHandleTest.assertEquals((String)"time", (String)handle.getDataType());
        ScalarParameterHandleTest.assertEquals((int)1, (int)handle.getAutoSuggestThreshold());
        handle = (ScalarParameterHandle)params.get(0);
        ScalarParameterHandleTest.assertFalse((boolean)handle.isHidden());
        ScalarParameterHandleTest.assertEquals((String)"decimal", (String)handle.getDataType());
        ScalarParameterHandleTest.assertFalse((boolean)handle.isConcealValue());
        ScalarParameterHandleTest.assertEquals((String)"State", (String)handle.getDefaultValue());
        ScalarParameterHandleTest.assertFalse((boolean)handle.isRequired());
        ScalarParameterHandleTest.assertEquals((String)"##,###.##", (String)handle.getPattern());
        ScalarParameterHandleTest.assertEquals((String)"check-box", (String)handle.getControlType());
        ScalarParameterHandleTest.assertEquals((String)"left", (String)handle.getAlignment());
        Iterator iter = handle.choiceIterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        ScalarParameterHandleTest.assertEquals((int)0, (int)count);
        ScalarParameterHandleTest.assertEquals((String)"scalar para help", (String)handle.getHelpText());
        ScalarParameterHandleTest.assertEquals((String)"help", (String)handle.getHelpTextKey());
        handle = (ScalarParameterHandle)params.get(1);
        ScalarParameterHandleTest.assertFalse((boolean)handle.isHidden());
        ScalarParameterHandleTest.assertEquals((String)"string", (String)handle.getDataType());
        ScalarParameterHandleTest.assertFalse((boolean)handle.isConcealValue());
        ScalarParameterHandleTest.assertNull((Object)handle.getDefaultValue());
        ScalarParameterHandleTest.assertTrue((boolean)handle.isRequired());
        ScalarParameterHandleTest.assertNull((Object)handle.getPattern());
        ScalarParameterHandleTest.assertNull((Object)handle.getControlType());
        ScalarParameterHandleTest.assertEquals((String)"auto", (String)handle.getAlignment());
        ScalarParameterHandleTest.assertNull((Object)handle.getHelpText());
        ScalarParameterHandleTest.assertEquals((String)"actuate", (String)handle.getPromptText());
        handle.setPromptText("actuate shanghai");
        ScalarParameterHandleTest.assertEquals((String)"actuate shanghai", (String)handle.getPromptText());
        ScalarParameterHandleTest.assertEquals((String)"ResourceKey.Parameter.PromptText", (String)handle.getPromptTextID());
        handle.setPromptTextID("ResourceKey.Parameter.PromptTextValue");
        ScalarParameterHandleTest.assertEquals((String)"ResourceKey.Parameter.PromptTextValue", (String)handle.getPromptTextID());
        ScalarParameterHandleTest.assertEquals((String)"dataset 1", (String)handle.getDataSetName());
        DataSetHandle dataSet = handle.getDataSet();
        ScalarParameterHandleTest.assertEquals((String)"dataset 1", (String)dataSet.getName());
        ScalarParameterHandleTest.assertEquals((String)"value column", (String)handle.getValueExpr());
        ScalarParameterHandleTest.assertEquals((String)"label column", (String)handle.getLabelExpr());
        handle = (ScalarParameterHandle)params.get(2);
        ScalarParameterHandleTest.assertTrue((boolean)handle.isMustMatch());
        ScalarParameterHandleTest.assertFalse((boolean)handle.isFixedOrder());
        iter = handle.choiceIterator();
        ScalarParameterHandleTest.assertNotNull((Object)iter);
        count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        ScalarParameterHandleTest.assertEquals((int)0, (int)count);
        handle = (ScalarParameterHandle)params.get(3);
        ScalarParameterHandleTest.assertTrue((boolean)handle.isMustMatch());
        ScalarParameterHandleTest.assertTrue((boolean)handle.isFixedOrder());
        StructureHandle[] choices = new StructureHandle[3];
        count = 0;
        iter = handle.choiceIterator();
        while (iter.hasNext()) {
            choices[count] = (StructureHandle)iter.next();
            ++count;
        }
        ScalarParameterHandleTest.assertEquals((int)3, (int)count);
        ScalarParameterHandleTest.assertEquals((Object)"option 1", (Object)choices[0].getMember("value").getValue());
        ScalarParameterHandleTest.assertEquals((Object)"option 1 label", (Object)choices[0].getMember("label").getValue());
        ScalarParameterHandleTest.assertEquals((Object)"key 1 for label 1", (Object)choices[0].getMember("labelID").getValue());
        ScalarParameterHandleTest.assertEquals((Object)"option 3", (Object)choices[2].getMember("value").getValue());
        ScalarParameterHandleTest.assertNull((Object)choices[2].getMember("label").getValue());
        ScalarParameterHandleTest.assertNull((Object)choices[2].getMember("labelID").getValue());
        handle = (ScalarParameterHandle)params.get(6);
        ScalarParameterHandleTest.assertEquals((int)0, (int)handle.getListlimit());
    }

    public void testSetsPropertiesOnParameter() throws Exception {
        SlotHandle params = this.designHandle.getParameters();
        ScalarParameterHandle handle = (ScalarParameterHandle)params.get(0);
        ScalarParameterHandleTest.assertFalse((boolean)handle.isHidden());
        handle.setHidden(true);
        ScalarParameterHandleTest.assertTrue((boolean)handle.isHidden());
        handle.setDataType("dateTime");
        ScalarParameterHandleTest.assertEquals((String)"dateTime", (String)handle.getDataType());
        handle.setDataType("date");
        ScalarParameterHandleTest.assertEquals((String)"date", (String)handle.getDataType());
        handle.setDataType("time");
        ScalarParameterHandleTest.assertEquals((String)"time", (String)handle.getDataType());
        handle.setDataType("float");
        ScalarParameterHandleTest.assertEquals((String)"float", (String)handle.getDataType());
        handle.setConcealValue(true);
        ScalarParameterHandleTest.assertTrue((boolean)handle.isConcealValue());
        handle.setDefaultValue("new default value");
        ScalarParameterHandleTest.assertEquals((String)"new default value", (String)handle.getDefaultValue());
        handle.setIsRequired(false);
        ScalarParameterHandleTest.assertFalse((boolean)handle.isRequired());
        handle.setPattern("$***,***.**");
        ScalarParameterHandleTest.assertEquals((String)"$***,***.**", (String)handle.getPattern());
        handle.setControlType("radio-button");
        ScalarParameterHandleTest.assertEquals((String)"radio-button", (String)handle.getControlType());
        handle.setAlignment("right");
        ScalarParameterHandleTest.assertEquals((String)"right", (String)handle.getAlignment());
    }

    public void testSyntaxCheck() throws Exception {
        this.openDesign("ScalarParameterHandleTest_1.xml");
        List errors = this.designHandle.getErrorList();
        ScalarParameterHandleTest.assertEquals((int)1, (int)errors.size());
        int i = 0;
        ScalarParameterHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)errors.get(i++)).getErrorCode());
    }
}

