/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.util.CompatibilityUtil;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CompatibilityUtilTest
extends BaseTestCase {
    public void testUpdateCachedMetaDataResultSet() throws Exception {
        this.createDesign();
        ScriptDataSetHandle setHandle = this.designHandle.getElementFactory().newScriptDataSet("dataset1");
        List columns = this.createResultColumns();
        CompatibilityUtil.updateResultSetinCachedMetaData((DataSetHandle)setHandle, (List)columns);
        CachedMetaDataHandle cachedMeta = setHandle.getCachedMetaDataHandle();
        CompatibilityUtilTest.assertNotNull((Object)cachedMeta);
        List newColumns = (List)cachedMeta.getResultSet().getValue();
        CompatibilityUtilTest.assertEquals((int)2, (int)newColumns.size());
        columns.clear();
        columns.add(StructureFactory.createColumnHint());
        try {
            CompatibilityUtil.updateResultSetinCachedMetaData((DataSetHandle)setHandle, (List)columns);
            CompatibilityUtilTest.fail();
        }
        catch (SemanticException e) {
            CompatibilityUtilTest.assertEquals((String)"Error.PropertyValueException.WRONG_ITEM_TYPE", (String)e.getErrorCode());
        }
        columns.clear();
        columns.add(StructureFactory.createResultSetColumn());
        try {
            CompatibilityUtil.updateResultSetinCachedMetaData((DataSetHandle)setHandle, (List)columns);
            CompatibilityUtilTest.fail();
        }
        catch (SemanticException e) {
            CompatibilityUtilTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)e.getErrorCode());
        }
        cachedMeta.setProperty("resultSet", null);
        columns = this.createResultColumns();
        CompatibilityUtil.updateResultSetinCachedMetaData((DataSetHandle)setHandle, (List)columns);
        newColumns = (List)cachedMeta.getResultSet().getValue();
        CompatibilityUtilTest.assertEquals((int)2, (int)newColumns.size());
    }

    private List createResultColumns() {
        ArrayList<ResultSetColumn> columns = new ArrayList<ResultSetColumn>();
        ResultSetColumn column = StructureFactory.createResultSetColumn();
        column.setColumnName("column1");
        column.setPosition(new Integer(1));
        columns.add(column);
        column = StructureFactory.createResultSetColumn();
        column.setColumnName("column2");
        column.setPosition(new Integer(2));
        columns.add(column);
        return columns;
    }

    public void testAddResultSetColumn() throws Exception {
        this.createDesign();
        OdaDataSetHandle dsHandle = this.designHandle.getElementFactory().newOdaDataSet("newDataSet", null);
        this.designHandle.getDataSets().add((DesignElementHandle)dsHandle);
        OdaResultSetColumn rsColumn = new OdaResultSetColumn();
        rsColumn.setColumnName("columnName");
        rsColumn.setDataType("string");
        rsColumn.setPosition(new Integer(1));
        ArrayList<OdaResultSetColumn> list = new ArrayList<OdaResultSetColumn>();
        list.add(rsColumn);
        MockListener listener = new MockListener();
        dsHandle.addListener((Listener)listener);
        MockListener listener2 = new MockListener();
        this.designHandle.addListener((Listener)listener2);
        CompatibilityUtil.addResultSetColumn((DataSetHandle)dsHandle, list);
        CompatibilityUtilTest.assertEquals((int)0, (int)listener.getCount());
        CompatibilityUtilTest.assertEquals((int)0, (int)listener2.getCount());
        PropertyHandle resultSetColumnHandle = dsHandle.getPropertyHandle("resultSet");
        OdaResultSetColumnHandle setHandle = (OdaResultSetColumnHandle)resultSetColumnHandle.getAt(0);
        CompatibilityUtilTest.assertEquals((String)"columnName", (String)setHandle.getColumnName());
        CompatibilityUtilTest.assertEquals((String)"string", (String)setHandle.getDataType());
        CompatibilityUtilTest.assertEquals((int)1, (int)setHandle.getPosition());
    }

    private class MockListener
    implements Listener {
        private int count = 0;

        private MockListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

