/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ScalarParameterDefn;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class ReportEngineTest
extends EngineCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT("report_engine.rptdesign", "report_engine.rptdesign");
        this.copyResource_INPUT("parameter.rptdesign", "parameter.rptdesign");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource();
    }

    public ReportEngineTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ReportEngineTest.class);
    }

    public void testGetConfig() {
        EngineConfig config = new EngineConfig();
        config.setTempDir("tempdir");
        ReportEngine engine = new ReportEngine(config);
        EngineConfig configGet = engine.getConfig();
        ReportEngineTest.assertEquals((String)"getConfig() fail", (String)config.getTempDir(), (String)configGet.getTempDir());
    }

    public void testOpenReportDesign() throws EngineException {
        EngineConfig config = new EngineConfig();
        config.setTempDir("tempdir");
        ReportEngine engine = new ReportEngine(config);
        Object designName = this.genInputFile("report_engine.rptdesign");
        try {
            IReportRunnable reportRunner = engine.openReportDesign((String)designName);
            designName = "file:" + (String)designName;
            designName = ((String)designName).replace('/', '\\');
            String reportName = reportRunner.getReportName().replace('/', '\\');
            ReportEngineTest.assertEquals((String)"openReportDesign(String) fail", (String)((String)designName).substring(((String)designName).indexOf("org")), (String)reportName.substring(reportName.indexOf("org")));
            ReportEngineTest.assertNotNull((String)"openReportDesign(String) fail", (Object)reportRunner.getImage("23.gif"));
        }
        catch (EngineException ee) {
            ee.printStackTrace();
            ReportEngineTest.fail((String)"openReportDesign(String) fail");
        }
        engine.destroy();
    }

    public void testOpenReportDesign1() {
        EngineConfig config = new EngineConfig();
        config.setTempDir("tempdir");
        ReportEngine engine = new ReportEngine(config);
        String designName = this.genInputFile("report_engine.rptdesign");
        try {
            File file = new File(designName);
            FileInputStream fis = new FileInputStream(file);
            IReportRunnable reportRunner = engine.openReportDesign((InputStream)fis);
            ReportEngineTest.assertEquals((String)"openReportDesign(InputStream) fail", (String)"<stream>", (String)reportRunner.getReportName());
            ReportEngineTest.assertNotNull((String)"openReportDesign(InputStream) fail", (Object)reportRunner.getImage("23.gif"));
        }
        catch (FileNotFoundException | EngineException fe) {
            fe.printStackTrace();
        }
        engine.destroy();
    }

    public void testCreateGetParameterDefinitionTask() {
        EngineConfig config = new EngineConfig();
        ReportEngine engine = new ReportEngine(config);
        String designName = this.genInputFile("parameter.rptdesign");
        try {
            IReportRunnable reportRunner = engine.openReportDesign(designName);
            IGetParameterDefinitionTask getParamTask = engine.createGetParameterDefinitionTask(reportRunner);
            getParamTask.evaluateDefaults();
            IParameterDefnBase paramDefn = getParamTask.getParameterDefn("p1");
            System.err.println(paramDefn.getTypeName());
            System.err.println(paramDefn instanceof ScalarParameterDefn);
            ReportEngineTest.assertEquals((String)"creatGetParameterDefinitionTask() fail", (Object)"abc", (Object)getParamTask.getDefaultValue(paramDefn));
        }
        catch (EngineException ee) {
            ee.printStackTrace();
        }
    }

    public void testGetEmitterInfos() {
        String[][] stringArrayArray = new String[11][];
        String[] stringArray = new String[5];
        stringArray[0] = "uk.co.spudsoft.birt.emitters.excel.XlsxEmitter";
        stringArray[1] = "xlsx";
        stringArray[3] = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        stringArray[4] = "page-break-pagination";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[5];
        stringArray2[0] = "org.eclipse.birt.report.engine.emitter.pdf";
        stringArray2[1] = "pdf";
        stringArray2[3] = "application/pdf";
        stringArray2[4] = "paper-size-pagination";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = "org.eclipse.birt.report.engine.emitter.postscript";
        stringArray3[1] = "postscript";
        stringArray3[3] = "application/postscript";
        stringArray3[4] = "paper-size-pagination";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[5];
        stringArray4[0] = "org.eclipse.birt.report.engine.emitter.word";
        stringArray4[1] = "doc";
        stringArray4[3] = "application/msword";
        stringArray4[4] = "page-break-pagination";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[5];
        stringArray5[0] = "org.eclipse.birt.report.engine.emitter.docx";
        stringArray5[1] = "docx";
        stringArray5[3] = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        stringArray5[4] = "page-break-pagination";
        stringArrayArray[4] = stringArray5;
        String[] stringArray6 = new String[5];
        stringArray6[0] = "org.eclipse.birt.report.engine.emitter.html";
        stringArray6[1] = "html";
        stringArray6[3] = "text/html";
        stringArray6[4] = "page-break-pagination";
        stringArrayArray[5] = stringArray6;
        stringArrayArray[6] = new String[]{"org.eclipse.birt.report.engine.emitter.prototype.ods", "ods", "resource/ODS.gif", "application/vnd.oasis.opendocument.spreadsheet", "no-pagination"};
        String[] stringArray7 = new String[5];
        stringArray7[0] = "org.eclipse.birt.report.engine.emitter.ppt";
        stringArray7[1] = "ppt";
        stringArray7[3] = "application/vnd.ms-powerpoint";
        stringArray7[4] = "paper-size-pagination";
        stringArrayArray[7] = stringArray7;
        String[] stringArray8 = new String[5];
        stringArray8[0] = "org.eclipse.birt.report.engine.emitter.pptx";
        stringArray8[1] = "pptx";
        stringArray8[3] = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        stringArray8[4] = "paper-size-pagination";
        stringArrayArray[8] = stringArray8;
        stringArrayArray[9] = new String[]{"org.eclipse.birt.report.engine.emitter.odt", "odt", "resource/ODT.gif", "application/vnd.oasis.opendocument.text", "page-break-pagination"};
        String[] stringArray9 = new String[5];
        stringArray9[0] = "uk.co.spudsoft.birt.emitters.excel.XlsEmitter";
        stringArray9[1] = "xls_spudsoft";
        stringArray9[3] = "application/vnd.ms-excel";
        stringArray9[4] = "page-break-pagination";
        stringArrayArray[10] = stringArray9;
        String[][] expected = stringArrayArray;
        EngineConfig config = new EngineConfig();
        ReportEngine engine = new ReportEngine(config);
        EmitterInfo[] emitters = engine.getEmitterInfo();
        ReportEngineTest.assertNotNull((Object)emitters);
        int i = 0;
        while (i < expected.length) {
            String found = "";
            int j = 0;
            while (j < emitters.length) {
                if (expected[i][0].equals(emitters[j].getID())) {
                    found = emitters[j].getID();
                    ReportEngineTest.assertEquals((String)expected[i][1], (String)emitters[j].getFormat());
                    ReportEngineTest.assertEquals((String)expected[i][2], (String)emitters[j].getIcon());
                    ReportEngineTest.assertEquals((String)expected[i][3], (String)emitters[j].getMimeType());
                    ReportEngineTest.assertEquals((String)expected[i][4], (String)emitters[j].getPagination());
                    break;
                }
                ++j;
            }
            ReportEngineTest.assertEquals((String)expected[i][0], (String)found);
            ++i;
        }
    }
}

