/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.IAdvanceReportEditorPage;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.preview.editors.ReportPreviewEditor;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.viewer.browsers.BrowserManager;
import org.eclipse.birt.report.viewer.utilities.IWebAppInfo;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class ReportPreviewFormPage
extends ReportPreviewEditor
implements IAdvanceReportEditorPage {
    protected static final Logger logger = Logger.getLogger(ReportPreviewFormPage.class.getName());
    public static final String ID = "org.eclipse.birt.report.designer.ui.editors.preview.web";
    private Control control;
    private int staleType;
    private FormEditor editor;
    private boolean isPreviewing;
    public static final String SUFFIX_TEMPLATE_FILE = "rpttemplate";
    public static final String SUFFIX_DESIGN_CONFIG = "rptconfig";
    public static final String PROP_TYPE = "type";
    public static final String PROP_EXPR = "expr";

    public boolean onBroughtToTop(IReportEditorPage prePage) {
        boolean ret;
        if (this.getEditorInput() != prePage.getEditorInput()) {
            this.setInput(prePage.getEditorInput());
        }
        boolean bool = true;
        if (this.isDirtyModel()) {
            this.doSave(null);
            bool = false;
        }
        if (prePage.isDirty() && bool) {
            prePage.doSave(null);
        }
        if (!(ret = this.refresh()) && this.isMissingParameter()) {
            this.editor.setActivePage(prePage.getId());
        }
        return ret;
    }

    @Override
    protected boolean refresh() {
        if (this.isPreviewing) {
            return false;
        }
        this.isPreviewing = true;
        ModuleHandle model = this.getModel();
        if (!UIUtil.canPreviewWithErrors((ModuleHandle)model)) {
            this.isPreviewing = false;
            return false;
        }
        boolean isDisplay = false;
        if (BrowserManager.getInstance().isEmbeddedBrowserPresent()) {
            this.showProgress();
        }
        if (this.hasParameters()) {
            if (this.parameterDialog != null) {
                this.parameterDialog.open();
                if (this.parameterDialog.getReturnCode() == 1001) {
                    isDisplay = true;
                    if (this.isMissingParameter()) {
                        this.isPreviewing = false;
                        return false;
                    }
                } else {
                    this.hideProgress();
                }
            } else {
                isDisplay = true;
            }
        } else {
            isDisplay = true;
        }
        if (isDisplay) {
            this.display();
        }
        ReportRequest request = new ReportRequest((Object)this);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Object());
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)request);
        this.isPreviewing = false;
        return true;
    }

    private boolean isDirtyModel() {
        if (this.getModel() != null) {
            return this.getModel().needsSave();
        }
        return false;
    }

    public Control getPartControl() {
        return this.control;
    }

    public String getId() {
        return ID;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.control = children[children.length - 1];
    }

    public void markPageStale(int type) {
        this.staleType = type;
    }

    public int getStaleType() {
        return this.staleType;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    protected IReportProvider getProvider() {
        return (IReportProvider)this.editor.getAdapter(IReportProvider.class);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.equals(ActionRegistry.class)) {
            return new ActionRegistry();
        }
        return super.getAdapter(adapter);
    }

    public void initialize(FormEditor editor) {
        this.editor = editor;
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public void setActive(boolean active) {
    }

    public boolean isActive() {
        return false;
    }

    public boolean canLeaveThePage() {
        this.handleLeaveThePage();
        return true;
    }

    public int getIndex() {
        return 0;
    }

    public void setIndex(int index) {
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        return false;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.parameterDialog != null) {
            this.parameterDialog.setUri(this.getFileUri());
        }
    }

    private Map<String, ?> getConfigVars() {
        HashMap<String, Object> configVars = new HashMap<String, Object>();
        String configFileName = this.getConfigFileName(this.getFileUri());
        if (configFileName == null) {
            return configVars;
        }
        ReportDesignHandle handle = null;
        try {
            SessionHandle sessionHandle = SessionHandleAdapter.getInstance().getSessionHandle();
            File configFile = new File(configFileName);
            if (configFile != null && configFile.exists() && configFile.isFile() && (handle = sessionHandle.openDesign(configFileName)) != null) {
                Iterator it = handle.configVariablesIterator();
                while (it != null && it.hasNext()) {
                    ConfigVariableHandle configVar = (ConfigVariableHandle)it.next();
                    if (configVar == null || configVar.getName() == null) continue;
                    String varName = this.prepareConfigVarName(configVar.getName());
                    String paramName = this.getParameterName(varName);
                    ScalarParameterHandle parameter = this.findParameter(paramName);
                    if (parameter != null) {
                        String typeVarName = varName + "_type_";
                        ConfigVariable typeVar = handle.findConfigVariable(typeVarName);
                        String dataType = null;
                        if (typeVar != null) {
                            dataType = typeVar.getValue();
                        }
                        if (dataType == null || !dataType.equalsIgnoreCase(parameter.getDataType())) continue;
                        String exprVarName = varName + "_expr_";
                        ConfigVariable exprVar = handle.findConfigVariable(exprVarName);
                        String expr = parameter.getValueExpr();
                        String cachedExpr = null;
                        if (exprVar != null) {
                            cachedExpr = exprVar.getValue();
                        }
                        if (cachedExpr == null) {
                            cachedExpr = "";
                        }
                        if (expr == null) {
                            expr = "";
                        }
                        if (!cachedExpr.equals(expr)) continue;
                    }
                    if (paramName == null || paramName.length() <= 0) continue;
                    if ("multi-value".equalsIgnoreCase(parameter.getParamType())) {
                        ArrayList<String> values = (ArrayList<String>)configVars.get(paramName);
                        if (values == null) {
                            values = new ArrayList<String>();
                            configVars.put(paramName, values);
                        }
                        values.add(configVar.getValue());
                        continue;
                    }
                    configVars.put(paramName, configVar.getValue());
                }
                handle.close();
            }
        }
        catch (DesignFileException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return configVars;
    }

    private String prepareConfigVarName(String name) {
        int index = name.lastIndexOf("_");
        return name.substring(0, index);
    }

    private String getParameterName(String configVarName) {
        String paramName = null;
        List parameters = null;
        ModuleHandle model = this.getModel();
        if (model != null) {
            parameters = model.getFlattenParameters();
        }
        if (parameters != null) {
            int i = 0;
            while (i < parameters.size()) {
                ScalarParameterHandle parameter = null;
                if (parameters.get(i) instanceof ScalarParameterHandle) {
                    parameter = (ScalarParameterHandle)parameters.get(i);
                }
                Object curName = null;
                if (parameter != null && parameter.getName() != null) {
                    curName = parameter.getName() + "_" + parameter.getID();
                }
                if (curName != null && ((String)curName).equalsIgnoreCase(configVarName)) {
                    paramName = parameter.getName();
                    break;
                }
                ++i;
            }
        }
        return paramName;
    }

    private ScalarParameterHandle findParameter(String paramName) {
        if (paramName == null) {
            return null;
        }
        ScalarParameterHandle parameter = null;
        List parameters = null;
        ModuleHandle model = this.getModel();
        if (model != null) {
            parameters = model.getFlattenParameters();
        }
        if (parameters != null) {
            int i = 0;
            while (i < parameters.size()) {
                if (parameters.get(i) instanceof ScalarParameterHandle) {
                    parameter = (ScalarParameterHandle)parameters.get(i);
                }
                if (parameter != null && paramName.equalsIgnoreCase(parameter.getName())) break;
                ++i;
            }
        }
        return parameter;
    }

    private boolean hasParameters() {
        IWebAppInfo webapp = WebViewer.getCurrentWebApp();
        if (webapp != null && webapp.useCustomParamHandling()) {
            return false;
        }
        ModuleHandle model = this.getModel();
        List parameters = model.getFlattenParameters();
        if (parameters != null) {
            for (Object p : parameters) {
                if (!(p instanceof ParameterHandle) || ((ParameterHandle)p).isHidden()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isMissingParameter() {
        IWebAppInfo webapp = WebViewer.getCurrentWebApp();
        if (webapp != null && webapp.useCustomParamHandling()) {
            return false;
        }
        boolean missingParameter = false;
        ModuleHandle model = this.getModel();
        Map<String, ?> params = this.getConfigVars();
        List parameters = model.getFlattenParameters();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.size()) {
                ScalarParameterHandle parameter;
                if (parameters.get(i) instanceof ScalarParameterHandle && !(parameter = (ScalarParameterHandle)parameters.get(i)).isHidden() && parameter.isRequired()) {
                    if (params == null) {
                        missingParameter = true;
                        break;
                    }
                    Object valueObj = params.get(parameter.getName());
                    if (valueObj == null) {
                        missingParameter = true;
                        break;
                    }
                    if (valueObj instanceof List) {
                        List values = (List)valueObj;
                        int j = 0;
                        while (j < values.size()) {
                            Object value = values.get(j);
                            if (value == null || "string".equalsIgnoreCase(parameter.getDataType()) && ((String)value).length() <= 0) {
                                missingParameter = true;
                                break;
                            }
                            ++j;
                        }
                        if (missingParameter) {
                            break;
                        }
                    } else if ("string".equalsIgnoreCase(parameter.getDataType()) && ((String)valueObj).length() <= 0) {
                        missingParameter = true;
                        break;
                    }
                }
                ++i;
            }
        }
        return missingParameter;
    }

    private String getConfigFileName(String reportDesignName) {
        if (reportDesignName == null) {
            return null;
        }
        String[] result = reportDesignName.split("\\.");
        String extensionName = result[result.length - 1];
        String configFileName = reportDesignName.substring(0, reportDesignName.length() - extensionName.length()) + SUFFIX_DESIGN_CONFIG;
        return configFileName;
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.editor.editorDirtyStateChanged();
        } else {
            super.firePropertyChange(type);
        }
    }

    protected void finalize() throws Throwable {
        if (Policy.TRACING_PAGE_CLOSE) {
            System.out.println("Report preview page finalized");
        }
        super.finalize();
    }

    public boolean isSensitivePartChange() {
        return false;
    }
}

