/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.i18n.AdapterResourceHandle;
import org.eclipse.birt.report.data.adapter.impl.DataRequestSessionImpl;

public class TimeDimensionDatasetIterator
implements IDatasetIterator {
    private Calendar calendar;
    private Date endTime;
    private boolean firstNext;
    private String[] fieldName;
    private String[] timeType;

    TimeDimensionDatasetIterator(DataRequestSessionImpl session, Date startTime, Date endTime, String[] fieldName, String[] timeType) throws AdapterException {
        try {
            if (startTime != null) {
                this.calendar = Calendar.getInstance((ULocale)session.getDataSessionContext().getDataEngineContext().getLocale());
                this.calendar.setTimeZone(session.getDataSessionContext().getDataEngineContext().getTimeZone());
                this.calendar.clear();
                this.calendar.setTime(startTime);
            }
            this.endTime = endTime;
            this.fieldName = fieldName;
            this.timeType = timeType;
            this.firstNext = false;
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    protected Object getValue(String timeType, Object d) throws BirtException {
        if ("day-of-month".equals(timeType)) {
            return new Integer(this.getCalendar(d).get(5));
        }
        if ("day-of-week".equals(timeType)) {
            return new Integer(this.getCalendar(d).get(7));
        }
        if ("day-of-year".equals(timeType)) {
            return new Integer(this.getCalendar(d).get(6));
        }
        if ("week-of-month".equals(timeType)) {
            return new Integer(this.getCalendar(d).get(4));
        }
        if ("week-of-year".equals(timeType)) {
            return new Integer(this.getCalendar(d).get(3));
        }
        if ("month".equals(timeType)) {
            return new Integer(this.getCalendar(d).get(2) + 1);
        }
        if ("quarter".equals(timeType)) {
            int month = this.getCalendar(d).get(2);
            int quarter = -1;
            switch (month) {
                case 0: 
                case 1: 
                case 2: {
                    quarter = 1;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    quarter = 2;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    quarter = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    quarter = 4;
                    break;
                }
                default: {
                    quarter = -1;
                }
            }
            return new Integer(quarter);
        }
        if ("year".equals(timeType)) {
            return new Integer(this.getCalendar(d).get(1));
        }
        if ("hour".equals(timeType)) {
            return new Integer(this.getCalendar(d).get(11));
        }
        if ("minute".equals(timeType)) {
            return new Integer(this.getCalendar(d).get(12));
        }
        if ("second".equals(timeType)) {
            return this.getCalendar(d).get(13);
        }
        throw new AdapterException("adapter.invalid.datetimetype", timeType);
    }

    private Calendar getCalendar(Object d) {
        assert (d != null);
        try {
            Date date = DataTypeUtil.toDate((Object)d);
            this.calendar.setTime(date);
            return this.calendar;
        }
        catch (BirtException e) {
            throw new IllegalArgumentException(AdapterResourceHandle.getInstance().getMessage("invalid.datetime.value"));
        }
    }

    public void close() throws BirtException {
    }

    public int getFieldIndex(String name) throws BirtException {
        int i = 0;
        while (i < this.fieldName.length) {
            if (this.fieldName[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getFieldType(String name) throws BirtException {
        int i = 0;
        while (i < this.fieldName.length) {
            if (this.fieldName[i].equals(name)) {
                return 2;
            }
            ++i;
        }
        return 6;
    }

    public Object getValue(int fieldIndex) throws BirtException {
        if (fieldIndex == -1) {
            return this.calendar.getTime();
        }
        return this.getValue(this.timeType[fieldIndex], this.calendar.getTime());
    }

    public boolean next() throws BirtException {
        if (this.calendar == null || this.endTime == null) {
            return false;
        }
        if (!this.firstNext) {
            this.firstNext = true;
            return true;
        }
        this.nextValue(this.timeType[this.timeType.length - 1]);
        return this.endTime.compareTo(this.calendar.getTime()) >= 0;
    }

    private void nextValue(String timeType) {
        if ("day-of-month".equals(timeType)) {
            this.calendar.add(5, 1);
        } else if ("day-of-week".equals(timeType)) {
            this.calendar.add(7, 1);
        } else if ("day-of-year".equals(timeType)) {
            this.calendar.add(6, 1);
        } else if ("week-of-month".equals(timeType)) {
            this.calendar.add(4, 1);
        } else if ("week-of-year".equals(timeType)) {
            this.calendar.add(3, 1);
        } else if ("month".equals(timeType)) {
            this.calendar.add(2, 1);
        } else if ("quarter".equals(timeType)) {
            this.calendar.add(5, 3);
        } else if ("year".equals(timeType)) {
            this.calendar.add(1, 1);
        } else if ("hour".equals(timeType)) {
            this.calendar.add(11, 1);
        } else if ("minute".equals(timeType)) {
            this.calendar.add(12, 1);
        } else if ("second".equals(timeType)) {
            this.calendar.add(13, 1);
        }
    }
}

