/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;

public abstract class BaseQuery
implements IQuery {
    private IQuery.SortSpec[] sorts = new IQuery.SortSpec[0];
    private IQuery.GroupSpec[] groups = new IQuery.GroupSpec[0];
    private int maxRows = 0;
    private int rowFetchLimit = 0;
    private List<IResultObjectEvent> fetchEventList = null;
    private IExpressionProcessor exprProcessor;
    private boolean distinctValueFlag;
    private IBaseQueryDefinition queryDefinition;

    @Override
    public void setOrdering(List<IQuery.SortSpec> sortSpecs) throws DataException {
        this.sorts = sortSpecs == null ? new IQuery.SortSpec[0] : sortSpecs.toArray(new IQuery.SortSpec[0]);
    }

    @Override
    public void setGrouping(List<IQuery.GroupSpec> groupSpecs) throws DataException {
        this.groups = groupSpecs == null ? new IQuery.GroupSpec[0] : groupSpecs.toArray(new IQuery.GroupSpec[0]);
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void setRowFetchLimit(int limit) {
        this.rowFetchLimit = limit > 0 ? limit : 0;
    }

    protected int getRowFetchLimit() {
        return this.rowFetchLimit;
    }

    public IQuery.SortSpec[] getOrdering() {
        return this.sorts;
    }

    public IQuery.GroupSpec[] getGrouping() {
        return this.groups;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void addOnFetchEvent(IResultObjectEvent event) {
        assert (event != null);
        if (this.fetchEventList == null) {
            this.fetchEventList = new ArrayList<IResultObjectEvent>();
        }
        this.fetchEventList.add(event);
    }

    public List<IResultObjectEvent> getFetchEvents() {
        return this.fetchEventList;
    }

    @Override
    public void setExprProcessor(IExpressionProcessor exprProcessor) {
        this.exprProcessor = exprProcessor;
    }

    public IExpressionProcessor getExprProcessor() {
        return this.exprProcessor;
    }

    public boolean getDistinctValueFlag() {
        return this.distinctValueFlag;
    }

    @Override
    public void setDistinctValueFlag(boolean distinctValueFlag) {
        this.distinctValueFlag = distinctValueFlag;
    }

    @Override
    public void setQueryDefinition(IBaseQueryDefinition queryDefn) {
        this.queryDefinition = queryDefn;
    }

    @Override
    public IBaseQueryDefinition getQueryDefinition() {
        return this.queryDefinition;
    }
}

