/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config.docx;

import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.emitter.config.AbstractConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.AbstractEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.ConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IOptionValue;
import org.eclipse.birt.report.engine.emitter.config.OptionValue;
import org.eclipse.birt.report.engine.emitter.config.docx.i18n.Messages;

public class DocxEmitterDescriptor
extends AbstractEmitterDescriptor {
    protected static final String CHART_DPI = "ChartDpi";
    protected static final String EMBED_HTML = "EmbedHtml";
    protected static final String WORD_VERSION = "WordVersion";

    protected void initOptions() {
        this.loadDefaultValues("org.eclipse.birt.report.engine.emitter.config.docx");
        ConfigurableOption chartDpi = new ConfigurableOption(CHART_DPI);
        chartDpi.setDisplayName(this.getMessage("OptionDisplayValue.ChartDpi"));
        chartDpi.setDataType(IConfigurableOption.DataType.INTEGER);
        chartDpi.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        chartDpi.setDefaultValue((Object)192);
        chartDpi.setToolTip(this.getMessage("Tooltip.ChartDpi"));
        chartDpi.setDescription(this.getMessage("OptionDescription.ChartDpi"));
        ConfigurableOption embedHtml = new ConfigurableOption(EMBED_HTML);
        embedHtml.setDisplayName(this.getMessage("OptionDisplayValue.EmbedHtml"));
        embedHtml.setDataType(IConfigurableOption.DataType.BOOLEAN);
        embedHtml.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        embedHtml.setDefaultValue((Object)true);
        embedHtml.setToolTip(this.getMessage("Tooltip.EmbedHtml"));
        embedHtml.setDescription(this.getMessage("OptionDescription.EmbedHtml"));
        ConfigurableOption wordVersion = new ConfigurableOption(WORD_VERSION);
        wordVersion.setDisplayName(this.getMessage("OptionDisplayValue.WordVersion"));
        wordVersion.setDataType(IConfigurableOption.DataType.INTEGER);
        wordVersion.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        wordVersion.setDefaultValue((Object)2016);
        IOptionValue[] choices = new IOptionValue[]{new OptionValue((Object)2010), new OptionValue((Object)2016)};
        wordVersion.setChoices(choices);
        wordVersion.setToolTip(this.getMessage("Tooltip.WordVersion"));
        wordVersion.setDescription(this.getMessage("OptionDescription.WordVersion"));
        this.options = new IConfigurableOption[]{chartDpi, embedHtml, wordVersion};
        this.applyDefaultValues();
    }

    public IConfigurableOptionObserver createOptionObserver() {
        return new DocxOptionObserver();
    }

    private String getMessage(String key) {
        return Messages.getString(key, this.locale);
    }

    public String getDescription() {
        return this.getMessage("DocxEmitter.Description");
    }

    public String getDisplayName() {
        return this.getMessage("DocxEmitter.DisplayName");
    }

    public String getID() {
        return "org.eclipse.birt.report.engine.emitter.docx";
    }

    public String getRenderOptionName(String name) {
        assert (name != null);
        if (CHART_DPI.equals(name)) {
            return CHART_DPI;
        }
        if (EMBED_HTML.equals(name)) {
            return EMBED_HTML;
        }
        if (WORD_VERSION.equals(name)) {
            return WORD_VERSION;
        }
        return name;
    }

    class DocxOptionObserver
    extends AbstractConfigurableOptionObserver {
        DocxOptionObserver() {
        }

        public IConfigurableOption[] getOptions() {
            return DocxEmitterDescriptor.this.options;
        }

        public IRenderOption getPreferredRenderOption() {
            RenderOption renderOption = new RenderOption();
            renderOption.setEmitterID(DocxEmitterDescriptor.this.getID());
            renderOption.setOutputFormat("docx");
            if (this.values != null && this.values.length > 0) {
                IOptionValue[] iOptionValueArray = this.values;
                int n = this.values.length;
                int n2 = 0;
                while (n2 < n) {
                    IOptionValue optionValue = iOptionValueArray[n2];
                    if (optionValue != null) {
                        renderOption.setOption(DocxEmitterDescriptor.this.getRenderOptionName(optionValue.getName()), optionValue.getValue());
                    }
                    ++n2;
                }
            }
            return renderOption;
        }
    }
}

