/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.command;

import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;

public class NameException
extends SemanticException {
    private static final long serialVersionUID = -657245298064464513L;
    protected String name = null;
    public static final String DESIGN_EXCEPTION_NAME_REQUIRED = "Error.NameException.NAME_REQUIRED";
    public static final String DESIGN_EXCEPTION_NAME_FORBIDDEN = "Error.NameException.NAME_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_DUPLICATE = "Error.NameException.DUPLICATE";
    public static final String DESIGN_EXCEPTION_HAS_REFERENCES = "Error.NameException.HAS_REFERENCES";
    @Deprecated
    public static final String DESIGN_EXCEPTION_DOT_FORBIDDEN = "Error.NameException.INVALID_NAME";
    public static final String DESIGN_EXCEPTION_INVALID_NAME = "Error.NameException.INVALID_NAME";
    public static final String DESIGN_EXCEPTION_INVALID_STYLE_NAME = "Error.NameException.INVALID_STYLE_NAME";

    public NameException(DesignElement obj, String str, String errCode) {
        super(obj, errCode);
        this.name = str;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getLocalizedMessage() {
        if (this.sResourceKey == DESIGN_EXCEPTION_NAME_REQUIRED || this.sResourceKey == DESIGN_EXCEPTION_NAME_FORBIDDEN) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{this.element.getIdentifier()});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_DUPLICATE) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{this.name});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_HAS_REFERENCES) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{NameException.getElementName(this.element)});
        }
        if (this.sResourceKey == "Error.NameException.INVALID_NAME" || this.sResourceKey == DESIGN_EXCEPTION_INVALID_STYLE_NAME) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{this.name});
        }
        return ModelMessages.getMessage(this.sResourceKey);
    }
}

