/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.cursor.DimensionTraverse;
import org.eclipse.birt.data.engine.olap.cursor.EdgeTraverse;
import org.eclipse.birt.data.engine.olap.cursor.IRowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessorService;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;

public class SubRowDataAccessor
extends RowDataAccessor {
    private int startingLevel = -1;
    private int edgeStart = 0;
    private int edgeEnd = 0;
    private RowDataAccessor parentNavigator;
    private IAggregationResultSet rs;
    private RowDataAccessorService service;

    public SubRowDataAccessor(RowDataAccessorService service, IRowDataAccessor parentNavigator, int startingLevel) throws IOException {
        super(service, parentNavigator.getAggregationResultSet());
        this.parentNavigator = (RowDataAccessor)parentNavigator;
        this.startingLevel = startingLevel;
        this.service = service;
        this.rs = parentNavigator.getAggregationResultSet();
    }

    @Override
    public void initialize(boolean isPage) throws IOException {
        if (this.startingLevel < 0) {
            this.edgeStart = 0;
            this.edgeEnd = this.parentNavigator.edgeDimensRelation.traverseLength - 1;
        } else {
            this.edgeStart = this.parentNavigator.getEdgeStart(this.startingLevel);
            this.edgeEnd = this.parentNavigator.getEdgeEnd(this.startingLevel);
        }
        this.edgeDimensRelation = this.parentNavigator.edgeDimensRelation;
        this.dimTraverse = new DimensionTraverse(this.service.getDimensionAxis(), this.parentNavigator.edgeDimensRelation, this.edgeStart, this.edgeEnd);
        this.dimTraverse.first();
        this.edgeTraverse = new EdgeTraverse(this.parentNavigator.edgeDimensRelation, this.edgeStart, this.edgeEnd);
    }

    @Override
    public boolean edge_relative(int arg0) throws OLAPException {
        if (arg0 == 0) {
            return true;
        }
        int position = this.edgeTraverse.currentPosition + arg0;
        if (position >= this.edgeDimensRelation.traverseLength) {
            this.edge_afterLast();
            return false;
        }
        if (position < 0) {
            this.dimTraverse.beforeFirst();
            this.edgeTraverse.currentPosition = -1;
            return false;
        }
        int i = 0;
        while (i < Math.abs(arg0)) {
            if (arg0 > 0) {
                this.edge_next();
            } else {
                this.edge_previous();
            }
            ++i;
        }
        return true;
    }
}

