/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.model.core.DesignElement;

public class NameSpace
implements Cloneable {
    protected HashMap<String, DesignElement> names = new LinkedHashMap<String, DesignElement>(12);

    public void insert(DesignElement element) {
        assert (element.getName() != null);
        assert (this.names.get(element.getName()) == null);
        this.names.put(element.getName(), element);
    }

    public void insert(String name, DesignElement element) {
        this.names.put(name, element);
    }

    public void remove(DesignElement element) {
        assert (element.getName() != null);
        assert (this.names.get(element.getName()) == element);
        this.names.remove(element.getName());
    }

    public void remove(String name) {
        this.names.remove(name);
    }

    public void rename(DesignElement element, String oldName, String newName) {
        if (oldName != null) {
            assert (this.names.get(oldName) == element);
            this.names.remove(oldName);
        }
        if (newName != null) {
            assert (this.names.get(newName) == null);
            this.names.put(newName, element);
        }
    }

    public boolean contains(String name) {
        return this.names.containsKey(name);
    }

    public DesignElement getElement(String name) {
        return this.names.get(name);
    }

    public final int getCount() {
        return this.names.size();
    }

    public final List<DesignElement> getElements() {
        return new ArrayList<DesignElement>(this.names.values());
    }

    public final Object clone() throws CloneNotSupportedException {
        NameSpace ns = (NameSpace)super.clone();
        ns.names = new LinkedHashMap<String, DesignElement>(12);
        return ns;
    }
}

