/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.core.framework.URLClassLoader;
import org.eclipse.birt.data.oda.pojo.api.IPojoDataSet;
import org.eclipse.birt.data.oda.pojo.impl.ResultSetMetaData;
import org.eclipse.birt.data.oda.pojo.impl.internal.ResultSetFromPojoInstance;
import org.eclipse.birt.data.oda.pojo.querymodel.PojoQuery;
import org.eclipse.birt.data.oda.pojo.util.DataTypeUtil;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSet
implements IResultSet {
    private int maxRows;
    private int currentRowId;
    private PojoQuery query;
    private IPojoDataSet pojoDataSet;
    private URLClassLoader pojoClassLoader;
    private ResultSetFromPojoInstance subResultSet;
    private Object columnValue;

    public ResultSet(PojoQuery query, IPojoDataSet pojoDataSet, URLClassLoader pojoClassLoader) throws OdaException {
        assert (query != null && pojoDataSet != null && pojoClassLoader != null);
        this.query = query;
        this.pojoDataSet = pojoDataSet;
        this.pojoClassLoader = pojoClassLoader;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return new ResultSetMetaData(this.query.getReferenceGraph());
    }

    public void setMaxRows(int max) throws OdaException {
        this.maxRows = max > 0 ? max : 0;
    }

    protected int getMaxRows() {
        return this.maxRows;
    }

    public boolean next() throws OdaException {
        Object pojo;
        if (this.maxRows > 0 && this.currentRowId >= this.maxRows) {
            this.subResultSet = null;
            return false;
        }
        if (this.subResultSet == null) {
            pojo = this.pojoDataSet.next();
            if (pojo == null) {
                this.subResultSet = null;
                return false;
            }
            this.subResultSet = new ResultSetFromPojoInstance(pojo, this.query, this.pojoClassLoader);
        }
        if (this.subResultSet.next()) {
            ++this.currentRowId;
            return true;
        }
        pojo = this.pojoDataSet.next();
        if (pojo == null) {
            this.subResultSet = null;
            return false;
        }
        this.subResultSet = new ResultSetFromPojoInstance(pojo, this.query, this.pojoClassLoader);
        this.subResultSet.next();
        ++this.currentRowId;
        return true;
    }

    public void close() throws OdaException {
        this.currentRowId = 0;
        if (this.pojoDataSet != null) {
            this.pojoDataSet.close();
        }
    }

    public int getRow() throws OdaException {
        return this.currentRowId;
    }

    public String getString(int index) throws OdaException {
        return DataTypeUtil.toString(this.getColumnValue(index));
    }

    public String getString(String columnName) throws OdaException {
        return this.getString(this.findColumn(columnName));
    }

    public int getInt(int index) throws OdaException {
        return DataTypeUtil.toInt(this.getColumnValue(index));
    }

    public int getInt(String columnName) throws OdaException {
        return this.getInt(this.findColumn(columnName));
    }

    public double getDouble(int index) throws OdaException {
        return DataTypeUtil.toDouble(this.getColumnValue(index));
    }

    public double getDouble(String columnName) throws OdaException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        return DataTypeUtil.toBigDecimal(this.getColumnValue(index));
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Date getDate(int index) throws OdaException {
        return DataTypeUtil.toDate(this.getColumnValue(index));
    }

    public Date getDate(String columnName) throws OdaException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int index) throws OdaException {
        return DataTypeUtil.toTime(this.getColumnValue(index));
    }

    public Time getTime(String columnName) throws OdaException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        return DataTypeUtil.toTimestamp(this.getColumnValue(index));
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        return DataTypeUtil.toBlob(this.getColumnValue(index));
    }

    public IBlob getBlob(String columnName) throws OdaException {
        return this.getBlob(this.findColumn(columnName));
    }

    public IClob getClob(int index) throws OdaException {
        return DataTypeUtil.toClob(this.getColumnValue(index));
    }

    public IClob getClob(String columnName) throws OdaException {
        return this.getClob(this.findColumn(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        return DataTypeUtil.toBoolean(this.getColumnValue(index));
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public Object getObject(int index) throws OdaException {
        return this.getColumnValue(index);
    }

    public Object getObject(String columnName) throws OdaException {
        return this.getObject(this.findColumn(columnName));
    }

    public boolean wasNull() throws OdaException {
        return this.columnValue == null;
    }

    public int findColumn(String columnName) throws OdaException {
        return this.query.getReferenceGraph().findColumn(columnName);
    }

    public Object getColumnValue(int index) throws OdaException {
        this.columnValue = null;
        if (this.subResultSet != null) {
            this.columnValue = this.subResultSet.getColumnValue(index);
        }
        return this.columnValue;
    }
}

