/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalMedian
extends AggrFunction {
    @Override
    public String getName() {
        return "MEDIAN";
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalMedian.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalMedian.displayName");
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private List list;
        private Object ret = null;

        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        @Override
        public void start() {
            super.start();
            this.list = new ArrayList();
            this.ret = null;
        }

        @Override
        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (args[0] != null) {
                this.list.add(this.calculator.getTypedObject(args[0]));
            }
        }

        @Override
        public void finish() throws DataException {
            int size = this.list.size();
            if (size > 0) {
                Object[] values = this.list.toArray();
                Arrays.sort(values);
                if (size % 2 == 0) {
                    Object d1 = values[size / 2 - 1];
                    Object d2 = values[size / 2];
                    this.ret = this.calculator.divide(this.calculator.add(this.calculator.getTypedObject(d1), this.calculator.getTypedObject(d2)), this.calculator.getTypedObject(2));
                } else {
                    this.ret = this.calculator.getTypedObject(values[size / 2]);
                }
            }
            super.finish();
        }

        @Override
        public Object getSummaryValue() {
            return this.ret;
        }
    }
}

