/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.render;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.extension.datafeed.GanttEntry;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.data.GanttDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.IAxesDecorator;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;

public final class Gantt
extends AxesRenderer
implements IAxesDecorator {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine.extension/render");

    @Override
    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        Fill fLineFill;
        int iThisSeriesIndex;
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        if (cwa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.gantt.dimension", new Object[]{cwa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        logger.log(1, Messages.getString("info.render.series", new Object[]{this.getClass().getName(), this.iSeriesIndex + 1, this.iSeriesCount}, this.getRunTimeContext().getULocale()));
        GanttSeries gs = (GanttSeries)this.getSeries();
        if (!gs.isVisible()) {
            this.restoreClipping(ipr);
            return;
        }
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        DataPointHints[] dpha = srh.getDataPoints();
        LineAttributes lia = goFactory.copyOf(gs.getConnectionLine());
        LineAttributes outlinelia = gs.getOutline();
        int iLineWidth = lia.getThickness();
        Marker mStart = gs.getStartMarker();
        Marker mEnd = gs.getEndMarker();
        boolean bTransposed = this.isTransposed();
        float[] faX = new float[dpha.length];
        float[][] faY = new float[dpha.length][2];
        Location loStart = null;
        Location loEnd = null;
        Location[] loaLine = null;
        SeriesDefinition sd = this.getSeriesDefinition();
        EList<Fill> elPalette = sd.getSeriesPalette().getEntries();
        if (elPalette.isEmpty()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{gs}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && gs.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)gs.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(gs)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{gs, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            fPaletteEntry = FillUtil.getPaletteFill(elPalette, iThisSeriesIndex);
            this.updateTranslucency(fPaletteEntry, gs);
        }
        if (gs.isPaletteLineColor()) {
            fLineFill = fPaletteEntry;
            lia.setColor(FillUtil.getColor(fPaletteEntry));
        } else {
            Fill outlineFill = gs.getOutlineFill();
            Fill fill = fLineFill = lia.getColor() == null ? outlineFill : lia.getColor();
            if (outlineFill != null) {
                lia.setColor(FillUtil.getColor(outlineFill));
            }
        }
        this.renderClipping(ipr, this.getPlotBounds());
        AutoScale scale = this.getInternalOrthogonalAxis().getScale();
        int i = 0;
        while (i < dpha.length) {
            GanttEntry ge = (GanttEntry)dpha[i].getOrthogonalValue();
            if (this.isValidGanttEntry(ge)) {
                PolygonRenderEvent pre;
                if (this.checkEntryInRange(this.se, scale.getMinimum(), scale.getMaximum()) > 0) {
                    dpha[i].markOutside();
                }
                CDateTime geStart = ge.getStart();
                CDateTime geEnd = ge.getEnd();
                double dX = 0.0;
                double dY = 0.0;
                double dStart = 0.0;
                double dEnd = 0.0;
                Location lo = dpha[i].getLocation();
                dX = (int)lo.getX();
                dY = (int)lo.getY();
                if (srh.isCategoryScale()) {
                    double fSize = dpha[i].getSize();
                    if (bTransposed) {
                        dY += fSize / 2.0;
                    } else {
                        dX += fSize / 2.0;
                    }
                }
                if (geStart != null) {
                    dStart = srh.getLocationOnOrthogonal((Object)geStart);
                }
                dEnd = geEnd != null ? srh.getLocationOnOrthogonal((Object)geEnd) : dStart;
                if (geStart == null) {
                    dStart = dEnd;
                }
                if (loStart == null) {
                    loStart = goFactory.createLocation(0.0, 0.0);
                    loEnd = goFactory.createLocation(0.0, 0.0);
                }
                if (cwa.isTransposed()) {
                    loStart.set(dStart, dY);
                    loEnd.set(dEnd, dY);
                    faX[i] = (float)dY;
                    faY[i][0] = (float)dStart;
                    faY[i][1] = (float)dEnd;
                    loaLine = new Location[]{goFactory.createLocation(dStart, dY + (double)iLineWidth / 2.0), goFactory.createLocation(dStart, dY - (double)iLineWidth / 2.0), goFactory.createLocation(dEnd, dY - (double)iLineWidth / 2.0), goFactory.createLocation(dEnd, dY + (double)iLineWidth / 2.0)};
                } else {
                    loStart.set(dX, dStart);
                    loEnd.set(dX, dEnd);
                    faX[i] = (float)dX;
                    faY[i][0] = (float)dStart;
                    faY[i][1] = (float)dEnd;
                    loaLine = new Location[]{goFactory.createLocation(dX + (double)iLineWidth / 2.0, dStart), goFactory.createLocation(dX - (double)iLineWidth / 2.0, dStart), goFactory.createLocation(dX - (double)iLineWidth / 2.0, dEnd), goFactory.createLocation(dX + (double)iLineWidth / 2.0, dEnd)};
                }
                fPaletteEntry = bPaletteByCategory ? FillUtil.getPaletteFill(elPalette, i) : FillUtil.getPaletteFill(elPalette, iThisSeriesIndex);
                this.updateTranslucency(fPaletteEntry, gs);
                ScriptHandler.callFunction(sh, "beforeDrawDataPoint", dpha[i], fPaletteEntry, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", dpha[i]);
                if (lia.isVisible() && geStart != null && geEnd != null) {
                    if (gs.isPaletteLineColor()) {
                        fLineFill = fPaletteEntry;
                        lia.setColor(FillUtil.getColor(fPaletteEntry));
                    }
                    if (iLineWidth == 1 || lia.getStyle() != LineStyle.SOLID_LITERAL) {
                        LineRenderEvent lre = ((EventObjectCache)((Object)ipr)).getEventObject(WrappedStructureSource.createSeriesDataPoint(gs, dpha[i]), LineRenderEvent.class);
                        lre.setLineAttributes(lia);
                        lre.setStart(loStart);
                        lre.setEnd(loEnd);
                        ipr.drawLine(lre);
                        this.renderInteractivity(ipr, dpha[i], lre);
                    } else {
                        pre = ((EventObjectCache)((Object)ipr)).getEventObject(WrappedStructureSource.createSeriesDataPoint(gs, dpha[i]), PolygonRenderEvent.class);
                        pre.setPoints(loaLine);
                        pre.setBackground(fLineFill);
                        ipr.fillPolygon(pre);
                        this.renderInteractivity(ipr, dpha[i], pre);
                    }
                }
                if (outlinelia.isVisible() && geStart != null && geEnd != null) {
                    pre = ((EventObjectCache)((Object)ipr)).getEventObject(WrappedStructureSource.createSeriesDataPoint(gs, dpha[i]), PolygonRenderEvent.class);
                    pre.setPoints(loaLine);
                    pre.setOutline(outlinelia);
                    ipr.drawPolygon(pre);
                }
                if (geStart != null && mStart.isVisible() || dpha[i].isOutside()) {
                    Location loStartMarker = loStart.copyInstance();
                    Position mStartPosition = this.transposePosition(gs.getStartMarkerPosition());
                    switch (mStartPosition.getValue()) {
                        case 0: {
                            if (!bTransposed) break;
                            loStartMarker.set(loStart.getX(), loStart.getY() - (double)mStart.getSize());
                            break;
                        }
                        case 1: {
                            if (!bTransposed) break;
                            loStartMarker.set(loStart.getX(), loStart.getY() + (double)mStart.getSize());
                        }
                    }
                    Fill startFill = fPaletteEntry;
                    if (fPaletteEntry instanceof MultipleFill && ((MultipleFill)fPaletteEntry).getFills().size() > 0) {
                        startFill = (Fill)((MultipleFill)fPaletteEntry).getFills().get(0);
                    }
                    this.renderMarker(gs, ipr, mStart, loStartMarker, outlinelia, startFill, dpha[i], null, true, false);
                }
                if (geEnd != null && mEnd.isVisible() || dpha[i].isOutside()) {
                    Location loEndMarker = loEnd.copyInstance();
                    Position mEndPosition = this.transposePosition(gs.getEndMarkerPosition());
                    switch (mEndPosition.getValue()) {
                        case 0: {
                            if (!bTransposed) break;
                            loEndMarker.set(loEnd.getX(), loEnd.getY() - (double)mEnd.getSize());
                            break;
                        }
                        case 1: {
                            if (!bTransposed) break;
                            loEndMarker.set(loEnd.getX(), loEnd.getY() + (double)mEnd.getSize());
                        }
                    }
                    Fill endFill = fPaletteEntry;
                    if (fPaletteEntry instanceof MultipleFill && ((MultipleFill)fPaletteEntry).getFills().size() > 1) {
                        endFill = (Fill)((MultipleFill)fPaletteEntry).getFills().get(1);
                    }
                    this.renderMarker(gs, ipr, mEnd, loEndMarker, outlinelia, endFill, dpha[i], null, true, false);
                }
                ScriptHandler.callFunction(sh, "afterDrawDataPoint", dpha[i], fPaletteEntry, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", dpha[i]);
            }
            ++i;
        }
        Label laDataPoint = srh.getLabelAttributes(gs);
        if (laDataPoint.isVisible()) {
            Position pDataPoint = srh.getLabelPosition(gs);
            Location loDataPoint = goFactory.createLocation(0.0, 0.0);
            boolean useDecorationLabel = gs.isUseDecorationLabelValue();
            double dLabelGap = Math.max(Math.max(mStart.isVisible() ? mStart.getSize() : 0, mEnd.isVisible() ? mEnd.getSize() : 0), (lia.isVisible() ? iLineWidth / 2 : 0) + (outlinelia.isVisible() ? outlinelia.getThickness() : 0));
            int i2 = 0;
            while (i2 < dpha.length) {
                GanttEntry ge = (GanttEntry)dpha[i2].getOrthogonalValue();
                if (ge != null && ge.getStart() != null && ge.getEnd() != null && this.isValidGanttEntry(ge) && !dpha[i2].isOutside()) {
                    if (useDecorationLabel) {
                        laDataPoint.getCaption().setValue(ge.getLabel());
                    } else {
                        laDataPoint.getCaption().setValue(dpha[i2].getDisplayValue());
                    }
                    switch (pDataPoint.getValue()) {
                        case 0: {
                            if (!cwa.isTransposed()) {
                                loDataPoint.set(faX[i2], faY[i2][1] - (float)mEnd.getSize() - (float)p.getVerticalSpacing());
                                break;
                            }
                            loDataPoint.set((faY[i2][0] + faY[i2][1]) / 2.0f, (double)faX[i2] - dLabelGap - (double)p.getVerticalSpacing());
                            break;
                        }
                        case 1: {
                            if (!cwa.isTransposed()) {
                                loDataPoint.set(faX[i2], faY[i2][0] + (float)mStart.getSize() + (float)p.getVerticalSpacing());
                                break;
                            }
                            loDataPoint.set((faY[i2][0] + faY[i2][1]) / 2.0f, (double)faX[i2] + dLabelGap + (double)p.getVerticalSpacing());
                            break;
                        }
                        case 2: {
                            if (!cwa.isTransposed()) {
                                loDataPoint.set((double)faX[i2] - dLabelGap - (double)p.getHorizontalSpacing(), (faY[i2][0] + faY[i2][1]) / 2.0f);
                                break;
                            }
                            loDataPoint.set((double)faY[i2][0] - dLabelGap - (double)p.getHorizontalSpacing(), faX[i2]);
                            break;
                        }
                        case 3: {
                            if (!cwa.isTransposed()) {
                                loDataPoint.set((double)faX[i2] + dLabelGap + (double)p.getHorizontalSpacing(), (faY[i2][0] + faY[i2][1]) / 2.0f);
                                break;
                            }
                            loDataPoint.set((double)faY[i2][1] + dLabelGap + (double)p.getHorizontalSpacing(), faX[i2]);
                            break;
                        }
                        case 4: {
                            if (!cwa.isTransposed()) {
                                loDataPoint.set(faX[i2], (faY[i2][0] + faY[i2][1]) / 2.0f);
                                break;
                            }
                            loDataPoint.set((faY[i2][0] + faY[i2][1]) / 2.0f, faX[i2]);
                            break;
                        }
                        default: {
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.gantt", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                    }
                    ScriptHandler.callFunction(sh, "beforeDrawDataPointLabel", dpha[i2], laDataPoint, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", laDataPoint);
                    if (laDataPoint.isVisible()) {
                        this.renderLabel(WrappedStructureSource.createSeriesDataPoint(gs, dpha[i2]), 2, laDataPoint, pDataPoint, loDataPoint, null);
                    }
                    ScriptHandler.callFunction(sh, "afterDrawDataPointLabel", dpha[i2], laDataPoint, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", laDataPoint);
                }
                ++i2;
            }
        }
        this.restoreClipping(ipr);
    }

    @Override
    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        Marker mEnd;
        double height;
        double width;
        int markerSize;
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        ClientArea ca = lg.getClientArea();
        LineAttributes lia = ca.getOutline();
        GanttSeries gs = (GanttSeries)this.getSeries();
        RectangleRenderEvent rre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createLegend(lg), RectangleRenderEvent.class);
        rre.setBackground(ca.getBackground());
        rre.setOutline(lia);
        rre.setBounds(bo);
        ipr.fillRectangle(rre);
        LineAttributes liaMarker = gs.getConnectionLine();
        LineAttributes outlinelia = gs.getOutline();
        PolygonRenderEvent pre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createLegend(lg), PolygonRenderEvent.class);
        Location[] points = new Location[]{goFactory.createLocation(bo.getLeft() + 1.0, bo.getTop() + bo.getHeight() / 2.0 + (double)liaMarker.getThickness() / 2.0), goFactory.createLocation(bo.getLeft() + bo.getWidth() - 1.0, bo.getTop() + bo.getHeight() / 2.0 + (double)liaMarker.getThickness() / 2.0), goFactory.createLocation(bo.getLeft() + bo.getWidth() - 1.0, bo.getTop() + bo.getHeight() / 2.0 - (double)liaMarker.getThickness() / 2.0), goFactory.createLocation(bo.getLeft() + 1.0, bo.getTop() + bo.getHeight() / 2.0 - (double)liaMarker.getThickness() / 2.0)};
        pre.setPoints(points);
        pre.setOutline(outlinelia);
        if (liaMarker.isVisible()) {
            if (gs.isPaletteLineColor()) {
                liaMarker = goFactory.copyOf(liaMarker);
                liaMarker.setColor(FillUtil.getColor(fPaletteEntry));
                pre.setBackground(fPaletteEntry);
            } else {
                Fill outlineFill = gs.getOutlineFill();
                Fill fLineFill = liaMarker.getColor() == null ? outlineFill : liaMarker.getColor();
                lia.setColor(FillUtil.getColor(outlineFill));
                pre.setBackground(fLineFill);
            }
            ipr.fillPolygon(pre);
        }
        if (outlinelia.isVisible()) {
            ipr.drawPolygon(pre);
        }
        if ((markerSize = (int)((((width = bo.getWidth() / this.getDeviceScale()) > (height = bo.getHeight() / this.getDeviceScale()) ? height : width) - 2.0) / 2.0)) <= 0) {
            markerSize = 1;
        }
        Marker mStart = gs.getStartMarker();
        DataPointHints dph = this.createDummyDataPointHintsForLegendItem();
        if (mStart != null && mStart.isVisible()) {
            Location loStartMarker = goFactory.createLocation(bo.getLeft() + 1.0, bo.getTop() + bo.getHeight() / 2.0);
            Position mStartPosition = this.transposePosition(gs.getStartMarkerPosition());
            switch (mStartPosition.getValue()) {
                case 0: {
                    if (!this.isTransposed()) break;
                    loStartMarker.set(loStartMarker.getX(), loStartMarker.getY() - (double)markerSize);
                    break;
                }
                case 1: {
                    if (!this.isTransposed()) break;
                    loStartMarker.set(loStartMarker.getX(), loStartMarker.getY() + (double)markerSize);
                }
            }
            Fill startFill = fPaletteEntry;
            if (fPaletteEntry instanceof MultipleFill && ((MultipleFill)fPaletteEntry).getFills().size() > 0) {
                startFill = (Fill)((MultipleFill)fPaletteEntry).getFills().get(0);
            }
            this.renderMarker(lg, ipr, mStart, loStartMarker, gs.getOutline(), startFill, dph, markerSize, false, false);
        }
        if ((mEnd = gs.getEndMarker()) != null && mEnd.isVisible()) {
            Location loEndMarker = goFactory.createLocation(bo.getLeft() + bo.getWidth() - 1.0, bo.getTop() + bo.getHeight() / 2.0);
            Position mEndPosition = this.transposePosition(gs.getEndMarkerPosition());
            switch (mEndPosition.getValue()) {
                case 0: {
                    if (!this.isTransposed()) break;
                    loEndMarker.set(loEndMarker.getX(), loEndMarker.getY() - (double)mEnd.getSize());
                    break;
                }
                case 1: {
                    if (!this.isTransposed()) break;
                    loEndMarker.set(loEndMarker.getX(), loEndMarker.getY() + (double)mEnd.getSize());
                }
            }
            Fill endFill = fPaletteEntry;
            if (fPaletteEntry instanceof MultipleFill && ((MultipleFill)fPaletteEntry).getFills().size() > 1) {
                endFill = (Fill)((MultipleFill)fPaletteEntry).getFills().get(1);
            }
            this.renderMarker(lg, ipr, mEnd, loEndMarker, gs.getOutline(), endFill, dph, markerSize, false, false);
        }
    }

    private Position transposePosition(Position p) {
        if (this.isTransposed()) {
            switch (p.getValue()) {
                case 0: {
                    return Position.RIGHT_LITERAL;
                }
                case 1: {
                    return Position.LEFT_LITERAL;
                }
                case 3: {
                    return Position.ABOVE_LITERAL;
                }
                case 2: {
                    return Position.BELOW_LITERAL;
                }
            }
        }
        return p;
    }

    @Override
    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
    }

    @Override
    public double[] computeDecorationThickness(IDisplayServer xs, OneAxis ax) throws ChartException {
        GanttSeries gs = (GanttSeries)this.getSeries();
        Label la = gs.getDecorationLabel();
        if (la != null && la.isVisible()) {
            int iOrientation = ax.getOrientation();
            if (iOrientation == 1) {
                double dMaxW = 0.0;
                GanttDataSet gds = (GanttDataSet)gs.getDataSet();
                DataSetIterator dsi = new DataSetIterator(gds);
                la = goFactory.copyOf(la);
                int pos = this.transposePosition(gs.getDecorationLabelPosition()).getValue();
                dsi.reset();
                String sValue = null;
                while (dsi.hasNext()) {
                    Object o = dsi.next();
                    if (o != null) {
                        sValue = ((GanttEntry)o).getLabel();
                    }
                    if (sValue == null || sValue.length() <= 0) continue;
                    la.getCaption().setValue(sValue);
                    double dW = this.cComp.computeWidth(xs, la);
                    if (!(dW > dMaxW)) continue;
                    dMaxW = dW;
                }
                if (pos == 2) {
                    return new double[]{dMaxW, 0.0};
                }
                return new double[]{0.0, dMaxW};
            }
            if (iOrientation == 0) {
                double dMaxH = 0.0;
                GanttDataSet gds = (GanttDataSet)gs.getDataSet();
                DataSetIterator dsi = new DataSetIterator(gds);
                la = goFactory.copyOf(la);
                int pos = this.transposePosition(gs.getDecorationLabelPosition()).getValue();
                dsi.reset();
                String sValue = null;
                while (dsi.hasNext()) {
                    Object o = dsi.next();
                    if (o != null) {
                        sValue = ((GanttEntry)o).getLabel();
                    }
                    if (sValue == null || sValue.length() <= 0) continue;
                    la.getCaption().setValue(sValue);
                    double dH = this.cComp.computeHeight(xs, la);
                    if (!(dH > dMaxH)) continue;
                    dMaxH = dH;
                }
                if (pos == 1) {
                    return new double[]{0.0, dMaxH};
                }
                return new double[]{dMaxH, 0.0};
            }
        }
        return new double[]{0.0, 0.0};
    }

    @Override
    public IAxesDecorator getAxesDecorator(OneAxis ax) {
        GanttSeries gs;
        Label la;
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        Axis baseAxis = cwa.getPrimaryBaseAxes()[0];
        if (ax.getModelAxis() == baseAxis && (la = (gs = (GanttSeries)this.getSeries()).getDecorationLabel()) != null && la.isVisible()) {
            return this;
        }
        return null;
    }

    @Override
    public void decorateAxes(IPrimitiveRenderer ipr, ISeriesRenderingHints isrh, OneAxis ax) throws ChartException {
        double dXTick2;
        GanttSeries gs = (GanttSeries)this.getSeries();
        Label la = gs.getDecorationLabel();
        if (la == null || !la.isVisible()) {
            return;
        }
        DataPointHints[] dpha = isrh.getDataPoints();
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        int pos = this.transposePosition(gs.getDecorationLabelPosition()).getValue();
        int iOrientation = ax.getOrientation();
        pos = iOrientation == 1 ? (pos == 2 ? 1 : 2) : (pos == 1 ? 8 : 4);
        la = goFactory.copyOf(la);
        Location loLabel = goFactory.createLocation(0.0, 0.0);
        double axisCoord = ax.getAxisCoordinate();
        int iMajorTickStyle = ax.getGrid().getTickStyle(0);
        double dXTick1 = (iMajorTickStyle & 1) == 1 ? axisCoord - 3.75 - 1.0 : axisCoord - 1.0;
        double d = dXTick2 = (iMajorTickStyle & 2) == 2 ? axisCoord + 3.75 + 1.0 : axisCoord + 1.0;
        if (iOrientation == 1) {
            if (pos == 1) {
                loLabel.setX(dXTick1);
            } else {
                loLabel.setX(dXTick2);
            }
        } else if (pos == 4) {
            loLabel.setY(dXTick1);
        } else {
            loLabel.setY(dXTick2);
        }
        int i = 0;
        while (i < dpha.length) {
            GanttEntry ge = (GanttEntry)dpha[i].getOrthogonalValue();
            if (this.isValidGanttEntry(ge) && ge.getLabel() != null && ge.getStart() != null && ge.getEnd() != null) {
                double fSize;
                la.getCaption().setValue(ge.getLabel());
                double d2 = fSize = srh.isCategoryScale() ? dpha[i].getSize() / 2.0 : 0.0;
                if (iOrientation == 1) {
                    loLabel.setY(dpha[i].getLocation().getY() + fSize);
                } else {
                    loLabel.setX(dpha[i].getLocation().getX() + fSize);
                }
                TextRenderEvent tre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(ax.getModelAxis()), TextRenderEvent.class);
                tre.setTextPosition(pos);
                tre.setLocation(loLabel);
                tre.setLabel(la);
                tre.setAction(2);
                ipr.drawText(tre);
            }
            ++i;
        }
    }

    private boolean isValidGanttEntry(GanttEntry entry) {
        return entry != null && entry.isValid();
    }

    @Override
    protected int checkEntryInRange(Object entry, Object min, Object max) {
        if (entry instanceof GanttEntry) {
            GanttEntry ge = (GanttEntry)entry;
            if (ge.getStart().before((Object)Methods.asDateTime(min))) {
                return 1;
            }
            if (ge.getEnd().after((Object)Methods.asDateTime(max))) {
                return 2;
            }
            return 0;
        }
        return super.checkEntryInRange(entry, min, max);
    }
}

