/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.docx.writer;

import java.io.IOException;
import org.eclipse.birt.report.engine.emitter.docx.writer.BasicComponent;
import org.eclipse.birt.report.engine.emitter.docx.writer.Document;
import org.eclipse.birt.report.engine.ooxml.IPart;

public class Footer
extends BasicComponent {
    Document document;
    int footerHeight;
    int footerWidth;
    boolean wrapFooter;

    Footer(IPart part, Document document, int footerHeight, int footerWidth) throws IOException {
        this(part, document, footerHeight, footerWidth, true);
    }

    Footer(IPart part, Document document, int footerHeight, int footerWidth, boolean wrapFooter) throws IOException {
        super(part);
        this.document = document;
        this.footerHeight = footerHeight;
        this.footerWidth = footerWidth;
        this.wrapFooter = wrapFooter;
    }

    @Override
    void start() {
        this.writer.startWriter();
        this.writer.openTag("w:ftr");
        this.writeXmlns();
        if (this.wrapFooter) {
            this.startHeaderFooterContainer(this.footerHeight, this.footerWidth);
        }
    }

    @Override
    void end() {
        if (this.wrapFooter) {
            this.endHeaderFooterContainer();
        }
        this.writer.closeTag("w:ftr");
        this.writer.endWriter();
        this.writer.close();
    }

    @Override
    protected int getImageID() {
        return this.document.getImageID();
    }

    @Override
    protected int getMhtTextId() {
        return this.document.getMhtTextId();
    }
}

