/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb.internal.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb.internal.impl.ProfileDriverUtil;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb.nls.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.services.PluginResourceLocator;

public class SampleDbFactory
implements IExecutableExtension {
    static final String PLUGIN_ID = "org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb";
    private static final String SAMPLEDB_PLUGIN_ID = "org.eclipse.birt.report.data.oda.sampledb";
    private static final String SAMPLE_DB_HOME_SUBDIR = "db";
    private static final String SAMPLE_DB_NAME = "BirtSample";
    private static final String SAMPLE_DB_JAR_FILE = "BirtSample.jar";
    private static final String SAMPLE_DB_LOG = "log";
    private static final String SAMPLE_DB_SEG = "seg0";
    private static final String PATH_SEPARATOR = "/";
    private static final String DRIVER_DEFN_NAME_RESOURCE_KEY = "%driver.definition.name";
    private static final String SAMPLEDB_DRIVER_DEFN_DEFAULT_NAME = "BIRT SampleDb Derby Embedded Driver";
    private static final String SAMPLEDB_DRIVER_DEFN_RESOURCE_KEY = "%driver.definition.name BIRT SampleDb Derby Embedded Driver";
    private static final String SAMPLEDB_DRIVER_DEFN_ID_PREFIX = "DriverDefn.org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb.driverTemplate.";
    static final String SAMPLEDB_DEFAULT_DRIVER_DEFN_ID = "DriverDefn.org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb.driverTemplate.BIRT SampleDb Derby Embedded Driver";
    private static final String PROFILE_NAME_RESOURCE_KEY = "%connection.profile.name";
    private static final String SAMPLEDB_DEFAULT_PROFILE_NAME = "BIRT Classic Models Sample Database";
    private static final String SAMPLEDB_PROFILE_NAME_RESOURCE_KEY = "%connection.profile.name BIRT Classic Models Sample Database";
    static final String SAMPLEDB_URL_RELATIVE_SUFFIX = "org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb/db/BirtSample";
    private static String sm_nlsDriverDefinitionId;
    private static String sm_nlsDriverDefinitionName;
    private static String sm_nlsSampleDbProfileName;

    static {
        sm_nlsDriverDefinitionName = SampleDbFactory.getLocalizedDriverDefinitionNameImpl();
        sm_nlsSampleDbProfileName = SampleDbFactory.getLocalizedSampleDbProfileNameImpl();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String stateLocation = SampleDbFactory.getSampleDbRootPath(PLUGIN_ID);
        try {
            this.initSampleDb(stateLocation);
            this.removeObsoleteDriverDefinition();
        }
        catch (IOException | RuntimeException ex) {
            ex.printStackTrace();
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    static String getSampleDbRootPath(String extensionPluginId) {
        IPath workLoc = PluginResourceLocator.getPluginStateLocation((String)extensionPluginId);
        if (workLoc == null) {
            workLoc = PluginResourceLocator.getPluginRootPath((String)extensionPluginId);
        }
        return workLoc != null ? workLoc.toOSString() : null;
    }

    private void initSampleDb(String rootPath) throws IOException, IllegalArgumentException {
        ZipEntry entry;
        String dbJarEntryName;
        URL fileURL;
        if (rootPath == null || rootPath.length() == 0 || !new File(rootPath).isDirectory()) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.sampleDbFactory_invalidDirectory, (Object)rootPath));
        }
        File dbDir = new File(rootPath + "/db");
        if (dbDir.exists()) {
            File[] subDir = dbDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(SampleDbFactory.SAMPLE_DB_NAME);
                }
            });
            if (subDir == null || subDir.length > 1) {
                throw new IllegalArgumentException(Messages.bind((String)Messages.sampleDbFactory_invalidDirectory, (Object)dbDir.toString()));
            }
            if (subDir.length == 1) {
                File sampleDb = subDir[0];
                if (!sampleDb.isDirectory()) {
                    throw new IllegalArgumentException(Messages.bind((String)Messages.sampleDbFactory_invalidDirectory, (Object)sampleDb.toString()));
                }
                File[] sampleDbFiles = sampleDb.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equals(SampleDbFactory.SAMPLE_DB_LOG) || name.equals(SampleDbFactory.SAMPLE_DB_SEG);
                    }
                });
                if (sampleDbFiles.length == 2) {
                    return;
                }
            }
        }
        if (!dbDir.exists()) {
            dbDir.mkdir();
        }
        if ((fileURL = PluginResourceLocator.getPluginEntry((String)SAMPLEDB_PLUGIN_ID, (String)(dbJarEntryName = "db/BirtSample.jar"))) == null) {
            throw new RuntimeException(Messages.bind((String)Messages.sampleDbFactory_noSampleDbJarFile, (Object)dbJarEntryName));
        }
        BufferedInputStream dbFileStream = new BufferedInputStream(fileURL.openStream());
        ZipInputStream zipStream = new ZipInputStream(dbFileStream);
        while ((entry = zipStream.getNextEntry()) != null) {
            int len;
            File entryFile = new File(dbDir, entry.getName());
            if (entry.isDirectory()) {
                entryFile.mkdirs();
                continue;
            }
            File parent = entryFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            FileOutputStream os = new FileOutputStream(entryFile);
            byte[] buf = new byte[4000];
            while ((len = zipStream.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, len);
            }
            ((OutputStream)os).close();
        }
        zipStream.close();
        ((InputStream)dbFileStream).close();
    }

    private void removeObsoleteDriverDefinition() {
        String driverDefnName = SampleDbFactory.getLocalizedDriverDefinitionName();
        ProfileDriverUtil.removeInvalidDriverDefinition(driverDefnName);
    }

    private static String getLocalizedDriverDefinitionName() {
        return sm_nlsDriverDefinitionName;
    }

    private static String getLocalizedDriverDefinitionNameImpl() {
        return PluginResourceLocator.getResourceString((String)PLUGIN_ID, (String)SAMPLEDB_DRIVER_DEFN_RESOURCE_KEY);
    }

    static String getLocalizedSampleDbProfileName() {
        return sm_nlsSampleDbProfileName;
    }

    private static String getLocalizedSampleDbProfileNameImpl() {
        return PluginResourceLocator.getResourceString((String)PLUGIN_ID, (String)SAMPLEDB_PROFILE_NAME_RESOURCE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getLocalizedDriverDefinitionId() {
        if (sm_nlsDriverDefinitionId != null) return sm_nlsDriverDefinitionId;
        Class<SampleDbFactory> clazz = SampleDbFactory.class;
        synchronized (SampleDbFactory.class) {
            if (sm_nlsDriverDefinitionId != null) return sm_nlsDriverDefinitionId;
            sm_nlsDriverDefinitionId = SAMPLEDB_DRIVER_DEFN_ID_PREFIX + SampleDbFactory.getLocalizedDriverDefinitionName();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_nlsDriverDefinitionId;
        }
    }
}

